/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.effects.stw.ImageCapture;
import org.eclipse.nebula.effects.stw.Transition;
import org.eclipse.nebula.effects.stw.TransitionListener;
import org.eclipse.nebula.effects.stw.Transitionable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;

public class TransitionManager {
    private int _lastItem = -1;
    Color backgroundColor;
    Image backgroundImage;
    private Transitionable _transitionable;
    private Transition _transition;
    private List<TransitionListener> _listeners;

    public TransitionManager(final Transitionable transitionable) {
        this._transitionable = transitionable;
        this._listeners = new ArrayList<TransitionListener>();
        this.backgroundColor = Display.getCurrent().getSystemColor(22);
        this._lastItem = transitionable.getSelection();
        transitionable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int currentItem = TransitionManager.this._transitionable.getSelection();
                    TransitionManager.this.startTransition(TransitionManager.this._lastItem, currentItem, transitionable.getDirection(currentItem, TransitionManager.this._lastItem));
                    TransitionManager.this._lastItem = currentItem;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public TransitionManager(final CTabFolder tabFolder) {
        this(new Transitionable(){

            @Override
            public void addSelectionListener(SelectionListener listener) {
                tabFolder.addSelectionListener(listener);
            }

            @Override
            public Control getControl(int index) {
                return tabFolder.getItem(index).getControl();
            }

            @Override
            public Composite getComposite() {
                return tabFolder;
            }

            @Override
            public int getSelection() {
                return tabFolder.getSelectionIndex();
            }

            @Override
            public void setSelection(int index) {
                tabFolder.setSelection(index);
            }

            @Override
            public double getDirection(int toIndex, int fromIndex) {
                return toIndex > fromIndex ? 0.0 : 180.0;
            }
        });
    }

    public TransitionManager(final TabFolder tabFolder) {
        this(new Transitionable(){

            @Override
            public void addSelectionListener(SelectionListener listener) {
                tabFolder.addSelectionListener(listener);
            }

            @Override
            public Control getControl(int index) {
                return tabFolder.getItem(index).getControl();
            }

            @Override
            public Composite getComposite() {
                return tabFolder;
            }

            @Override
            public int getSelection() {
                return tabFolder.getSelectionIndex();
            }

            @Override
            public void setSelection(int index) {
                tabFolder.setSelection(index);
            }

            @Override
            public double getDirection(int toIndex, int fromIndex) {
                return toIndex > fromIndex ? 0.0 : 180.0;
            }
        });
    }

    public void startTransition(int fromIndex, int toIndex, double direction) {
        try {
            this._transitionable.setSelection(fromIndex);
            Control from = this._transitionable.getControl(fromIndex);
            Rectangle size = from.getBounds();
            Image imgFrom = new Image((Device)from.getDisplay(), size.width, size.height);
            GC gcfrom = new GC((Drawable)from);
            from.update();
            gcfrom.copyArea(imgFrom, 0, 0);
            gcfrom.dispose();
            Control to = this._transitionable.getControl(toIndex);
            this._transitionable.setSelection(toIndex);
            Image imgTo = ImageCapture.getImage(to, size.width, size.height, true);
            this._transitionable.setSelection(fromIndex);
            Canvas canvas = new Canvas(this._transitionable.getComposite(), 0x20000000);
            canvas.moveAbove(null);
            canvas.setBounds(to.getBounds());
            GC gcOn = new GC((Drawable)canvas);
            this._transition.start(imgFrom, imgTo, gcOn, direction);
            this._transitionable.setSelection(toIndex);
            gcOn.dispose();
            canvas.dispose();
            for (TransitionListener tl : this._listeners) {
                tl.transitionFinished(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTransition(Transition transition) {
        this._transition = transition;
    }

    public Transition getTransition() {
        return this._transition;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public Transitionable getTransitionable() {
        return this._transitionable;
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        this._listeners.add(transitionListener);
    }

    public void removeTransitionListener(TransitionListener transitionListener) {
        this._listeners.remove(transitionListener);
    }
}

