/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.SeriesPrint;
import org.eclipse.nebula.paperclips.core.internal.util.PrintSizeStrategy;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class SeriesIterator
implements PrintIterator {
    final PrintIterator[] iters;
    int index;

    SeriesIterator(SeriesPrint print, Device device, GC gc) {
        this.iters = new PrintIterator[print.items.size()];
        int i = 0;
        while (i < this.iters.length) {
            this.iters[i] = ((Print)print.items.get(i)).iterator(device, gc);
            ++i;
        }
        this.index = 0;
    }

    SeriesIterator(SeriesIterator that) {
        this.iters = (PrintIterator[])that.iters.clone();
        int i = this.index;
        while (i < this.iters.length) {
            this.iters[i] = that.iters[i].copy();
            ++i;
        }
        this.index = that.index;
    }

    public boolean hasNext() {
        return this.index < this.iters.length;
    }

    private Point computeSize(PrintSizeStrategy strategy) {
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < this.iters.length) {
            PrintIterator iter = this.iters[i];
            Point printSize = strategy.computeSize(iter);
            width = Math.max(width, printSize.x);
            height = Math.max(height, printSize.y);
            ++i;
        }
        return new Point(width, height);
    }

    public Point minimumSize() {
        return this.computeSize(PrintSizeStrategy.MINIMUM);
    }

    public Point preferredSize() {
        return this.computeSize(PrintSizeStrategy.PREFERRED);
    }

    public PrintPiece next(int width, int height) {
        PrintIterator iter;
        PrintPiece printPiece;
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        if ((printPiece = PaperClips.next(iter = this.iters[this.index], width, height)) != null && !iter.hasNext()) {
            ++this.index;
        }
        return printPiece;
    }

    public PrintIterator copy() {
        return new SeriesIterator(this);
    }
}

