/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.border;

import org.eclipse.nebula.paperclips.core.border.AbstractBorderPainter;
import org.eclipse.nebula.paperclips.core.border.GapBorder;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class GapBorderPainter
extends AbstractBorderPainter {
    final int top;
    final int openTop;
    final int bottom;
    final int openBottom;
    final int left;
    final int right;

    GapBorderPainter(GapBorder target, Device device) {
        Point dpi = device.getDPI();
        this.top = GapBorderPainter.toPixels(target.top, dpi.y);
        this.bottom = GapBorderPainter.toPixels(target.bottom, dpi.y);
        this.openTop = GapBorderPainter.toPixels(target.openTop, dpi.y);
        this.openBottom = GapBorderPainter.toPixels(target.openBottom, dpi.y);
        this.left = GapBorderPainter.toPixels(target.left, dpi.x);
        this.right = GapBorderPainter.toPixels(target.right, dpi.x);
    }

    GapBorderPainter(GapBorderPainter that) {
        this.top = that.top;
        this.bottom = that.bottom;
        this.left = that.left;
        this.right = that.right;
        this.openTop = that.openTop;
        this.openBottom = that.openBottom;
    }

    static int toPixels(int points, int dpi) {
        return Math.max(0, points) * dpi / 72;
    }

    public int getBottom(boolean open) {
        return open ? this.openBottom : this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop(boolean open) {
        return open ? this.openTop : this.top;
    }

    public Point getOverlap() {
        return new Point(Math.min(this.left, this.right), Math.max(this.top, this.bottom));
    }

    public void paint(GC gc, int x, int y, int width, int height, boolean topOpen, boolean bottomOpen) {
    }

    public void dispose() {
    }
}

