/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.border.internal;

import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.border.BorderPainter;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class BorderPiece
implements PrintPiece {
    private final PrintPiece target;
    private final BorderPainter border;
    private final boolean topOpen;
    private final boolean bottomOpen;
    private final Point size;

    public BorderPiece(PrintPiece target, BorderPainter border, boolean topOpen, boolean bottomOpen) {
        Util.notNull(target, border);
        this.target = target;
        this.border = border;
        this.topOpen = topOpen;
        this.bottomOpen = bottomOpen;
        Point targetSize = target.getSize();
        this.size = new Point(targetSize.x + border.getWidth(), targetSize.y + border.getHeight(topOpen, bottomOpen));
    }

    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    public void paint(GC gc, int x, int y) {
        this.border.paint(gc, x, y, this.size.x, this.size.y, this.topOpen, this.bottomOpen);
        this.target.paint(gc, x + this.border.getLeft(), y + this.border.getTop(this.topOpen));
    }

    public void dispose() {
        this.border.dispose();
        this.target.dispose();
    }
}

