/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridCell;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.internal.GridCellImpl;
import org.eclipse.nebula.paperclips.core.grid.internal.GridIterator;
import org.eclipse.nebula.paperclips.core.internal.util.PaperClipsUtil;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public final class GridPrint
implements Print {
    public static final int REMAINDER = -1;
    public static final int PREFERRED = 0;
    public static final int BORDER_OVERLAP = -1;
    private GridLook look;
    final List columns;
    int[][] columnGroups = new int[0][];
    final List header = new ArrayList();
    private int headerCol = 0;
    final List body = new ArrayList();
    private int bodyCol = 0;
    boolean cellClippingEnabled = true;
    final List footer = new ArrayList();
    private int footerCol = 0;

    public GridPrint() {
        this(new GridColumn[0]);
    }

    public GridPrint(GridLook look) {
        this(new GridColumn[0], look);
    }

    public GridPrint(String columns) {
        this(GridPrint.parseColumns(columns));
    }

    public GridPrint(String columns, GridLook look) {
        this(GridPrint.parseColumns(columns), look);
    }

    public GridPrint(GridColumn[] columns) {
        Util.noNulls(columns);
        this.columns = new ArrayList();
        int i = 0;
        while (i < columns.length) {
            this.columns.add(columns[i]);
            ++i;
        }
        this.look = new DefaultGridLook();
    }

    public GridPrint(GridColumn[] columns, GridLook look) {
        this(columns);
        this.setLook(look);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + this.bodyCol;
        result = 31 * result + (this.cellClippingEnabled ? 1231 : 1237);
        result = 31 * result + GridPrint.hashCode(this.columnGroups);
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.footer == null ? 0 : this.footer.hashCode());
        result = 31 * result + this.footerCol;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + this.headerCol;
        result = 31 * result + (this.look == null ? 0 : this.look.hashCode());
        return result;
    }

    private static int hashCode(int[][] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = prime * result + (array[index] == null ? 0 : GridPrint.hashCode(array[index]));
            ++index;
        }
        return result;
    }

    private static int hashCode(int[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = prime * result + array[index];
            ++index;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridPrint other = (GridPrint)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.bodyCol != other.bodyCol) {
            return false;
        }
        if (this.cellClippingEnabled != other.cellClippingEnabled) {
            return false;
        }
        if (!Util.equal(this.columnGroups, other.columnGroups)) {
            return false;
        }
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.footer == null ? other.footer != null : !this.footer.equals(other.footer)) {
            return false;
        }
        if (this.footerCol != other.footerCol) {
            return false;
        }
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        if (this.headerCol != other.headerCol) {
            return false;
        }
        return !(this.look == null ? other.look != null : !this.look.equals(other.look));
    }

    public void addColumn(String column) {
        this.addColumn(this.columns.size(), GridColumn.parse(column));
    }

    public void addColumn(GridColumn column) {
        this.addColumn(this.columns.size(), column);
    }

    public void addColumn(int index, String column) {
        this.addColumn(index, GridColumn.parse(column));
    }

    public void addColumn(int index, GridColumn column) {
        this.checkColumnInsert(index);
        Util.notNull(column);
        this.columns.add(index, column);
        this.adjustForColumnInsert(index, 1);
    }

    public void addColumns(String columns) {
        this.addColumns(this.columns.size(), GridPrint.parseColumns(columns));
    }

    public void addColumns(GridColumn[] columns) {
        this.addColumns(this.columns.size(), columns);
    }

    public void addColumns(int index, String columns) {
        this.addColumns(index, GridPrint.parseColumns(columns));
    }

    public void addColumns(int index, GridColumn[] columns) {
        this.checkColumnInsert(index);
        Util.noNulls(columns);
        this.columns.addAll(index, Arrays.asList(columns));
        this.adjustForColumnInsert(index, columns.length);
    }

    private void checkColumnInsert(int index) {
        if (index < 0 || index > this.columns.size()) {
            PaperClips.error(6, "index = " + index + ", size = " + this.columns.size());
        }
    }

    private void adjustForColumnInsert(int index, int count) {
        this.adjustCellsForColumnInsert(this.header, index, count);
        this.adjustCellsForColumnInsert(this.body, index, count);
        this.adjustCellsForColumnInsert(this.footer, index, count);
        this.adjustColumnGroupsForColumnInsert(index, count);
        if (this.bodyCol > index) {
            this.bodyCol += count;
        }
        if (this.headerCol > index) {
            this.headerCol += count;
        }
        if (this.footerCol > index) {
            this.footerCol += count;
        }
    }

    private void adjustCellsForColumnInsert(List rows, int index, int count) {
        int rowI = 0;
        while (rowI < rows.size()) {
            List row = (List)rows.get(rowI);
            int col = 0;
            int cellI = 0;
            while (cellI < row.size()) {
                GridCell cell = (GridCell)row.get(cellI);
                if ((col += cell.getColSpan()) > index || col == index && (rowI + 1 < rows.size() || cellI + 1 < row.size())) {
                    row.set(cellI, new GridCellImpl(cell.getHorizontalAlignment(), cell.getVerticalAlignment(), cell.getContent(), cell.getColSpan() + count));
                    break;
                }
                ++cellI;
            }
            ++rowI;
        }
    }

    private void adjustColumnGroupsForColumnInsert(int index, int count) {
        int groupI = 0;
        while (groupI < this.columnGroups.length) {
            int[] group = this.columnGroups[groupI];
            int i = 0;
            while (i < group.length) {
                if (group[i] >= index) {
                    int n = i;
                    group[n] = group[n] + count;
                }
                ++i;
            }
            ++groupI;
        }
    }

    private static GridColumn[] parseColumns(String columns) {
        Util.notNull(columns);
        String[] cols = columns.split("\\s*,\\s*");
        GridColumn[] result = new GridColumn[cols.length];
        int i = 0;
        while (i < cols.length) {
            result[i] = GridColumn.parse(cols[i]);
            ++i;
        }
        return result;
    }

    public GridColumn[] getColumns() {
        return this.columns.toArray(new GridColumn[this.columns.size()]);
    }

    public void addHeader(Print cell) {
        this.headerCol = this.add(this.header, this.headerCol, -1, -1, cell, 1);
    }

    public void addHeader(int hAlignment, Print cell) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, -1, cell, 1);
    }

    public void addHeader(int hAlignment, int vAlignment, Print cell) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, vAlignment, cell, 1);
    }

    public void addHeader(Print cell, int colspan) {
        this.headerCol = this.add(this.header, this.headerCol, -1, -1, cell, colspan);
    }

    public void addHeader(int hAlignment, Print cell, int colspan) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, -1, cell, colspan);
    }

    public void addHeader(int hAlignment, int vAlignment, Print cell, int colspan) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, vAlignment, cell, colspan);
    }

    public GridCell[][] getHeaderCells() {
        return GridPrint.getGridCellArray(this.header);
    }

    public GridCell[][] getBodyCells() {
        return GridPrint.getGridCellArray(this.body);
    }

    public GridCell[][] getFooterCells() {
        return GridPrint.getGridCellArray(this.footer);
    }

    private static GridCell[][] getGridCellArray(List list) {
        GridCell[][] cells = new GridCell[list.size()][];
        int rowIndex = 0;
        while (rowIndex < cells.length) {
            List row = (List)list.get(rowIndex);
            GridCell[] rowCells = new GridCell[row.size()];
            int cellIndex = 0;
            while (cellIndex < rowCells.length) {
                rowCells[cellIndex] = (GridCell)row.get(cellIndex);
                ++cellIndex;
            }
            cells[rowIndex] = rowCells;
            ++rowIndex;
        }
        return cells;
    }

    public void add(Print cell) {
        this.bodyCol = this.add(this.body, this.bodyCol, -1, -1, cell, 1);
    }

    public void add(int hAlignment, Print cell) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, -1, cell, 1);
    }

    public void add(int hAlignment, int vAlignment, Print cell) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, vAlignment, cell, 1);
    }

    public void add(Print cell, int colspan) {
        this.bodyCol = this.add(this.body, this.bodyCol, -1, -1, cell, colspan);
    }

    public void add(int hAlignment, Print cell, int colspan) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, -1, cell, colspan);
    }

    public void add(int hAlignment, int vAlignment, Print cell, int colspan) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, vAlignment, cell, colspan);
    }

    public boolean isCellClippingEnabled() {
        return this.cellClippingEnabled;
    }

    public void setCellClippingEnabled(boolean cellClippingEnabled) {
        this.cellClippingEnabled = cellClippingEnabled;
    }

    public void addFooter(Print cell) {
        this.footerCol = this.add(this.footer, this.footerCol, -1, -1, cell, 1);
    }

    public void addFooter(int hAlignment, Print cell) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, -1, cell, 1);
    }

    public void addFooter(int hAlignment, int vAlignment, Print cell) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, vAlignment, cell, 1);
    }

    public void addFooter(Print cell, int colspan) {
        this.footerCol = this.add(this.footer, this.footerCol, -1, -1, cell, colspan);
    }

    public void addFooter(int hAlignment, Print cell, int colspan) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, -1, cell, colspan);
    }

    public void addFooter(int hAlignment, int vAlignment, Print cell, int colspan) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, vAlignment, cell, colspan);
    }

    private int add(List rows, int startColumn, int hAlignment, int vAlignment, Print cellContents, int colspan) {
        startColumn = this.startNewRowIfCurrentRowFull(startColumn);
        this.checkColumnSpan(startColumn, colspan);
        List row = this.getOpenRow(rows, startColumn);
        colspan = this.convertRemainderToExplicitColSpan(startColumn, colspan);
        GridCellImpl cell = new GridCellImpl(hAlignment, vAlignment, cellContents, colspan);
        row.add(cell);
        if ((startColumn += colspan) > this.columns.size()) {
            row.remove(row.size() - 1);
            if (row.size() == 0) {
                rows.remove(row);
            }
            PaperClips.error(5, "Colspan " + colspan + " too wide at column " + startColumn + " (" + this.columns.size() + " columns total)");
        }
        return startColumn;
    }

    private int convertRemainderToExplicitColSpan(int startColumn, int colspan) {
        if (colspan == -1) {
            colspan = this.columns.size() - startColumn;
        }
        return colspan;
    }

    private int startNewRowIfCurrentRowFull(int startColumn) {
        if (startColumn == this.columns.size()) {
            startColumn = 0;
        }
        return startColumn;
    }

    private void checkColumnSpan(int startColumn, int colspan) {
        if (startColumn + colspan > this.columns.size()) {
            PaperClips.error(5, "Colspan " + colspan + " too wide at column " + startColumn + " (" + this.columns.size() + " columns total)");
        }
    }

    private List getOpenRow(List rows, int startColumn) {
        ArrayList row;
        if (startColumn == 0) {
            row = new ArrayList(this.columns.size());
            rows.add(row);
        } else {
            row = (ArrayList)rows.get(rows.size() - 1);
        }
        return row;
    }

    public int[][] getColumnGroups() {
        return PaperClipsUtil.copy(this.columnGroups);
    }

    public void setColumnGroups(int[][] columnGroups) {
        this.checkColumnGroups(columnGroups);
        this.columnGroups = PaperClipsUtil.copy(columnGroups);
    }

    private void checkColumnGroups(int[][] columnGroups) {
        Util.notNull(columnGroups);
        int groupIndex = 0;
        while (groupIndex < columnGroups.length) {
            this.checkColumnGroup(columnGroups[groupIndex]);
            ++groupIndex;
        }
    }

    private void checkColumnGroup(int[] columnGroup) {
        Util.notNull(columnGroup);
        int columnInGroupIndex = 0;
        while (columnInGroupIndex < columnGroup.length) {
            this.checkColumnIndex(columnGroup[columnInGroupIndex]);
            ++columnInGroupIndex;
        }
    }

    private void checkColumnIndex(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            PaperClips.error(6, "Column index in column group must be 0 <= " + columnIndex + " < " + this.columns.size());
        }
    }

    public GridLook getLook() {
        return this.look;
    }

    public void setLook(GridLook look) {
        Util.notNull(look);
        this.look = look;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new GridIterator(this, device, gc);
    }
}

