/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.internal;

import org.eclipse.nebula.paperclips.core.LayerEntry;
import org.eclipse.nebula.paperclips.core.LayerEntryIterator;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.internal.LayerEntryIteratorImpl;
import org.eclipse.nebula.paperclips.core.internal.util.PaperClipsUtil;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class LayerEntryImpl
implements LayerEntry {
    private final Print target;
    private final int align;

    public LayerEntryImpl(Print target, int align) {
        Util.notNull(target);
        this.target = target;
        this.align = LayerEntryImpl.checkAlign(align);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.align;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerEntry other = (LayerEntry)obj;
        if (this.align != other.getHorizontalAlignment()) {
            return false;
        }
        return !(this.target == null ? other.getTarget() != null : !this.target.equals(other.getTarget()));
    }

    public Print getTarget() {
        return this.target;
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    private static int checkAlign(int align) {
        return PaperClipsUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072}, 16384);
    }

    public LayerEntryIterator iterator(Device device, GC gc) {
        return new LayerEntryIteratorImpl(this, device, gc);
    }
}

