/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.page;

import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.internal.util.PaperClipsUtil;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.nebula.paperclips.core.page.DefaultPageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class PageNumberPageDecoration
implements PageDecoration {
    FontData fontData = new FontData();
    int align = 16384;
    RGB rgb = new RGB(0, 0, 0);
    PageNumberFormat format = new DefaultPageNumberFormat();

    public PageNumberPageDecoration() {
    }

    public PageNumberPageDecoration(int align) {
        this.setAlign(align);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.align;
        result = 31 * result + (this.fontData == null ? 0 : this.fontData.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.rgb == null ? 0 : this.rgb.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageNumberPageDecoration other = (PageNumberPageDecoration)obj;
        if (this.align != other.align) {
            return false;
        }
        if (this.fontData == null ? other.fontData != null : !this.fontData.equals((Object)other.fontData)) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        return !(this.rgb == null ? other.rgb != null : !this.rgb.equals((Object)other.rgb));
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        Util.notNull(fontData);
        this.fontData = fontData;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align = this.checkAlign(align);
    }

    private int checkAlign(int align) {
        return PaperClipsUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072}, 16384);
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        Util.notNull(rgb);
        this.rgb = rgb;
    }

    public PageNumberFormat getFormat() {
        return this.format;
    }

    public void setFormat(PageNumberFormat format) {
        Util.notNull(format);
        this.format = format;
    }

    public Print createPrint(PageNumber pageNumber) {
        PageNumberPrint result = new PageNumberPrint(pageNumber);
        result.setFontData(this.fontData);
        result.setAlign(this.align);
        result.setPageNumberFormat(this.format);
        result.setRGB(this.rgb);
        return result;
    }
}

