/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.widgets.introspection.DefaultWidgetIntrospector;
import org.eclipse.nebula.visualization.internal.widgets.introspection.Introspectable;
import org.eclipse.nebula.visualization.widgets.datadefinition.ByteArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.datadefinition.DoubleArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.FloatArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.IPrimaryArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.IntArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.LongArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.ShortArrayWrapper;
import org.eclipse.nebula.visualization.widgets.figureparts.ColorMapRamp;
import org.eclipse.nebula.visualization.widgets.figureparts.ROIFigure;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class IntensityGraphFigure
extends Figure
implements Introspectable {
    private static final int MAX_ARRAY_SIZE = 10000000;
    private int dataWidth;
    private int dataHeight;
    private int cropLeft;
    private int cropRight;
    private int cropTop;
    private int cropBottom;
    private IPrimaryArrayWrapper dataArray;
    private IPrimaryArrayWrapper croppedDataArray;
    private int croppedDataWidth;
    private int croppedDataHeight;
    private double max;
    private double min;
    private ColorMapRamp colorMapRamp;
    private GraphArea graphArea;
    private ColorMap colorMap;
    private final Axis xAxis;
    private final Axis yAxis;
    private Range xAxisRange = null;
    private Range yAxisRange = null;
    private Rectangle originalCrop = null;
    private static final int GAP = 3;
    private Point start;
    private Point end;
    private boolean armed;
    private boolean dataDirty;
    private ImageData bufferedImageData;
    private Image bufferedImage;
    private List<IProfileDataChangeLisenter> profileListeners;
    private List<IPixelInfoProvider> pixelInfoProviders;
    private List<ICroppedDataSizeListener> croppedDataSizeListeners;
    private boolean runMode;
    private Map<String, ROIFigure> roiMap;
    private final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private final Color BLACK_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK);
    private final Color TRANSPARENT_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(123, 0, 23));
    private boolean inRGBMode = false;
    private ColorDepth colorDepth = ColorDepth.BIT8;
    private PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
    private Boolean savedShowRamp;
    private boolean isSingleLineProfiling = false;
    private Color roiColor = ColorConstants.cyan;

    public IntensityGraphFigure() {
        this(true);
    }

    public IntensityGraphFigure(boolean runMode) {
        this.runMode = runMode;
        this.dataArray = new DoubleArrayWrapper(new double[0]);
        this.max = 255.0;
        this.min = 0.0;
        this.dataWidth = 0;
        this.dataHeight = 0;
        this.profileListeners = new ArrayList<IProfileDataChangeLisenter>();
        this.colorMap = new ColorMap(ColorMap.PredefinedColorMap.GrayScale, true, true);
        this.colorMapRamp = new ColorMapRamp();
        this.colorMapRamp.setMax(this.max);
        this.colorMapRamp.setMin(this.min);
        this.colorMapRamp.setColorMap(this.colorMap);
        this.graphArea = new GraphArea();
        this.xAxis = new Axis("X", false);
        this.yAxis = new Axis("Y", true);
        this.add((IFigure)this.colorMapRamp);
        this.add((IFigure)this.graphArea);
        this.add((IFigure)this.xAxis);
        this.add((IFigure)this.yAxis);
        this.roiMap = new HashMap<String, ROIFigure>(2);
        this.setFocusTraversable(true);
        this.setRequestFocusEnabled(true);
    }

    public void addProfileDataListener(IProfileDataChangeLisenter listener) {
        if (listener != null) {
            this.profileListeners.add(listener);
        }
    }

    public void addPixelInfoProvider(IPixelInfoProvider pixelInfoProvider) {
        if (pixelInfoProvider != null) {
            if (this.pixelInfoProviders == null) {
                this.pixelInfoProviders = new ArrayList<IPixelInfoProvider>();
            }
            this.pixelInfoProviders.add(pixelInfoProvider);
        }
    }

    public void addCroppedDataSizeListener(ICroppedDataSizeListener listener) {
        if (this.croppedDataSizeListeners == null) {
            this.croppedDataSizeListeners = new ArrayList<ICroppedDataSizeListener>();
        }
        this.croppedDataSizeListeners.add(listener);
    }

    public void addROI(String name, IROIListener roiListener, IROIInfoProvider roiInfoProvider) {
        ROIFigure roiFigure = new ROIFigure(this, name, this.roiColor, roiListener, roiInfoProvider);
        this.roiMap.put(name, roiFigure);
        this.graphArea.add((IFigure)roiFigure);
    }

    public void removeROI(String name) {
        if (this.roiMap.containsKey(name)) {
            ROIFigure roiFigure = this.roiMap.get(name);
            this.roiMap.remove(name);
            this.graphArea.remove((IFigure)roiFigure);
        }
    }

    public void setROIVisible(String name, boolean visible) {
        if (this.roiMap.containsKey(name)) {
            this.roiMap.get(name).setVisible(visible);
        }
    }

    private double[] calculateXProfileData(IPrimaryArrayWrapper data, int dw, int dh) {
        double[] output = new double[dw];
        if (this.isSingleLineProfiling()) {
            PrecisionPoint dataloc = this.graphArea.getDataLocation(this.graphArea.crossHair.crossX, this.graphArea.crossHair.crossY);
            int i = 0;
            while (i < dw) {
                if (this.inRGBMode) {
                    int index = dataloc.y * dw * 3 + i * 3;
                    output[i] = (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                } else {
                    output[i] = data.get(dataloc.y * dw + i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dw) {
                int j = 0;
                while (j < dh) {
                    if (this.inRGBMode) {
                        int index = j * dw * 3 + i * 3;
                        int n = i;
                        output[n] = output[n] + (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                    } else {
                        int n = i;
                        output[n] = output[n] + data.get(j * dw + i);
                    }
                    ++j;
                }
                int n = i++;
                output[n] = output[n] / (double)dh;
            }
        }
        return output;
    }

    private double[] calculateYProfileData(IPrimaryArrayWrapper data, int dw, int dh) {
        double[] output = new double[dh];
        if (this.isSingleLineProfiling()) {
            PrecisionPoint dataloc = this.graphArea.getDataLocation(this.graphArea.crossHair.crossX, this.graphArea.crossHair.crossY);
            int i = 0;
            while (i < dh) {
                if (this.inRGBMode) {
                    int index = dataloc.x * 3 + i * dw * 3;
                    output[i] = (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                } else {
                    output[i] = data.get(dataloc.x + i * dw);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dh) {
                int j = 0;
                while (j < dw) {
                    if (this.inRGBMode) {
                        int index = i * dw * 3 + j * 3;
                        int n = i;
                        output[n] = output[n] + (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                    } else {
                        int n = i;
                        output[n] = output[n] + data.get(i * dw + j);
                    }
                    ++j;
                }
                int n = i++;
                output[n] = output[n] / (double)dw;
            }
        }
        return output;
    }

    public void dispose() {
        if (this.bufferedImage != null) {
            this.bufferedImage.dispose();
            this.bufferedImage = null;
        }
    }

    private ImageData drawRGBImage(IPrimaryArrayWrapper dataArray, int dataWidth, int dataHeight, double max, double min, ImageData imageData, boolean shrink) {
        if (dataWidth < 1 || dataHeight < 1 || dataWidth * dataHeight * 3 > dataArray.getSize() || dataWidth * dataHeight < 0) {
            return null;
        }
        if (imageData == null) {
            imageData = new ImageData(dataWidth, dataHeight, 24, this.palette);
        }
        if (shrink) {
            int height = imageData.height;
            int width = imageData.width;
            int x_ratio = (dataWidth << 16) / width + 1;
            int y_ratio = (dataHeight << 16) / height + 1;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int x2 = j * x_ratio >> 16;
                    int y2 = i * y_ratio >> 16;
                    int index = y2 * dataWidth * 3 + x2 * 3;
                    int pixel = this.calcRGBPixel(dataArray, max, min, index);
                    imageData.setPixel(j, i, pixel);
                    ++j;
                }
                ++i;
            }
        } else {
            int y = 0;
            while (y < dataHeight) {
                int x = 0;
                while (x < dataWidth) {
                    int index = y * dataWidth * 3 + x * 3;
                    int pixel = this.calcRGBPixel(dataArray, max, min, index);
                    imageData.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
        }
        return imageData;
    }

    protected int calcRGBPixel(IPrimaryArrayWrapper dataArray, double max, double min, int index) {
        int r = (int)dataArray.get(index);
        int g = (int)dataArray.get(index + 1);
        int b = (int)dataArray.get(index + 2);
        switch (this.colorDepth) {
            case BIT16: {
                r >>= 8;
                g >>= 8;
                b >>= 8;
                break;
            }
            case BIT24: {
                r >>= 16;
                g >>= 16;
                b >>= 16;
                break;
            }
            case BIT30: {
                r >>= 22;
                g >>= 22;
                b >>= 22;
                break;
            }
            case LOWER8BIT: {
                r &= 0xFF;
                b &= 0xFF;
                g &= 0xFF;
                break;
            }
            case SCALE: {
                r = (int)((dataArray.get(index) - min) / (max - min) * 255.0);
                g = (int)((dataArray.get(index + 1) - min) / (max - min) * 255.0);
                b = (int)((dataArray.get(index + 2) - min) / (max - min) * 255.0);
                break;
            }
        }
        int pixel = this.palette.getPixel(new RGB(r, g, b));
        return pixel;
    }

    private synchronized void fireProfileDataChanged(IPrimaryArrayWrapper data, int dw, int dh) {
        if (this.profileListeners.size() <= 0) {
            return;
        }
        double[] xProfileData = this.calculateXProfileData(data, dw, dh);
        double[] yProfileData = this.calculateYProfileData(data, dw, dh);
        for (IProfileDataChangeLisenter lisenter : this.profileListeners) {
            lisenter.profileDataChanged(xProfileData, yProfileData, this.xAxis.getRange(), this.yAxis.getRange());
        }
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public int getCropBottom() {
        return this.cropBottom;
    }

    public int getCropLeft() {
        return this.cropLeft;
    }

    public int getCropRight() {
        return this.cropRight;
    }

    public int getCropTop() {
        return this.cropTop;
    }

    public double[] getDataArray() {
        double[] data = new double[this.dataArray.getSize()];
        int i = 0;
        while (i < this.dataArray.getSize()) {
            data[i] = this.dataArray.get(i);
            ++i;
        }
        return data;
    }

    public int getDataHeight() {
        return this.dataHeight;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public GraphArea getGraphArea() {
        return this.graphArea;
    }

    public Dimension getGraphAreaInsets() {
        int width = this.getInsets().getWidth();
        int height = this.getInsets().getHeight();
        if (this.colorMapRamp.isVisible()) {
            width += this.colorMapRamp.getPreferredSize((int)this.getClientArea().width, (int)this.getClientArea().height).width + 3;
        }
        boolean yVisible = true;
        boolean xVisible = true;
        if (yVisible) {
            width += this.yAxis.getPreferredSize((int)this.getClientArea().width, (int)this.getClientArea().height).width;
            height += this.yAxis.getMargin();
            if (!xVisible) {
                height += this.yAxis.getMargin();
            }
        }
        if (xVisible) {
            height += this.xAxis.getPreferredSize((int)this.getClientArea().width, (int)this.getClientArea().height).height;
            if (!this.colorMapRamp.isVisible()) {
                width += this.xAxis.getMargin();
            }
            if (!yVisible) {
                width += this.xAxis.getMargin();
            }
        }
        return new Dimension(width, height);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public final Axis getXAxis() {
        return this.xAxis;
    }

    public final Axis getYAxis() {
        return this.yAxis;
    }

    public boolean isInRGBMode() {
        return this.inRGBMode;
    }

    public boolean isRunMode() {
        return this.runMode;
    }

    public boolean isShowRamp() {
        return this.colorMapRamp.isVisible();
    }

    protected void layout() {
        Rectangle clientArea = this.getClientArea().getCopy();
        Rectangle yAxisBounds = null;
        Rectangle xAxisBounds = null;
        boolean xVisible = true;
        boolean yVisible = true;
        if (yVisible) {
            Dimension yAxisSize = this.yAxis.getPreferredSize(clientArea.width, clientArea.height);
            yAxisBounds = new Rectangle(clientArea.x, clientArea.y, yAxisSize.width, yAxisSize.height);
            clientArea.x += yAxisSize.width;
            clientArea.y += this.yAxis.getMargin();
            clientArea.height = clientArea.height - (xVisible ? this.yAxis.getMargin() : 2 * this.yAxis.getMargin() - 1);
            clientArea.width -= yAxisSize.width;
        }
        if (xVisible) {
            Dimension xAxisSize = this.xAxis.getPreferredSize(clientArea.width, clientArea.height);
            xAxisBounds = new Rectangle(yVisible ? yAxisBounds.x + yAxisBounds.width - this.xAxis.getMargin() - 1 : clientArea.x, clientArea.y + clientArea.height - xAxisSize.height, xAxisSize.width, xAxisSize.height);
            clientArea.height -= xAxisSize.height;
            if (yVisible) {
                yAxisBounds.height -= xAxisSize.height - this.yAxis.getMargin();
            } else {
                clientArea.x += this.xAxis.getMargin();
                clientArea.width -= this.xAxis.getMargin() - 1;
            }
        }
        if (this.colorMapRamp.isVisible()) {
            Dimension rampSize = this.colorMapRamp.getPreferredSize(clientArea.width, clientArea.height);
            Rectangle rampBounds = new Rectangle(clientArea.x + clientArea.width - rampSize.width, clientArea.y, rampSize.width, clientArea.height);
            this.colorMapRamp.setBounds(rampBounds);
            clientArea.width -= rampSize.width + 3;
            if (xVisible) {
                xAxisBounds.width = yVisible ? (xAxisBounds.width -= rampSize.width + 3 - 2 * this.xAxis.getMargin()) : (xAxisBounds.width -= rampSize.width + 3 - this.xAxis.getMargin());
            }
        } else if (xVisible) {
            if (yVisible) {
                xAxisBounds.width += this.xAxis.getMargin();
            }
            clientArea.width -= this.xAxis.getMargin();
        }
        if (yVisible) {
            this.yAxis.setBounds(yAxisBounds);
        }
        if (xVisible) {
            this.xAxis.setBounds(xAxisBounds);
        }
        this.graphArea.setBounds(clientArea);
        super.layout();
    }

    public final void setColorMap(ColorMap colorMap) {
        if (colorMap == null) {
            return;
        }
        this.colorMap = colorMap;
        this.colorMapRamp.setColorMap(colorMap);
        this.dataDirty = true;
        this.repaint();
    }

    public final void setCropBottom(int cropBottom) {
        if (cropBottom < 0 || cropBottom + this.cropTop > this.dataHeight) {
            throw new IllegalArgumentException();
        }
        if (this.cropBottom == cropBottom) {
            return;
        }
        this.cropBottom = cropBottom;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setCropLeft(int cropLeft) {
        if (cropLeft < 0 || cropLeft + this.cropRight > this.dataWidth) {
            throw new IllegalArgumentException();
        }
        if (this.cropLeft == cropLeft) {
            return;
        }
        this.cropLeft = cropLeft;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setCropRight(int cropRight) {
        if (cropRight < 0 || cropRight + this.cropLeft > this.dataWidth) {
            throw new IllegalArgumentException();
        }
        if (this.cropRight == cropRight) {
            return;
        }
        this.cropRight = cropRight;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setCropTop(int cropTop) {
        if (cropTop < 0 || cropTop + this.cropBottom > this.dataHeight) {
            throw new IllegalArgumentException();
        }
        if (this.cropTop == cropTop) {
            return;
        }
        this.cropTop = cropTop;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setDataArray(double[] data) {
        if (this.dataArray instanceof DoubleArrayWrapper) {
            ((DoubleArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new DoubleArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(short[] data) {
        if (this.dataArray instanceof ShortArrayWrapper) {
            ((ShortArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new ShortArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(byte[] data) {
        if (this.dataArray instanceof ByteArrayWrapper) {
            ((ByteArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new ByteArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(int[] data) {
        if (this.dataArray instanceof IntArrayWrapper) {
            ((IntArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new IntArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(long[] data) {
        if (this.dataArray instanceof LongArrayWrapper) {
            ((LongArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new LongArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(float[] data) {
        if (this.dataArray instanceof FloatArrayWrapper) {
            ((FloatArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new FloatArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final synchronized void setDataArray(IPrimaryArrayWrapper dataWrapper) {
        this.dataArray = dataWrapper;
        this.croppedDataArray = null;
        this.dataDirty = true;
        this.graphArea.repaint();
    }

    public final void setDataHeight(int dataHeight) {
        if (dataHeight < 0 || this.dataWidth * dataHeight > 10000000 || this.dataWidth * dataHeight < 0) {
            throw new IllegalArgumentException();
        }
        if (this.dataHeight == dataHeight) {
            return;
        }
        this.dataHeight = dataHeight;
        this.updateCroppedDataSize();
        this.dataDirty = true;
        this.repaint();
    }

    public final void setDataWidth(int dataWidth) {
        if (dataWidth < 0 || dataWidth * this.dataHeight > 10000000 || dataWidth * this.dataHeight < 0) {
            throw new IllegalArgumentException();
        }
        if (this.dataWidth == dataWidth) {
            return;
        }
        this.dataWidth = dataWidth;
        this.updateCroppedDataSize();
        this.dataDirty = true;
        this.repaint();
    }

    public synchronized void setInRGBMode(boolean inRGBMode) {
        if (this.isInRGBMode() == inRGBMode) {
            return;
        }
        if (!this.isInRGBMode()) {
            if (this.savedShowRamp == null) {
                this.savedShowRamp = this.isShowRamp();
            }
            this.colorMapRamp.setVisible(false);
        } else if (this.savedShowRamp != null) {
            this.colorMapRamp.setVisible(this.savedShowRamp);
        }
        this.inRGBMode = inRGBMode;
        this.dataDirty = true;
        this.repaint();
    }

    public final void setMax(double max) {
        if (this.max == max) {
            return;
        }
        this.max = max;
        this.colorMapRamp.setMax(max);
        this.dataDirty = true;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.colorMapRamp.setFont(f);
    }

    public final void setMin(double min) {
        if (this.min == min) {
            return;
        }
        this.min = min;
        this.colorMapRamp.setMin(min);
        this.dataDirty = true;
        this.repaint();
    }

    public void setROIColor(Color roiColor) {
        this.roiColor = roiColor;
        for (ROIFigure f : this.roiMap.values()) {
            f.setROIColor(roiColor);
        }
    }

    public Color getRoiColor() {
        return this.roiColor;
    }

    public void setROIDataBounds(String name, int xIndex, int yIndex, int width, int height) {
        if (!this.roiMap.containsKey(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + " is not an existing ROI");
        }
        this.roiMap.get(name).setROIDataBounds(xIndex, yIndex, width, height);
    }

    public ROIFigure getROI(String name) {
        return this.roiMap.get(name);
    }

    public void setRunMode(boolean runMode) {
        this.runMode = runMode;
    }

    public void setShowRamp(boolean show) {
        if (this.isShowRamp() == show) {
            return;
        }
        if (!this.isInRGBMode()) {
            this.colorMapRamp.setVisible(show);
        }
        this.savedShowRamp = show;
        this.dataDirty = true;
        this.revalidate();
    }

    private void zoom() {
        if (this.xAxisRange == null || this.yAxisRange == null) {
            this.xAxisRange = this.xAxis.getRange();
            this.yAxisRange = this.yAxis.getRange();
        }
        if (this.originalCrop == null) {
            this.originalCrop = new Rectangle(this.cropLeft, this.cropTop, this.cropRight, this.cropBottom);
        }
        PrecisionPoint leftTop = this.graphArea.getDataLocation(Math.min(this.start.x, this.end.x), Math.min(this.start.y, this.end.y));
        PrecisionPoint rightBottom = this.graphArea.getDataLocation(Math.max(this.start.x, this.end.x), Math.max(this.start.y, this.end.y));
        if (leftTop == null || rightBottom == null || leftTop.equals((Object)rightBottom)) {
            return;
        }
        int toBeCropLeft = this.cropLeft + leftTop.x;
        int toBeCropTop = this.cropTop + leftTop.y;
        int toBeCropRight = this.cropRight + this.croppedDataWidth - rightBottom.x;
        int toBeCropBottom = this.cropBottom + this.croppedDataHeight - rightBottom.y;
        if (toBeCropLeft + toBeCropRight >= this.dataWidth || toBeCropBottom + toBeCropTop >= this.dataHeight) {
            return;
        }
        this.setCropLeft(toBeCropLeft);
        this.setCropTop(toBeCropTop);
        this.setCropRight(toBeCropRight);
        this.setCropBottom(toBeCropBottom);
        this.graphArea.repaint();
        double t1 = this.xAxis.getPositionValue(this.start.x, false);
        double t2 = this.xAxis.getPositionValue(this.end.x, false);
        this.xAxis.setRange(t1, t2, true);
        t1 = this.yAxis.getPositionValue(this.start.y, false);
        t2 = this.yAxis.getPositionValue(this.end.y, false);
        this.yAxis.setRange(t1, t2, true);
    }

    @Override
    public BeanInfo getBeanInfo() throws IntrospectionException {
        return new DefaultWidgetIntrospector().getBeanInfo(this.getClass());
    }

    public ColorDepth getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(ColorDepth colorDepth) {
        this.colorDepth = colorDepth;
        this.dataDirty = true;
        this.repaint();
    }

    public boolean isSingleLineProfiling() {
        return this.isSingleLineProfiling;
    }

    public void setSingleLineProfiling(boolean isSingleLineProfiling) {
        if (this.isSingleLineProfiling() == isSingleLineProfiling) {
            return;
        }
        this.isSingleLineProfiling = isSingleLineProfiling;
        this.graphArea.setSinglePixelProfiling(isSingleLineProfiling);
    }

    public String getPixelInfo(int xIndex, int yIndex, double xCoordinate, double yCoordinate, double pixelValue) {
        String result = "";
        if (this.pixelInfoProviders == null) {
            return result;
        }
        for (IPixelInfoProvider p : this.pixelInfoProviders) {
            result = String.valueOf(result) + " " + p.getPixelInfo(xIndex, yIndex, xCoordinate, yCoordinate, pixelValue);
        }
        return result;
    }

    protected void updateCroppedDataSize() {
        this.croppedDataWidth = this.dataWidth - this.cropLeft - this.cropRight;
        this.croppedDataHeight = this.dataHeight - this.cropTop - this.cropBottom;
        if (this.croppedDataSizeListeners != null) {
            for (ICroppedDataSizeListener listener : this.croppedDataSizeListeners) {
                listener.croppedDataSizeChanged(this.croppedDataWidth, this.croppedDataHeight);
            }
        }
    }

    public static enum ColorDepth {
        BIT8("8 bit"),
        BIT16("16 bit"),
        BIT24("24 bit"),
        BIT30("30 bit"),
        SCALE("Scaled to [Max, Min]"),
        LOWER8BIT("Use only lower 8 bits");

        private String description;

        private ColorDepth(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[ColorDepth.values().length];
            int i = 0;
            ColorDepth[] colorDepthArray = ColorDepth.values();
            int n = colorDepthArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorDepth p = colorDepthArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }

    public class GraphArea
    extends Figure {
        private static final int CURSOR_SIZE = 14;
        private SinglePixelProfileCrossHair crossHair;

        public GraphArea() {
            if (IntensityGraphFigure.this.runMode) {
                this.setCursor(null);
                GraphAreaZoomer zoomer = new GraphAreaZoomer();
                this.addMouseMotionListener((MouseMotionListener)zoomer);
                this.addMouseListener(zoomer);
            }
            this.setSinglePixelProfiling(IntensityGraphFigure.this.isSingleLineProfiling());
        }

        protected void setSinglePixelProfiling(boolean isSinglePixelProfiling) {
            if (!IntensityGraphFigure.this.runMode) {
                return;
            }
            if (IntensityGraphFigure.this.isSingleLineProfiling()) {
                if (this.crossHair == null) {
                    this.crossHair = new SinglePixelProfileCrossHair();
                }
                this.add((IFigure)this.crossHair);
            } else if (this.crossHair != null && this.crossHair.getParent() == this) {
                this.remove((IFigure)this.crossHair);
            }
            IntensityGraphFigure.this.dataDirty = true;
            this.repaint();
        }

        protected void layout() {
            Rectangle clientArea = this.getClientArea();
            if (IntensityGraphFigure.this.runMode && IntensityGraphFigure.this.isSingleLineProfiling()) {
                this.crossHair.setBounds(clientArea);
            }
            for (ROIFigure roiFigure : IntensityGraphFigure.this.roiMap.values()) {
                roiFigure.setBounds(clientArea);
            }
        }

        private synchronized IPrimaryArrayWrapper cropDataArray(int left, int right, int top, int bottom) {
            if ((left != 0 || right != 0 || top != 0 || bottom != 0) && (IntensityGraphFigure.this.dataWidth - left - right) * (IntensityGraphFigure.this.dataHeight - top - bottom) > 0) {
                int i = 0;
                if ((IntensityGraphFigure.this.dataWidth - left - right) * (IntensityGraphFigure.this.dataHeight - top - bottom) > 10000000) {
                    return IntensityGraphFigure.this.dataArray;
                }
                double[] result = null;
                if (IntensityGraphFigure.this.inRGBMode) {
                    result = new double[(IntensityGraphFigure.this.dataWidth - left - right) * (IntensityGraphFigure.this.dataHeight - top - bottom) * 3];
                    int y = top;
                    while (y < IntensityGraphFigure.this.dataHeight - bottom) {
                        int x = left;
                        while (x < IntensityGraphFigure.this.dataWidth - right) {
                            int p = y * IntensityGraphFigure.this.dataWidth * 3 + x * 3;
                            result[i] = IntensityGraphFigure.this.dataArray.get(p);
                            result[i + 1] = IntensityGraphFigure.this.dataArray.get(p + 1);
                            result[i + 2] = IntensityGraphFigure.this.dataArray.get(p + 2);
                            i += 3;
                            ++x;
                        }
                        ++y;
                    }
                } else {
                    result = new double[(IntensityGraphFigure.this.dataWidth - left - right) * (IntensityGraphFigure.this.dataHeight - top - bottom)];
                    int y = top;
                    while (y < IntensityGraphFigure.this.dataHeight - bottom) {
                        int x = left;
                        while (x < IntensityGraphFigure.this.dataWidth - right) {
                            result[i++] = IntensityGraphFigure.this.dataArray.get(y * IntensityGraphFigure.this.dataWidth + x);
                            ++x;
                        }
                        ++y;
                    }
                }
                return new DoubleArrayWrapper(result);
            }
            return IntensityGraphFigure.this.dataArray;
        }

        public PrecisionPoint getDataLocation(double x, double y) {
            Rectangle clientArea = this.getClientArea();
            double hIndex = (double)IntensityGraphFigure.this.croppedDataWidth * (x - (double)clientArea.x) / (double)clientArea.width;
            double vIndex = (double)IntensityGraphFigure.this.croppedDataHeight * (y - (double)clientArea.y) / (double)clientArea.height;
            return new PrecisionPoint(hIndex, vIndex);
        }

        public PrecisionPoint getGeoLocation(double xIndex, double yIndex) {
            Rectangle clientArea = this.getClientArea();
            if (IntensityGraphFigure.this.croppedDataHeight == 0 || IntensityGraphFigure.this.croppedDataWidth == 0) {
                return new PrecisionPoint(clientArea.x, clientArea.y);
            }
            double x = xIndex * (double)clientArea.width / (double)IntensityGraphFigure.this.croppedDataWidth + (double)clientArea.x;
            double y = yIndex * (double)clientArea.height / (double)IntensityGraphFigure.this.croppedDataHeight + (double)clientArea.y;
            return new PrecisionPoint(x, y);
        }

        protected synchronized void paintClientArea(Graphics graphics) {
            if (IntensityGraphFigure.this.dataArray == null) {
                return;
            }
            Rectangle clientArea = this.getClientArea();
            if (IntensityGraphFigure.this.dataDirty || IntensityGraphFigure.this.bufferedImage == null) {
                IntensityGraphFigure.this.dataDirty = false;
                if (IntensityGraphFigure.this.bufferedImage != null) {
                    IntensityGraphFigure.this.bufferedImage.dispose();
                    IntensityGraphFigure.this.bufferedImage = null;
                }
                if (clientArea.width < 0 || clientArea.height < 0) {
                    return;
                }
                if (IntensityGraphFigure.this.dataWidth == 0 || IntensityGraphFigure.this.dataHeight == 0 || !IntensityGraphFigure.this.isInRGBMode() && IntensityGraphFigure.this.dataArray.getSize() < IntensityGraphFigure.this.dataWidth * IntensityGraphFigure.this.dataHeight || IntensityGraphFigure.this.isInRGBMode() && IntensityGraphFigure.this.dataArray.getSize() < 3 * IntensityGraphFigure.this.dataWidth * IntensityGraphFigure.this.dataHeight) {
                    graphics.drawRectangle(new Rectangle(clientArea.x - (IntensityGraphFigure.this.yAxis.isVisible() ? 1 : 0), clientArea.y, clientArea.width - (IntensityGraphFigure.this.yAxis.isVisible() ? 0 : 1), clientArea.height - (IntensityGraphFigure.this.xAxis.isVisible() ? 0 : 1)));
                    if (IntensityGraphFigure.this.dataArray.getSize() == 0) {
                        graphics.drawText("No data.", clientArea.getLocation());
                    } else if (!IntensityGraphFigure.this.isInRGBMode() && IntensityGraphFigure.this.dataArray.getSize() < IntensityGraphFigure.this.dataWidth * IntensityGraphFigure.this.dataHeight) {
                        graphics.drawText("Size of input data is less than dataWidth*dataHeight!", clientArea.getLocation());
                    } else if (IntensityGraphFigure.this.isInRGBMode() && IntensityGraphFigure.this.dataArray.getSize() < 3 * IntensityGraphFigure.this.dataWidth * IntensityGraphFigure.this.dataHeight) {
                        graphics.drawText("Size of input data is less than 3*dataWidth*dataHeight!\nPlease make sure the data is in RGB mode.", clientArea.getLocation());
                    }
                    return;
                }
                if (IntensityGraphFigure.this.dataWidth - IntensityGraphFigure.this.cropLeft - IntensityGraphFigure.this.cropRight < 0 || IntensityGraphFigure.this.dataHeight - IntensityGraphFigure.this.cropTop - IntensityGraphFigure.this.cropBottom < 0) {
                    return;
                }
                IntensityGraphFigure.this.croppedDataArray = this.cropDataArray(IntensityGraphFigure.this.cropLeft, IntensityGraphFigure.this.cropRight, IntensityGraphFigure.this.cropTop, IntensityGraphFigure.this.cropBottom);
                IntensityGraphFigure.this.fireProfileDataChanged(IntensityGraphFigure.this.croppedDataArray, IntensityGraphFigure.this.croppedDataWidth, IntensityGraphFigure.this.croppedDataHeight);
                boolean shrink = false;
                if (clientArea.width * clientArea.height < IntensityGraphFigure.this.croppedDataHeight * IntensityGraphFigure.this.croppedDataWidth) {
                    shrink = true;
                }
                if (shrink) {
                    if (IntensityGraphFigure.this.bufferedImageData == null || ((IntensityGraphFigure)IntensityGraphFigure.this).bufferedImageData.width != clientArea.width || ((IntensityGraphFigure)IntensityGraphFigure.this).bufferedImageData.height != clientArea.height) {
                        IntensityGraphFigure.this.bufferedImageData = new ImageData(clientArea.width, clientArea.height, 24, IntensityGraphFigure.this.colorMap.getPalette());
                    }
                } else if (IntensityGraphFigure.this.bufferedImageData == null || ((IntensityGraphFigure)IntensityGraphFigure.this).bufferedImageData.width != IntensityGraphFigure.this.croppedDataWidth || ((IntensityGraphFigure)IntensityGraphFigure.this).bufferedImageData.height != IntensityGraphFigure.this.croppedDataHeight) {
                    IntensityGraphFigure.this.bufferedImageData = new ImageData(IntensityGraphFigure.this.croppedDataWidth, IntensityGraphFigure.this.croppedDataHeight, 24, IntensityGraphFigure.this.colorMap.getPalette());
                }
                ImageData imageData = null;
                if (IntensityGraphFigure.this.inRGBMode) {
                    try {
                        imageData = IntensityGraphFigure.this.drawRGBImage(IntensityGraphFigure.this.croppedDataArray, IntensityGraphFigure.this.croppedDataWidth, IntensityGraphFigure.this.croppedDataHeight, IntensityGraphFigure.this.max, IntensityGraphFigure.this.min, IntensityGraphFigure.this.bufferedImageData, shrink);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        graphics.drawText("Drawing Exception: RGB value is not between 0 and 255.\nPlease check if the data or color depth is correct.", clientArea.getLocation());
                    }
                } else {
                    imageData = IntensityGraphFigure.this.colorMap.drawImage(IntensityGraphFigure.this.croppedDataArray, IntensityGraphFigure.this.croppedDataWidth, IntensityGraphFigure.this.croppedDataHeight, IntensityGraphFigure.this.max, IntensityGraphFigure.this.min, IntensityGraphFigure.this.bufferedImageData, shrink);
                }
                if (imageData == null) {
                    return;
                }
                IntensityGraphFigure.this.bufferedImage = new Image((Device)Display.getCurrent(), imageData);
            }
            graphics.drawImage(IntensityGraphFigure.this.bufferedImage, new Rectangle(IntensityGraphFigure.this.bufferedImage.getBounds()), clientArea);
            if (IntensityGraphFigure.this.armed && IntensityGraphFigure.this.end != null && IntensityGraphFigure.this.start != null) {
                graphics.setLineStyle(3);
                graphics.setLineWidth(1);
                graphics.setForegroundColor(IntensityGraphFigure.this.BLACK_COLOR);
                graphics.drawRectangle(((IntensityGraphFigure)IntensityGraphFigure.this).start.x, ((IntensityGraphFigure)IntensityGraphFigure.this).start.y, ((IntensityGraphFigure)IntensityGraphFigure.this).end.x - ((IntensityGraphFigure)IntensityGraphFigure.this).start.x, ((IntensityGraphFigure)IntensityGraphFigure.this).end.y - ((IntensityGraphFigure)IntensityGraphFigure.this).start.y);
            }
            super.paintClientArea(graphics);
        }

        private synchronized void updateTextCursor(MouseEvent me) {
            double valueUnderMouse;
            int index;
            if (SWT.getPlatform().startsWith("rap")) {
                return;
            }
            if (IntensityGraphFigure.this.croppedDataArray == null) {
                return;
            }
            if (this.getCursor() != null) {
                this.getCursor().dispose();
            }
            double xCoordinate = IntensityGraphFigure.this.xAxis.getPositionValue(me.x, false);
            double yCoordinate = IntensityGraphFigure.this.yAxis.getPositionValue(me.y, false);
            PrecisionPoint dataLocation = this.getDataLocation(me.x, me.y);
            if (dataLocation == null) {
                return;
            }
            if (dataLocation.y * IntensityGraphFigure.this.croppedDataWidth + dataLocation.x >= IntensityGraphFigure.this.croppedDataArray.getSize()) {
                return;
            }
            if (IntensityGraphFigure.this.inRGBMode) {
                index = dataLocation.y * IntensityGraphFigure.this.croppedDataWidth * 3 + dataLocation.x * 3;
                if (index >= IntensityGraphFigure.this.croppedDataArray.getSize() - 3) {
                    return;
                }
                valueUnderMouse = (IntensityGraphFigure.this.croppedDataArray.get(index) + IntensityGraphFigure.this.croppedDataArray.get(index + 1) + IntensityGraphFigure.this.croppedDataArray.get(index + 2)) / 3.0;
            } else {
                index = dataLocation.y * IntensityGraphFigure.this.croppedDataWidth + dataLocation.x;
                if (index >= IntensityGraphFigure.this.croppedDataArray.getSize()) {
                    return;
                }
                valueUnderMouse = IntensityGraphFigure.this.croppedDataArray.get(index);
            }
            String text = "(" + IntensityGraphFigure.this.xAxis.format((Object)xCoordinate) + ", " + IntensityGraphFigure.this.yAxis.format((Object)yCoordinate) + ", " + IntensityGraphFigure.this.yAxis.format((Object)valueUnderMouse) + ")";
            text = String.valueOf(text) + IntensityGraphFigure.this.getPixelInfo(dataLocation.x + IntensityGraphFigure.this.cropLeft, dataLocation.y + IntensityGraphFigure.this.cropTop, xCoordinate, yCoordinate, valueUnderMouse);
            Dimension size = FigureUtilities.getTextExtents((String)text, (Font)Display.getDefault().getSystemFont());
            Image image = new Image((Device)Display.getDefault(), size.width + 14, size.height + 14);
            GC gc = SingleSourceHelper.getImageGC((Image)image);
            gc.setBackground(IntensityGraphFigure.this.TRANSPARENT_COLOR);
            gc.fillRectangle(image.getBounds());
            gc.setForeground(IntensityGraphFigure.this.BLACK_COLOR);
            gc.drawLine(0, 7, 14, 7);
            gc.drawLine(7, 0, 7, 14);
            gc.setBackground(IntensityGraphFigure.this.WHITE_COLOR);
            gc.fillRectangle(14, 14, image.getBounds().width - 14, image.getBounds().height - 14);
            gc.drawText(text, 14, 14, true);
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = imageData.palette.getPixel(IntensityGraphFigure.this.TRANSPARENT_COLOR.getRGB());
            this.setCursor(SingleSourceHelper.createCursor((Display)Display.getCurrent(), (ImageData)imageData, (int)7, (int)7, (int)2));
            gc.dispose();
            image.dispose();
        }
    }

    class GraphAreaZoomer
    extends MouseMotionListener.Stub
    implements MouseListener {
        GraphAreaZoomer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            if (IntensityGraphFigure.this.xAxisRange != null) {
                IntensityGraphFigure.this.xAxis.setRange(IntensityGraphFigure.this.xAxisRange);
            }
            if (IntensityGraphFigure.this.yAxisRange != null) {
                IntensityGraphFigure.this.yAxis.setRange(IntensityGraphFigure.this.yAxisRange);
            }
            if (IntensityGraphFigure.this.originalCrop != null) {
                IntensityGraphFigure.this.setCropLeft(((IntensityGraphFigure)IntensityGraphFigure.this).originalCrop.x);
                IntensityGraphFigure.this.setCropTop(((IntensityGraphFigure)IntensityGraphFigure.this).originalCrop.y);
                IntensityGraphFigure.this.setCropRight(((IntensityGraphFigure)IntensityGraphFigure.this).originalCrop.width);
                IntensityGraphFigure.this.setCropBottom(((IntensityGraphFigure)IntensityGraphFigure.this).originalCrop.height);
                IntensityGraphFigure.this.graphArea.repaint();
            }
        }

        public void mouseDragged(MouseEvent me) {
            if (!IntensityGraphFigure.this.armed) {
                return;
            }
            if (IntensityGraphFigure.this.graphArea.getClientArea().contains(me.getLocation())) {
                IntensityGraphFigure.this.graphArea.updateTextCursor(me);
                IntensityGraphFigure.this.end = me.getLocation();
                IntensityGraphFigure.this.graphArea.repaint();
            }
        }

        public void mouseMoved(MouseEvent me) {
            IntensityGraphFigure.this.graphArea.updateTextCursor(me);
        }

        public void mousePressed(MouseEvent me) {
            IntensityGraphFigure.this.requestFocus();
            if (me.button != 1) {
                return;
            }
            IntensityGraphFigure.this.armed = true;
            IntensityGraphFigure.this.start = me.getLocation();
            IntensityGraphFigure.this.end = null;
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (IntensityGraphFigure.this.armed && IntensityGraphFigure.this.end != null && IntensityGraphFigure.this.start != null) {
                IntensityGraphFigure.this.zoom();
            }
            IntensityGraphFigure.this.armed = false;
            IntensityGraphFigure.this.end = null;
            IntensityGraphFigure.this.start = null;
        }
    }

    public static interface ICroppedDataSizeListener {
        public void croppedDataSizeChanged(int var1, int var2);
    }

    public static interface IPixelInfoProvider {
        public String getPixelInfo(int var1, int var2, double var3, double var5, double var7);
    }

    public static interface IProfileDataChangeLisenter {
        public void profileDataChanged(double[] var1, double[] var2, Range var3, Range var4);
    }

    public static interface IROIInfoProvider {
        public String getROIInfo(int var1, int var2, int var3, int var4);
    }

    public static interface IROIListener {
        public void roiUpdated(int var1, int var2, int var3, int var4);
    }

    class SinglePixelProfileCrossHair
    extends Figure {
        private int crossX;
        private int crossY;
        private Point crossDataIndex;
        private boolean inDefaultPosition = true;
        private Polyline hLine = new Polyline();
        private Polyline vLine;
        private Figure crossPoint;

        public SinglePixelProfileCrossHair() {
            this.hLine.setCursor(Cursors.SIZENS);
            this.hLine.setForegroundColor(ColorConstants.yellow);
            this.hLine.setTolerance(3);
            this.hLine.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent me) {
                    SinglePixelProfileCrossHair.this.setCrossPosition(SinglePixelProfileCrossHair.this.crossX, me.y, true);
                    me.consume();
                }
            });
            this.hLine.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                }
            });
            this.vLine = new Polyline();
            this.vLine.setCursor(Cursors.SIZEWE);
            this.vLine.setForegroundColor(ColorConstants.yellow);
            this.vLine.setTolerance(3);
            this.vLine.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                }
            });
            this.vLine.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent me) {
                    SinglePixelProfileCrossHair.this.setCrossPosition(me.x, SinglePixelProfileCrossHair.this.crossY, true);
                    me.consume();
                }
            });
            this.crossPoint = new Figure();
            this.crossPoint.setCursor(Cursors.SIZEALL);
            this.crossPoint.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                }
            });
            this.crossPoint.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent me) {
                    SinglePixelProfileCrossHair.this.setCrossPosition(me.x, me.y, true);
                    me.consume();
                }
            });
            this.add((IFigure)this.hLine);
            this.add((IFigure)this.vLine);
            this.add((IFigure)this.crossPoint);
            this.addFigureListener(new FigureListener(){

                public void figureMoved(IFigure source) {
                    if (SinglePixelProfileCrossHair.this.crossDataIndex != null) {
                        PrecisionPoint p = IntensityGraphFigure.this.graphArea.getGeoLocation(((SinglePixelProfileCrossHair)SinglePixelProfileCrossHair.this).crossDataIndex.x, ((SinglePixelProfileCrossHair)SinglePixelProfileCrossHair.this).crossDataIndex.y);
                        SinglePixelProfileCrossHair.this.setCrossPosition(p.x, p.y, false);
                    }
                }
            });
            IntensityGraphFigure.this.addCroppedDataSizeListener(new ICroppedDataSizeListener(){

                @Override
                public void croppedDataSizeChanged(int croppedDataWidth, int croppedDataHeight) {
                    SinglePixelProfileCrossHair.this.crossDataIndex = (Point)IntensityGraphFigure.this.graphArea.getDataLocation(SinglePixelProfileCrossHair.this.crossX, SinglePixelProfileCrossHair.this.crossY);
                }
            });
        }

        public boolean containsPoint(int x, int y) {
            return this.hLine.containsPoint(x, y) || this.vLine.containsPoint(x, y) || this.crossPoint.containsPoint(x, y);
        }

        protected void layout() {
            Rectangle bounds = this.getBounds();
            if (this.inDefaultPosition) {
                this.setCrossPosition(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, true);
            } else {
                PrecisionPoint p = IntensityGraphFigure.this.graphArea.getGeoLocation(this.crossDataIndex.x, this.crossDataIndex.y);
                this.setCrossPosition(p.x, p.y, false);
            }
        }

        public void setCrossHairColor(Color crossHairColor) {
            this.hLine.setForegroundColor(crossHairColor);
            this.vLine.setForegroundColor(crossHairColor);
        }

        public void setCrossPosition(int x, int y, boolean updatedCrossDataIndex) {
            Rectangle bounds = this.getBounds();
            this.crossX = x < bounds.x ? bounds.x : (x >= bounds.x + bounds.width ? bounds.x + bounds.width - 1 : x);
            this.crossY = y < bounds.y ? bounds.y : (y >= bounds.y + bounds.height ? bounds.y + bounds.height - 1 : y);
            this.inDefaultPosition = false;
            if (updatedCrossDataIndex) {
                this.crossDataIndex = IntensityGraphFigure.this.graphArea.getDataLocation(this.crossX, this.crossY);
                if (IntensityGraphFigure.this.croppedDataArray != null) {
                    IntensityGraphFigure.this.fireProfileDataChanged(IntensityGraphFigure.this.croppedDataArray, IntensityGraphFigure.this.croppedDataWidth, IntensityGraphFigure.this.croppedDataHeight);
                }
            }
            this.hLine.setPoints(new PointList(new int[]{bounds.x, this.crossY, bounds.width + bounds.x, this.crossY}));
            this.vLine.setPoints(new PointList(new int[]{this.crossX, bounds.y, this.crossX, bounds.y + bounds.height}));
            this.crossPoint.setBounds(new Rectangle(this.crossX - 5, this.crossY - 5, 10, 10));
        }
    }
}

