/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class Gallery
extends Canvas {
    private static final String BUG_PLATFORM_LINUX_GTK_174932 = "gtk";
    protected static boolean DEBUG = false;
    GalleryItem[] items = null;
    private GalleryItem[] selection = null;
    protected int[] selectionFlags = null;
    boolean virtual = false;
    boolean virtualGroups = false;
    boolean virtualGroupsCompatibilityMode = false;
    int virtualGroupDefaultItemCount = 10;
    boolean vertical = true;
    boolean multi = false;
    int interpolation = 2;
    int antialias = 1;
    private int gHeight = 0;
    private int gWidth = 0;
    int lastIndexOf = 0;
    protected GalleryItem lastSingleClick = null;
    protected int translate = 0;
    boolean lowQualityOnUserAction = false;
    protected int lastTranslateValue = 0;
    protected int lastControlWidth = 0;
    protected int lastControlHeight = 0;
    protected int lastContentHeight = 0;
    protected int lastContentWidth = 0;
    protected int higherQualityDelay = 500;
    private boolean mouseClickHandled = false;
    private Color backgroundColor;
    private Color foregroundColor;
    private boolean useControlColors = false;
    AbstractGalleryItemRenderer itemRenderer;
    AbstractGalleryGroupRenderer groupRenderer;
    RedrawTimer redrawTimer = new RedrawTimer();

    public int getItemCount() {
        this.checkWidget();
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public void setItemCount(int count) {
        this.checkWidget();
        if (DEBUG) {
            System.out.println("setCount" + count);
        }
        if (count == 0) {
            this.items = null;
        } else {
            GalleryItem[] newItems = new GalleryItem[count];
            if (this.items != null) {
                System.arraycopy(this.items, 0, newItems, 0, Math.min(count, this.items.length));
            }
            this.items = newItems;
        }
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public AbstractGalleryItemRenderer getItemRenderer() {
        this.checkWidget();
        return this.itemRenderer;
    }

    public void setItemRenderer(AbstractGalleryItemRenderer itemRenderer) {
        this.checkWidget();
        this.itemRenderer = itemRenderer;
        if (this.itemRenderer != null) {
            this.itemRenderer.setGallery(this);
        }
        this.redraw();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void removeTreeListener(SelectionListener listener) {
        this.checkWidget();
        this.removeListener(17, (SWTEventListener)listener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.addListener(17, (Listener)new TypedListener((SWTEventListener)listener));
    }

    protected void sendPaintItemEvent(Item item, int index, GC gc, int x, int y, int width, int height) {
        Event e = new Event();
        e.item = item;
        e.type = 42;
        e.index = index;
        e.gc = gc;
        e.x = x;
        e.y = y;
        e.width = width;
        e.height = height;
        this.notifyListeners(42, e);
    }

    public boolean isLowQualityOnUserAction() {
        return this.lowQualityOnUserAction;
    }

    public void setLowQualityOnUserAction(boolean lowQualityOnUserAction) {
        this.lowQualityOnUserAction = lowQualityOnUserAction;
    }

    public int getHigherQualityDelay() {
        return this.higherQualityDelay;
    }

    public void setHigherQualityDelay(int higherQualityDelay) {
        this.higherQualityDelay = higherQualityDelay;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getAntialias() {
        return this.antialias;
    }

    public void setAntialias(int antialias) {
        this.antialias = antialias;
    }

    protected void notifySelectionListeners(GalleryItem item, int index, boolean isDefault) {
        Event e = new Event();
        e.widget = this;
        e.item = item;
        if (item != null) {
            e.data = item.getData();
        }
        try {
            if (isDefault) {
                this.notifyListeners(14, e);
            } else {
                this.notifyListeners(13, e);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    protected void notifyTreeListeners(GalleryItem item, boolean state) {
        Event e = new Event();
        e.widget = this;
        e.item = item;
        if (item != null) {
            e.data = item.getData();
        }
        try {
            this.notifyListeners(17, e);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public Gallery(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.virtual = (style & 0x10000000) > 0;
        this.vertical = (style & 0x200) > 0;
        this.multi = (style & 2) > 0;
        this.setForeground(this.getDisplay().getSystemColor(24));
        this._addDisposeListeners();
        this._addResizeListeners();
        this._addPaintListeners();
        this._addScrollBarsListeners();
        this._addMouseListeners();
        this._addKeyListeners();
        this._setDefaultRenderers();
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    private void _setDefaultRenderers() {
        DefaultGalleryGroupRenderer gr = new DefaultGalleryGroupRenderer();
        gr.setMinMargin(2);
        gr.setItemHeight(56);
        gr.setItemWidth(72);
        gr.setAutoMargin(true);
        gr.setGallery(this);
        this.groupRenderer = gr;
        this.itemRenderer = new DefaultGalleryItemRenderer();
        this.itemRenderer.setGallery(this);
    }

    private void _addDisposeListeners() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Gallery.this.onDispose();
            }
        });
    }

    private void _addPaintListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Gallery.this.onPaint(event.gc);
            }
        });
    }

    private void _addResizeListeners() {
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Gallery.this.updateStructuralValues(null, true);
                Gallery.this.updateScrollBarsProperties();
                Gallery.this.redraw();
            }
        });
    }

    private void _addScrollBarsListeners() {
        ScrollBar horizontalBar;
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (Gallery.this.vertical) {
                        Gallery.this.scrollVertical();
                    }
                }
            });
        }
        if ((horizontalBar = this.getHorizontalBar()) != null) {
            horizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (!Gallery.this.vertical) {
                        Gallery.this.scrollHorizontal();
                    }
                }
            });
        }
    }

    private void _addKeyListeners() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        GalleryItem newItem = Gallery.this.groupRenderer.getNextItem(Gallery.this.lastSingleClick, e.keyCode);
                        if (newItem == null) break;
                        Gallery.this._deselectAll(false);
                        Gallery.this.setSelected(newItem, true, true);
                        Gallery.this.lastSingleClick = newItem;
                        Gallery.this._showItem(newItem);
                        Gallery.this.redraw();
                        break;
                    }
                    case 13: {
                        GalleryItem[] selection = Gallery.this.getSelection();
                        GalleryItem item = null;
                        if (selection != null && selection.length > 0) {
                            item = selection[0];
                        }
                        Gallery.this.notifySelectionListeners(item, 0, true);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void showItem(GalleryItem item) {
        this.checkWidget();
        this._showItem(item);
    }

    void _showItem(GalleryItem item) {
        Rectangle rect = this.groupRenderer.getSize(item);
        if (rect == null) {
            return;
        }
        if (this.vertical) {
            int y = rect.y;
            int height = rect.height;
            if (y < this.translate) {
                this.translate = y;
            } else if (this.translate + this.getClientArea().height < y + height) {
                this.translate = y + height - this.getClientArea().height;
            }
        } else {
            int y = rect.x;
            int height = rect.width;
            if (y < this.translate) {
                this.translate = y;
            } else if (this.translate + this.getClientArea().width < y + height) {
                this.translate = y + height - this.getClientArea().width;
            }
        }
        this.updateScrollBarsProperties();
        this.redraw();
    }

    private void _addMouseListeners() {
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Gallery.this.onMouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                Gallery.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                Gallery.this.onMouseUp(e);
            }
        });
    }

    private void select(int from, int to) {
        int i = from;
        while (i <= to) {
            GalleryItem item = this.getItem(i);
            this._addSelection(item);
            item._selectAll();
            ++i;
        }
    }

    private void select(GalleryItem from, GalleryItem to) {
        GalleryItem toParent;
        GalleryItem fromParent = from.getParentItem();
        if (fromParent == (toParent = to.getParentItem())) {
            if (fromParent == null) {
                int fromIndex = this.indexOf(from);
                int toIndex = this.indexOf(to);
                this.select(fromIndex, toIndex);
            } else {
                int fromIndex = fromParent.indexOf(from);
                int toIndex = toParent.indexOf(to);
                fromParent.select(fromIndex, toIndex);
            }
        } else {
            int fromParentIndex = this.indexOf(fromParent);
            int toParentIndex = this.indexOf(toParent);
            int fromIndex = fromParent.indexOf(from);
            int toIndex = toParent.indexOf(to);
            fromParent.select(fromIndex, fromParent.getItemCount() - 1);
            int i = fromParentIndex + 1;
            while (i < toParentIndex) {
                this.getItem(i)._selectAll();
                ++i;
            }
            toParent.select(0, toIndex);
        }
        this.notifySelectionListeners(to, this.indexOf(to), false);
        this.redraw();
    }

    private boolean getOrder(GalleryItem before, GalleryItem after) {
        if (before == null || after == null) {
            return true;
        }
        GalleryItem newParent = before.getParentItem();
        GalleryItem oldParent = after.getParentItem();
        int beforeParentIndex = this.indexOf(newParent);
        int afterParentIndex = this.indexOf(oldParent);
        if (newParent == oldParent) {
            int oldParentIndex;
            int newParentIndex;
            if (newParent == null) {
                newParentIndex = this.indexOf(before);
                oldParentIndex = this.indexOf(after);
            } else {
                newParentIndex = newParent.indexOf(before);
                oldParentIndex = newParent.indexOf(after);
            }
            return newParentIndex < oldParentIndex;
        }
        return beforeParentIndex < afterParentIndex;
    }

    protected void setSelected(GalleryItem item, boolean selected, boolean notifyListeners) {
        if (selected) {
            if (!this.isSelected(item)) {
                this._addSelection(item);
            }
        } else if (this.isSelected(item)) {
            this._removeSelection(item);
        }
        if (notifyListeners) {
            GalleryItem notifiedItem = null;
            if (item != null && selected) {
                notifiedItem = item;
            } else if (this.selection != null && this.selection.length > 0) {
                notifiedItem = this.selection[this.selection.length - 1];
            }
            int index = -1;
            if (notifiedItem != null) {
                index = this.indexOf(notifiedItem);
            }
            this.notifySelectionListeners(notifiedItem, index, false);
        }
    }

    protected void _addSelection(GalleryItem item) {
        if (item == null) {
            return;
        }
        if (this.isSelected(item)) {
            return;
        }
        if (!this.multi) {
            this._deselectAll(false);
        }
        if (item.getParentItem() != null) {
            item.getParentItem()._addSelection(item);
        } else {
            int index = this.indexOf(item);
            int n = index >> 5;
            if (this.selectionFlags == null) {
                this.selectionFlags = new int[this.items.length + 31 >> 5];
            } else if (n >= this.selectionFlags.length) {
                int[] oldFlags = this.selectionFlags;
                this.selectionFlags = new int[n + 1];
                System.arraycopy(oldFlags, 0, this.selectionFlags, 0, oldFlags.length);
            }
            int n2 = n;
            this.selectionFlags[n2] = this.selectionFlags[n2] | 1 << (index & 0x1F);
        }
        if (this.selection == null) {
            this.selection = new GalleryItem[1];
        } else {
            GalleryItem[] oldSelection = this.selection;
            this.selection = new GalleryItem[oldSelection.length + 1];
            System.arraycopy(oldSelection, 0, this.selection, 0, oldSelection.length);
        }
        this.selection[this.selection.length - 1] = item;
    }

    private void _removeSelection(GalleryItem item) {
        int index;
        if (item.getParentItem() == null) {
            index = this._indexOf(item);
            int n = index >> 5;
            this.selectionFlags[n] = this.selectionFlags[n] & ~(1 << (index & 0x1F));
        } else {
            this._removeSelection(item.getParentItem(), item);
        }
        index = this._arrayIndexOf((Object[])this.selection, (Object)item);
        if (index == -1) {
            return;
        }
        this.selection = (GalleryItem[])this._arrayRemoveItem((Object[])this.selection, index);
    }

    protected void _removeSelection(GalleryItem parent, GalleryItem item) {
        int index = this._indexOf(parent, item);
        int n = index >> 5;
        parent.selectionFlags[n] = parent.selectionFlags[n] & ~(1 << (index & 0x1F));
    }

    protected boolean isSelected(GalleryItem item) {
        if (item == null) {
            return false;
        }
        if (item.getParentItem() != null) {
            return item.getParentItem().isSelected(item);
        }
        if (this.selectionFlags == null) {
            return false;
        }
        int index = this.indexOf(item);
        int n = index >> 5;
        if (n >= this.selectionFlags.length) {
            return false;
        }
        int flags = this.selectionFlags[n];
        return flags != 0 && (flags & 1 << (index & 0x1F)) != 0;
    }

    public void deselectAll() {
        this.checkWidget();
        this._deselectAll(false);
        this.redraw();
    }

    protected void _deselectAll(boolean notifyListeners) {
        int i;
        if (DEBUG) {
            System.out.println("clear");
        }
        this.selection = null;
        if (this.selectionFlags != null) {
            i = 0;
            while (i < this.selectionFlags.length) {
                this.selectionFlags[i] = 0;
                ++i;
            }
        }
        if (this.items == null) {
            return;
        }
        i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i]._deselectAll();
            }
            ++i;
        }
        if (notifyListeners) {
            this.notifySelectionListeners(null, -1, false);
        }
    }

    void onMouseDoubleClick(MouseEvent e) {
        GalleryItem item;
        if (DEBUG) {
            System.out.println("Mouse Double Click");
        }
        if ((item = this.getItem(new Point(e.x, e.y))) != null) {
            this.notifySelectionListeners(item, 0, true);
        }
        this.mouseClickHandled = true;
    }

    void onMouseUp(MouseEvent e) {
        if (DEBUG) {
            System.out.println("onMouseUp");
        }
        if (this.mouseClickHandled) {
            if (DEBUG) {
                System.out.println("onMouseUp : mouse event already handled");
            }
            return;
        }
        if (e.button == 1) {
            GalleryItem item = this.getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            if ((e.stateMask & SWT.MOD1) > 0) {
                this.onMouseHandleLeftMod1(e, item, false, true);
            } else if ((e.stateMask & 0x20000) > 0) {
                this.onMouseHandleLeftShift(e, item, false, true);
            } else {
                this.onMouseHandleLeft(e, item, false, true);
            }
        }
    }

    void onDispose() {
        if (!this.virtual) {
            this.removeAll();
        }
        if (this.itemRenderer != null) {
            this.itemRenderer.dispose();
        }
        if (this.groupRenderer != null) {
            this.groupRenderer.dispose();
        }
    }

    void onMouseDown(MouseEvent e) {
        if (DEBUG) {
            System.out.println("Mouse down ");
        }
        this.mouseClickHandled = false;
        if (!this._mouseDown(e)) {
            this.mouseClickHandled = true;
            return;
        }
        GalleryItem item = this.getItem(new Point(e.x, e.y));
        if (e.button == 1) {
            if (item == null) {
                this._deselectAll(true);
                this.redraw();
                this.mouseClickHandled = true;
                this.lastSingleClick = null;
            } else if ((e.stateMask & SWT.MOD1) > 0) {
                this.onMouseHandleLeftMod1(e, item, true, false);
            } else if ((e.stateMask & 0x20000) > 0) {
                this.onMouseHandleLeftShift(e, item, true, false);
            } else {
                this.onMouseHandleLeft(e, item, true, false);
            }
        } else if (e.button == 3) {
            this.onMouseHandleRight(e, item, true, false);
        }
    }

    private void onMouseHandleLeftMod1(MouseEvent e, GalleryItem item, boolean down, boolean up) {
        if (up && item != null) {
            if (DEBUG) {
                System.out.println("setSelected : inverse");
            }
            this.setSelected(item, !this.isSelected(item), true);
            this.lastSingleClick = item;
            this.redraw();
        }
    }

    private void onMouseHandleLeftShift(MouseEvent e, GalleryItem item, boolean down, boolean up) {
        if (up && this.lastSingleClick != null) {
            this._deselectAll(false);
            if (this.getOrder(item, this.lastSingleClick)) {
                this.select(item, this.lastSingleClick);
            } else {
                this.select(this.lastSingleClick, item);
            }
        }
    }

    void onMouseHandleLeft(MouseEvent e, GalleryItem item, boolean down, boolean up) {
        if (down) {
            if (!this.isSelected(item)) {
                this._deselectAll(false);
                if (DEBUG) {
                    System.out.println("setSelected");
                }
                this.setSelected(item, true, true);
                this.lastSingleClick = item;
                this.redraw();
                this.mouseClickHandled = true;
            }
        } else if (up) {
            if (item == null) {
                this._deselectAll(true);
            } else {
                if (DEBUG) {
                    System.out.println("setSelected");
                }
                this._deselectAll(false);
                this.setSelected(item, true, this.lastSingleClick != item);
                this.lastSingleClick = item;
            }
            this.redraw();
        }
    }

    void onMouseHandleRight(MouseEvent e, GalleryItem item, boolean down, boolean up) {
        if (down) {
            if (DEBUG) {
                System.out.println("right click");
            }
            if (item != null && !this.isSelected(item)) {
                this._deselectAll(false);
                this.setSelected(item, true, true);
                this.redraw();
                this.mouseClickHandled = true;
            }
        }
    }

    void onPaint(GC gc) {
        if (DEBUG) {
            System.out.println("paint");
        }
        boolean lowQualityPaint = this.lowQualityOnUserAction && (this.translate != this.lastTranslateValue || this.lastControlWidth != this.getSize().x || this.lastControlHeight != this.getSize().y || this.lastContentHeight != this.gHeight || this.lastContentWidth != this.gWidth);
        try {
            if (!SWT.getPlatform().equals(BUG_PLATFORM_LINUX_GTK_174932)) {
                gc.setAdvanced(true);
            }
            if (gc.getAdvanced()) {
                if (lowQualityPaint) {
                    gc.setAntialias(0);
                    gc.setInterpolation(0);
                } else {
                    gc.setAntialias(this.antialias);
                    gc.setInterpolation(this.interpolation);
                }
            }
            Rectangle clipping = gc.getClipping();
            gc.setBackground(this.getBackground());
            this.drawBackground(gc, clipping.x, clipping.y, clipping.width, clipping.height);
            int[] indexes = this.getVisibleItems(clipping);
            if (indexes != null && indexes.length > 0) {
                if (this.groupRenderer != null) {
                    this.groupRenderer.preDraw(gc);
                }
                if (this.itemRenderer != null) {
                    this.itemRenderer.preDraw(gc);
                }
                int i = indexes.length - 1;
                while (i >= 0) {
                    if (DEBUG) {
                        System.out.println("Drawing group " + indexes[i]);
                    }
                    this._drawGroup(gc, indexes[i]);
                    --i;
                }
                if (this.groupRenderer != null) {
                    this.groupRenderer.postDraw(gc);
                }
                if (this.itemRenderer != null) {
                    this.itemRenderer.postDraw(gc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.lowQualityOnUserAction) {
            this.lastTranslateValue = this.translate;
            this.lastControlWidth = this.getSize().x;
            this.lastControlHeight = this.getSize().y;
            this.lastContentHeight = this.gHeight;
            this.lastContentWidth = this.gWidth;
            if (lowQualityPaint) {
                Display.getCurrent().timerExec(this.higherQualityDelay, (Runnable)this.redrawTimer);
            }
        }
    }

    private int[] getVisibleItems(Rectangle clipping) {
        if (this.items == null) {
            return null;
        }
        int start = this.vertical ? clipping.y + this.translate : clipping.x + this.translate;
        int end = this.vertical ? clipping.y + clipping.height + this.translate : clipping.x + clipping.width + this.translate;
        ArrayList<Integer> al = new ArrayList<Integer>();
        int index = 0;
        GalleryItem item = null;
        while (index < this.items.length) {
            item = this.virtualGroups ? this._getItem(index, false) : this._getItem(index);
            if ((this.vertical ? item.y : item.x) > end) break;
            if ((this.vertical ? item.y + item.height : item.x + item.width) >= start) {
                al.add(new Integer(index));
            }
            ++index;
        }
        int[] result = new int[al.size()];
        int i = 0;
        while (i < al.size()) {
            result[i] = (Integer)al.get(i);
            ++i;
        }
        return result;
    }

    public void refresh(int index) {
        this.checkWidget();
        this.getItemCount();
    }

    public void redraw(GalleryItem item) {
        this.checkWidget();
        Rectangle bounds = item.getBounds();
        this.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    private void _drawGroup(GC gc, int index) {
        GalleryItem item = null;
        if (this.virtualGroups) {
            item = this._getItem(index, false);
            if (item.isUltraLazyDummy()) {
                boolean updateLocation = this.vertical && item.y < this.translate || !this.vertical && item.x < this.translate;
                int oldSize = item.height;
                item = this._getItem(index, true);
                if (this.virtualGroupsCompatibilityMode) {
                    int i = 0;
                    while (i < index) {
                        this._getItem(i);
                        ++i;
                    }
                }
                this.updateStructuralValues(item, false);
                if (DEBUG) {
                    System.out.println("old" + oldSize + " new " + item.height + " translate " + this.translate);
                }
                if (updateLocation) {
                    this.translate += item.height - oldSize;
                    if (DEBUG) {
                        System.out.println("updated to : " + this.translate);
                    }
                }
                this.updateScrollBarsProperties();
                this.redraw();
            }
        } else {
            item = this.getItem(index);
        }
        if (item == null) {
            return;
        }
        this.groupRenderer.setExpanded(item.isExpanded());
        int x = this.vertical ? item.x : item.x - this.translate;
        int y = this.vertical ? item.y - this.translate : item.y;
        Rectangle clipping = gc.getClipping();
        Rectangle previousClipping = new Rectangle(clipping.x, clipping.y, clipping.width, clipping.height);
        clipping.intersect(new Rectangle(x, y, item.width, item.height));
        gc.setClipping(clipping);
        this.groupRenderer.draw(gc, item, x, y, clipping.x, clipping.y, clipping.width, clipping.height);
        gc.setClipping(previousClipping);
    }

    private void updateItem(GalleryItem parentItem, int i, boolean create) {
        if (this.virtual) {
            if (parentItem == null) {
                GalleryItem galleryItem = this.items[i];
                if (galleryItem == null || this.virtualGroups && galleryItem.isUltraLazyDummy() && create) {
                    if (DEBUG) {
                        System.out.println("Virtual/creating item ");
                    }
                    this.items[i] = galleryItem = new GalleryItem(this, 0, i, false);
                    if (this.virtualGroups && !create) {
                        galleryItem.setItemCount(this.virtualGroupDefaultItemCount);
                        galleryItem.setUltraLazyDummy(true);
                        galleryItem.setExpanded(true);
                    } else {
                        this.setData(galleryItem, i);
                    }
                }
            } else {
                GalleryItem galleryItem = parentItem.items[i];
                if (galleryItem == null) {
                    if (DEBUG) {
                        System.out.println("Virtual/creating item ");
                    }
                    parentItem.items[i] = galleryItem = new GalleryItem(parentItem, 0, i, false);
                    this.setData(galleryItem, i);
                }
            }
        }
    }

    protected void setData(GalleryItem galleryItem, int index) {
        GalleryItem item = galleryItem;
        Event e = new Event();
        e.item = item;
        e.type = 36;
        e.index = index;
        this.notifyListeners(36, e);
    }

    protected void updateStructuralValues(boolean keepLocation) {
        this.updateStructuralValues(null, keepLocation);
    }

    protected void updateStructuralValues(GalleryItem changedGroup, boolean keepLocation) {
        if (DEBUG) {
            System.out.println("Client Area : " + this.getClientArea().x + " " + this.getClientArea().y + " " + this.getClientArea().width + " " + this.getClientArea().height);
        }
        Rectangle area = this.getClientArea();
        float pos = 0.0f;
        if (this.vertical) {
            if (this.gHeight > 0 && keepLocation) {
                pos = (float)((double)this.translate + 0.5 * (double)area.height) / (float)this.gHeight;
            }
            this.gWidth = area.width;
            this.gHeight = this.calculateSize(changedGroup);
            if (keepLocation) {
                this.translate = (int)((double)((float)this.gHeight * pos) - 0.5 * (double)area.height);
            }
        } else {
            if (this.gWidth > 0 && keepLocation) {
                pos = (float)((double)this.translate + 0.5 * (double)area.width) / (float)this.gWidth;
            }
            this.gWidth = this.calculateSize(changedGroup);
            this.gHeight = area.height;
            if (keepLocation) {
                this.translate = (int)((double)((float)this.gWidth * pos) - 0.5 * (double)area.width);
            }
        }
        this.validateTranslation();
        if (DEBUG) {
            System.out.println("Content Size : " + this.gWidth + " " + this.gHeight);
        }
    }

    private int calculateSize(GalleryItem onlyUpdateGroup) {
        if (this.groupRenderer == null) {
            return 0;
        }
        this.groupRenderer.preLayout(null);
        int currentHeight = 0;
        int mainItemCount = this.getItemCount();
        int i = 0;
        while (i < mainItemCount) {
            GalleryItem item = null;
            item = this.virtualGroups ? this._getItem(i, false) : this._getItem(i);
            if (onlyUpdateGroup != null && !((Object)((Object)onlyUpdateGroup)).equals((Object)item)) {
                if (this.vertical) {
                    item.y = currentHeight;
                    item.x = this.getClientArea().x;
                    currentHeight += item.height;
                } else {
                    item.y = this.getClientArea().y;
                    item.x = currentHeight;
                    currentHeight += item.width;
                }
            } else {
                this.groupRenderer.setExpanded(item.isExpanded());
                if (this.vertical) {
                    item.y = currentHeight;
                    item.x = this.getClientArea().x;
                    item.width = this.getClientArea().width;
                    item.height = -1;
                    this.groupRenderer.layout(null, item);
                    currentHeight += item.height;
                } else {
                    item.y = this.getClientArea().y;
                    item.x = currentHeight;
                    item.width = -1;
                    item.height = this.getClientArea().height;
                    this.groupRenderer.layout(null, item);
                    currentHeight += item.width;
                }
            }
            ++i;
        }
        this.groupRenderer.postLayout(null);
        return currentHeight;
    }

    protected void updateScrollBarsProperties() {
        if (this.vertical) {
            this.updateScrollBarProperties(this.getVerticalBar(), this.getClientArea().height, this.gHeight);
        } else {
            this.updateScrollBarProperties(this.getHorizontalBar(), this.getClientArea().width, this.gWidth);
        }
    }

    private void updateScrollBarProperties(ScrollBar bar, int clientSize, int totalSize) {
        if (bar == null) {
            return;
        }
        bar.setMinimum(0);
        bar.setPageIncrement(clientSize);
        bar.setMaximum(totalSize);
        bar.setThumb(clientSize);
        if (this.groupRenderer != null) {
            bar.setIncrement(this.groupRenderer.getScrollBarIncrement());
        }
        if (totalSize > clientSize) {
            if (DEBUG) {
                System.out.println("Enabling scrollbar");
            }
            bar.setEnabled(true);
            bar.setVisible(true);
            bar.setSelection(this.translate);
            this.validateTranslation();
        } else {
            if (DEBUG) {
                System.out.println("Disabling scrollbar");
            }
            bar.setEnabled(false);
            bar.setVisible(false);
            bar.setSelection(0);
            this.translate = 0;
        }
    }

    private void validateTranslation() {
        Rectangle area = this.getClientArea();
        int totalSize = 0;
        int clientSize = 0;
        if (this.translate < 0) {
            this.translate = 0;
        }
        if (this.vertical) {
            totalSize = this.gHeight;
            clientSize = area.height;
        } else {
            totalSize = this.gWidth;
            clientSize = area.width;
        }
        if (totalSize > clientSize) {
            if (this.translate + clientSize > totalSize) {
                this.translate = totalSize - clientSize;
            }
        } else {
            this.translate = 0;
        }
    }

    protected void scrollVertical() {
        int areaHeight = this.getClientArea().height;
        if (this.gHeight > areaHeight) {
            ScrollBar bar = this.getVerticalBar();
            this.scroll(0, this.translate - bar.getSelection(), 0, 0, this.getClientArea().width, areaHeight, false);
            this.translate = bar.getSelection();
        } else {
            this.translate = 0;
        }
    }

    protected void scrollHorizontal() {
        int areaWidth = this.getClientArea().width;
        if (this.gWidth > areaWidth) {
            ScrollBar bar = this.getHorizontalBar();
            this.scroll(this.translate - bar.getSelection(), 0, 0, 0, areaWidth, this.getClientArea().height, false);
            this.translate = bar.getSelection();
        } else {
            this.translate = 0;
        }
    }

    protected void addItem(GalleryItem item, int position) {
        if (position != -1 && (position < 0 || position > this.getItemCount())) {
            throw new IllegalArgumentException("ERROR_INVALID_RANGE ");
        }
        this._addItem(item, position);
    }

    private void _addItem(GalleryItem item, int position) {
        this.items = (GalleryItem[])this._arrayAddItem((Object[])this.items, (Object)item, position);
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
    }

    public GalleryItem getItem(int index) {
        this.checkWidget();
        return this._getItem(index);
    }

    protected GalleryItem _getItem(GalleryItem parent, int index) {
        if (index < parent.getItemCount()) {
            this.updateItem(parent, index, true);
            if (parent.items == null) {
                return null;
            }
            return parent.items[index];
        }
        return null;
    }

    protected GalleryItem _getItem(int index) {
        return this._getItem(index, true);
    }

    protected GalleryItem _getItem(int index, boolean create) {
        if (index < this.getItemCount()) {
            this.updateItem(null, index, create);
            return this.items[index];
        }
        return null;
    }

    protected boolean _mouseDown(MouseEvent e) {
        GalleryItem group;
        if (DEBUG) {
            System.out.println("getitem " + e.x + " " + e.y);
        }
        if ((group = this._getGroup(new Point(e.x, e.y))) != null) {
            int pos = this.vertical ? e.y + this.translate : e.x + this.translate;
            return this.groupRenderer.mouseDown(group, e, new Point(this.vertical ? e.x : pos, this.vertical ? pos : e.y));
        }
        return true;
    }

    public GalleryItem getItem(Point coords) {
        this.checkWidget();
        if (DEBUG) {
            System.out.println("getitem " + coords.x + " " + coords.y);
        }
        int pos = this.vertical ? coords.y + this.translate : coords.x + this.translate;
        GalleryItem group = this._getGroup(coords);
        if (group != null) {
            return this.groupRenderer.getItem(group, new Point(this.vertical ? coords.x : pos, this.vertical ? pos : coords.y));
        }
        return null;
    }

    private GalleryItem _getGroup(Point coords) {
        if (this.items == null) {
            return null;
        }
        int pos = this.vertical ? coords.y + this.translate : coords.x + this.translate;
        int index = 0;
        GalleryItem item = null;
        while (index < this.items.length) {
            item = this.getItem(index);
            if ((this.vertical ? item.y : item.x) > pos) break;
            if ((this.vertical ? item.y + item.height : item.x + item.width) >= pos) {
                return item;
            }
            ++index;
        }
        return null;
    }

    public GalleryItem getGroup(Point coords) {
        this.checkWidget();
        return this._getGroup(coords);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        if (this.items == null) {
            return;
        }
        if (this.virtual) {
            this.items = new GalleryItem[this.items.length];
        } else {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    if (all) {
                        this.items[i].clearAll(true);
                    } else {
                        this.items[i].clear();
                    }
                }
                ++i;
            }
        }
        this._deselectAll(false);
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public void clearAll() {
        this.clearAll(false);
    }

    public void clear(int index) {
        this.clear(index, false);
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        if (this.items[index] == null) {
            return;
        }
        if (this.virtual) {
            this.items[index] = null;
            this.updateStructuralValues(null, false);
            this.updateScrollBarsProperties();
        } else {
            this.items[index].clear();
            if (all) {
                this.items[index].clearAll(true);
            }
        }
        this.redraw();
    }

    public int indexOf(GalleryItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.getParentItem() == null) {
            return this._indexOf(item);
        }
        return this._indexOf(item.getParentItem(), item);
    }

    protected int _indexOf(GalleryItem item) {
        int itemCount = this.getItemCount();
        if (item == null) {
            SWT.error((int)4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < itemCount - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < itemCount / 2) {
            int i = 0;
            while (i < itemCount) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = itemCount - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    protected int _indexOf(GalleryItem parentItem, GalleryItem item) {
        int itemCount = parentItem.getItemCount();
        if (item == null) {
            SWT.error((int)4);
        }
        if (1 <= parentItem.lastIndexOf && parentItem.lastIndexOf < itemCount - 1) {
            if (parentItem.items[parentItem.lastIndexOf] == item) {
                return parentItem.lastIndexOf;
            }
            if (parentItem.items[parentItem.lastIndexOf + 1] == item) {
                return ++parentItem.lastIndexOf;
            }
            if (parentItem.items[parentItem.lastIndexOf - 1] == item) {
                return --parentItem.lastIndexOf;
            }
        }
        if (parentItem.lastIndexOf < itemCount / 2) {
            int i = 0;
            while (i < itemCount) {
                if (parentItem.items[i] == item) {
                    parentItem.lastIndexOf = i;
                    return parentItem.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = itemCount - 1;
            while (i >= 0) {
                if (parentItem.items[i] == item) {
                    parentItem.lastIndexOf = i;
                    return parentItem.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public GalleryItem[] getItems() {
        this.checkWidget();
        if (this.items == null) {
            return new GalleryItem[0];
        }
        GalleryItem[] itemsLocal = new GalleryItem[this.items.length];
        System.arraycopy(this.items, 0, itemsLocal, 0, this.items.length);
        return itemsLocal;
    }

    public boolean isUseControlColors() {
        return this.useControlColors;
    }

    public void setUseControlColors(boolean useControlColors) {
        this.useControlColors = useControlColors;
    }

    public Color getBackground() {
        return this.getBackground(false);
    }

    public Color getBackground(boolean galleryOnly) {
        if (galleryOnly) {
            return this.backgroundColor;
        }
        if (this.useControlColors) {
            return super.getBackground();
        }
        return this.backgroundColor != null ? this.backgroundColor : this.getDisplay().getSystemColor(25);
    }

    public Color getForeground() {
        return this.getForeground(false);
    }

    public Color getForeground(boolean galleryOnly) {
        if (galleryOnly) {
            return this.foregroundColor;
        }
        if (this.useControlColors) {
            return super.getForeground();
        }
        return this.foregroundColor != null ? this.foregroundColor : this.getDisplay().getSystemColor(24);
    }

    public void setBackground(Color color) {
        if (!this.useControlColors) {
            this.backgroundColor = color;
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        if (!this.useControlColors) {
            this.foregroundColor = color;
        }
        super.setForeground(color);
    }

    public boolean isVertical() {
        this.checkWidget();
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.checkWidget();
        this.vertical = vertical;
        this.updateStructuralValues(null, true);
        this.redraw();
    }

    public AbstractGalleryGroupRenderer getGroupRenderer() {
        return this.groupRenderer;
    }

    public void setGroupRenderer(AbstractGalleryGroupRenderer groupRenderer) {
        this.groupRenderer = groupRenderer;
        if (this.groupRenderer != null) {
            this.groupRenderer.setGallery(this);
        }
        this.updateStructuralValues(null, true);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public GalleryItem[] getSelection() {
        if (this.selection == null) {
            return new GalleryItem[0];
        }
        return this.selection;
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    public void selectAll() {
        this.checkWidget();
        this._selectAll();
        this.redraw();
    }

    protected void _selectAll() {
        this.select(0, this.getItemCount() - 1);
    }

    public void setSelection(GalleryItem[] items) {
        this.checkWidget();
        this._deselectAll(false);
        int i = 0;
        while (i < items.length) {
            this.setSelected(items[i], true, false);
            this._showItem(items[i]);
            this.lastSingleClick = items[i];
            ++i;
        }
        this.redraw();
    }

    public void removeAll() {
        this.checkWidget();
        if (this.items != null) {
            GalleryItem[] tmpArray = new GalleryItem[this.items.length];
            System.arraycopy(this.items, 0, tmpArray, 0, this.items.length);
            int i = 0;
            while (i < tmpArray.length) {
                if (tmpArray[i] != null) {
                    tmpArray[i]._dispose();
                }
                ++i;
            }
        }
    }

    public void remove(int index) {
        this.checkWidget();
        this._remove(index);
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public void remove(GalleryItem item) {
        if (item.getParentItem() == null) {
            this.remove(this.indexOf(item));
        } else {
            item.getParentItem().remove(item);
        }
    }

    protected void _remove(int index) {
        if (this.isSelected(this.items[index])) {
            this.setSelected(this.items[index], false, false);
        }
        this.items = (GalleryItem[])this._arrayRemoveItem((Object[])this.items, index);
    }

    protected void _remove(GalleryItem parent, int index) {
        if (this.isSelected(parent.items[index])) {
            this.setSelected(parent.items[index], false, false);
        }
        parent.items = (GalleryItem[])this._arrayRemoveItem((Object[])parent.items, index);
    }

    protected Object[] _arrayRemoveItem(Object[] array, int index) {
        if (array == null) {
            return null;
        }
        if (array.length == 1 && index == 0) {
            return null;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index + 1 < array.length) {
            System.arraycopy(array, index + 1, newArray, index, newArray.length - index);
        }
        return newArray;
    }

    protected Object[] _arrayAddItem(Object[] array, Object object, int index) {
        int length = 0;
        if (array != null) {
            length = array.length;
        }
        Object[] newArray = (Object[])Array.newInstance(object.getClass(), length + 1);
        if (array != null) {
            System.arraycopy(array, 0, newArray, 0, length);
        }
        if (index != -1) {
            int i = newArray.length - 2;
            while (i >= index) {
                if (i >= 0) {
                    newArray[i + 1] = newArray[i];
                }
                --i;
            }
            newArray[index] = object;
        } else {
            newArray[newArray.length - 1] = object;
        }
        return newArray;
    }

    protected int _arrayIndexOf(int[] array, int value) {
        if (array == null) {
            return -1;
        }
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected int _arrayIndexOf(Object[] array, Object value) {
        if (array == null) {
            return -1;
        }
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected int[] _arrayRemoveItem(int[] array, int index) {
        if (array == null) {
            return null;
        }
        if (array.length == 1 && index == 0) {
            return null;
        }
        int[] newArray = new int[array.length - 1];
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index + 1 < array.length) {
            System.arraycopy(array, index + 1, newArray, index, newArray.length - index);
        }
        return newArray;
    }

    public void _setGalleryItems(GalleryItem[] items) {
        this.items = items;
    }

    public boolean isVirtualGroups() {
        return this.virtualGroups;
    }

    public void setVirtualGroups(boolean virtualGroups) {
        this.virtualGroups = virtualGroups;
    }

    public int getVirtualGroupDefaultItemCount() {
        return this.virtualGroupDefaultItemCount;
    }

    public boolean isVirtualGroupsCompatibilityMode() {
        return this.virtualGroupsCompatibilityMode;
    }

    public void setVirtualGroupsCompatibilityMode(boolean compatibilityMode) {
        this.virtualGroupsCompatibilityMode = compatibilityMode;
    }

    public void setVirtualGroupDefaultItemCount(int defaultItemCount) {
        this.virtualGroupDefaultItemCount = defaultItemCount;
    }

    protected class RedrawTimer
    implements Runnable {
        protected RedrawTimer() {
        }

        public void run() {
            Gallery.this.redraw();
        }
    }
}

