/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GalleryItem
extends Item {
    private static final String EMPTY_STRING = "";
    private String[] text = new String[]{"", "", ""};
    protected GalleryItem[] items = null;
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected int marginBottom = 0;
    protected int hCount = 0;
    protected int vCount = 0;
    protected int lastIndexOf = 0;
    private boolean virtualGallery;
    private Gallery parent;
    private GalleryItem parentItem;
    protected int[] selectionFlags = null;
    protected Font font;
    protected Color foreground;
    protected Color background;
    private boolean ultraLazyDummy = false;
    private boolean expanded;

    protected boolean isUltraLazyDummy() {
        return this.ultraLazyDummy;
    }

    protected void setUltraLazyDummy(boolean ultraLazyDummy) {
        this.ultraLazyDummy = ultraLazyDummy;
    }

    public Gallery getParent() {
        return this.parent;
    }

    protected void setParent(Gallery parent) {
        this.parent = parent;
    }

    public GalleryItem getParentItem() {
        return this.parentItem;
    }

    protected void setParentItem(GalleryItem parentItem) {
        this.parentItem = parentItem;
    }

    public GalleryItem(Gallery parent, int style) {
        this(parent, style, -1, true);
    }

    public GalleryItem(Gallery parent, int style, int index) {
        this(parent, style, index, true);
    }

    public GalleryItem(GalleryItem parent, int style) {
        this(parent, style, -1, true);
    }

    public GalleryItem(GalleryItem parent, int style, int index) {
        this(parent, style, index, true);
    }

    protected GalleryItem(GalleryItem parent, int style, int index, boolean create) {
        super((Widget)parent, style);
        this.parent = parent.parent;
        this.parentItem = parent;
        if ((parent.getStyle() & 0x10000000) > 0) {
            this.virtualGallery = true;
        }
        if (create) {
            parent.addItem(this, index);
        }
    }

    protected GalleryItem(Gallery parent, int style, int index, boolean create) {
        super((Widget)parent, style);
        this.parent = parent;
        this.parentItem = null;
        if ((parent.getStyle() & 0x10000000) > 0) {
            this.virtualGallery = true;
        }
        if (create) {
            parent.addItem(this, index);
        }
    }

    protected void addItem(GalleryItem item, int position) {
        if (position != -1 && (position < 0 || position > this.getItemCount())) {
            throw new IllegalArgumentException("ERROR_INVALID_RANGE");
        }
        this._addItem(item, position);
    }

    private void _addItem(GalleryItem item, int position) {
        this.items = (GalleryItem[])this.parent._arrayAddItem((Object[])this.items, (Object)item, position);
        this.parent.updateStructuralValues(null, false);
        this.parent.updateScrollBarsProperties();
    }

    public int getItemCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public void setItemCount(int count) {
        if (count == 0) {
            this.items = null;
        } else {
            GalleryItem[] newItems = new GalleryItem[count];
            if (this.items != null) {
                System.arraycopy(this.items, 0, newItems, 0, Math.min(count, this.items.length));
            }
            this.items = newItems;
        }
    }

    public GalleryItem getItem(int index) {
        this.checkWidget();
        return this.parent._getItem(this, index);
    }

    public GalleryItem[] getItems() {
        this.checkWidget();
        if (this.items == null) {
            return new GalleryItem[0];
        }
        GalleryItem[] itemsLocal = new GalleryItem[this.items.length];
        System.arraycopy(this.items, 0, itemsLocal, 0, this.items.length);
        return itemsLocal;
    }

    public int indexOf(GalleryItem childItem) {
        this.checkWidget();
        return this.parent._indexOf(this, childItem);
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.parent.redraw(this);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this._setExpanded(expanded, true);
    }

    public void _setExpanded(boolean expanded, boolean redraw) {
        this.expanded = expanded;
        this.parent.updateStructuralValues(this, false);
        this.parent.updateScrollBarsProperties();
        if (redraw) {
            this.parent.redraw();
        }
    }

    public String getDescription() {
        return this.getText(1);
    }

    public void setDescription(String description) {
        this.setText(1, description);
    }

    public void deselectAll() {
        this.checkWidget();
        this._deselectAll();
        this.parent.redraw();
    }

    protected void _deselectAll() {
        int i;
        if (this.selectionFlags != null) {
            i = 0;
            while (i < this.selectionFlags.length) {
                this.selectionFlags[i] = 0;
                ++i;
            }
        }
        if (this.items == null) {
            return;
        }
        i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i]._deselectAll();
            }
            ++i;
        }
    }

    protected void _addSelection(GalleryItem item) {
        if (!this.parent.multi) {
            this._deselectAll();
        }
        if (item.getParentItem() == this) {
            int index = this.indexOf(item);
            int n = index >> 5;
            if (this.selectionFlags == null) {
                this.selectionFlags = new int[this.items.length + 31 >> 5];
            } else if (n >= this.selectionFlags.length) {
                int[] oldFlags = this.selectionFlags;
                this.selectionFlags = new int[n + 1];
                System.arraycopy(oldFlags, 0, this.selectionFlags, 0, oldFlags.length);
            }
            int n2 = n;
            this.selectionFlags[n2] = this.selectionFlags[n2] | 1 << (index & 0x1F);
        }
    }

    protected boolean isSelected(GalleryItem item) {
        if (item == null) {
            return false;
        }
        if (item.getParentItem() == this) {
            if (this.selectionFlags == null) {
                return false;
            }
            int index = this.indexOf(item);
            int n = index >> 5;
            if (n >= this.selectionFlags.length) {
                return false;
            }
            int flags = this.selectionFlags[n];
            return flags != 0 && (flags & 1 << (index & 0x1F)) != 0;
        }
        return false;
    }

    protected void select(int from, int to) {
        if (Gallery.DEBUG) {
            System.out.println("GalleryItem.select(  " + from + "," + to + ")");
        }
        int i = from;
        while (i <= to) {
            GalleryItem item = this.getItem(i);
            this.parent._addSelection(item);
            item._selectAll();
            ++i;
        }
    }

    public Rectangle getBounds() {
        if (this.parent.isVertical()) {
            return new Rectangle(this.x, this.y - this.parent.translate, this.width, this.height);
        }
        return new Rectangle(this.x - this.parent.translate, this.y, this.width, this.height);
    }

    public Font getFont() {
        return this.getFont(false);
    }

    public Font getFont(boolean itemOnly) {
        this.checkWidget();
        if (itemOnly) {
            return this.font;
        }
        if (this.parent.getGroupRenderer() != null) {
            return this.parent.getGroupRenderer().getFont(this);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.font = font;
        this.parent.redraw(this);
    }

    public Color getForeground() {
        return this.getForeground(false);
    }

    public Color getForeground(boolean itemOnly) {
        this.checkWidget();
        if (itemOnly) {
            return this.foreground;
        }
        if (this.parent.getGroupRenderer() != null) {
            return this.parent.getGroupRenderer().getForeground(this);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public void setForeground(Color foreground) {
        this.checkWidget();
        if (foreground != null && foreground.isDisposed()) {
            SWT.error((int)5);
        }
        this.foreground = foreground;
        this.parent.redraw(this);
    }

    public Color getBackground() {
        return this.getBackground(false);
    }

    public Color getBackground(boolean itemOnly) {
        this.checkWidget();
        if (itemOnly) {
            return this.background;
        }
        if (this.parent.getGroupRenderer() != null) {
            return this.parent.getGroupRenderer().getBackground(this);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public void setBackground(Color background) {
        this.checkWidget();
        if (background != null && background.isDisposed()) {
            SWT.error((int)5);
        }
        this.background = background;
        this.parent.redraw(this);
    }

    public void clear() {
        this.checkWidget();
        this.text[0] = EMPTY_STRING;
        this.text[1] = EMPTY_STRING;
        this.text[2] = EMPTY_STRING;
        super.setImage(null);
        this.font = null;
        this.background = null;
        this.foreground = null;
        this.parent.redraw(this);
    }

    public void clearAll() {
        this.clearAll(false);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        if (this.items == null) {
            return;
        }
        if (this.virtualGallery) {
            this.items = new GalleryItem[this.items.length];
        } else {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    if (all) {
                        this.items[i].clearAll(true);
                    }
                    this.items[i].clear();
                }
                ++i;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        this._selectAll();
        this.parent.redraw();
    }

    protected void _selectAll() {
        this.select(0, this.getItemCount() - 1);
    }

    public void remove(int index) {
        this.checkWidget();
        this.parent._remove(this, index);
        this.parent.updateStructuralValues(null, false);
        this.parent.updateScrollBarsProperties();
        this.parent.redraw();
    }

    public void remove(GalleryItem item) {
        this.remove(this.indexOf(item));
    }

    protected void _dispose() {
        this.removeFromParent();
        this._disposeChildren();
        super.dispose();
    }

    protected void _disposeChildren() {
        if (this.items != null) {
            while (this.items != null) {
                if (this.items[this.items.length - 1] != null) {
                    this.items[this.items.length - 1]._dispose();
                    continue;
                }
                this.parent._remove(this, this.items.length - 1);
            }
        }
    }

    protected void removeFromParent() {
        if (this.parentItem != null) {
            int index = this.parent._indexOf(this.parentItem, this);
            this.parent._remove(this.parentItem, index);
        } else {
            int index = this.parent._indexOf(this);
            this.parent._remove(index);
        }
    }

    public void dispose() {
        this.checkWidget();
        this.removeFromParent();
        this._disposeChildren();
        super.dispose();
        this.parent.updateStructuralValues(null, false);
        this.parent.updateScrollBarsProperties();
        this.parent.redraw();
    }

    public void setText(String string) {
        this.setText(0, string);
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.text[index] = string;
        this.parent.redraw(this);
    }

    public String getText() {
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        return this.text[index];
    }
}

