/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RichTextCellEditor
extends AbstractCellEditor {
    protected RichTextEditor editor = null;
    protected ToolbarConfiguration toolbarConfiguration;
    protected int style;

    public RichTextCellEditor() {
        this(null, 16);
    }

    public RichTextCellEditor(ToolbarConfiguration toolbarConfiguration) {
        this(toolbarConfiguration, 16);
    }

    public RichTextCellEditor(int style) {
        this(null, style);
    }

    public RichTextCellEditor(ToolbarConfiguration toolbarConfiguration, int style) {
        if (toolbarConfiguration == null) {
            toolbarConfiguration = new ToolbarConfiguration();
            toolbarConfiguration.toolbarCollapsible = true;
            toolbarConfiguration.toolbarInitialExpanded = true;
        }
        this.toolbarConfiguration = toolbarConfiguration;
        this.style = style | 0x1000000;
    }

    public Object getEditorValue() {
        return this.editor.getText();
    }

    public void setEditorValue(Object value) {
        this.editor.setText(value != null ? (String)value : "");
    }

    public Control getEditorControl() {
        return this.editor;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.editor = this.createEditorControl(parent);
        this.setCanonicalValue(originalCanonicalValue);
        this.editor.forceFocus();
        return this.editor;
    }

    public RichTextEditor createEditorControl(Composite parent) {
        this.editor = new RichTextEditor(parent, this.toolbarConfiguration, this.style){

            protected int getMinimumHeight() {
                return RichTextCellEditor.this.getMinimumDimension().y;
            }

            protected int getMinimumWidth() {
                return RichTextCellEditor.this.getMinimumDimension().x;
            }
        };
        this.editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    RichTextCellEditor.this.close();
                }
                if (e.keyCode == 13 && e.stateMask == SWT.MOD1) {
                    RichTextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                }
            }
        });
        return this.editor;
    }

    protected Point getMinimumDimension() {
        return new Point(370, 200);
    }
}

