/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RichTextCellEditor
extends CellEditor {
    protected RichTextEditor editor;
    protected ToolbarConfiguration toolbarConfiguration;
    private ModifyListener modifyListener;

    public RichTextCellEditor(Composite parent) {
        this(parent, null, 16);
    }

    public RichTextCellEditor(Composite parent, ToolbarConfiguration toolbarConfiguration) {
        this(parent, toolbarConfiguration, 16);
    }

    public RichTextCellEditor(Composite parent, int style) {
        this(parent, null, style);
    }

    public RichTextCellEditor(Composite parent, ToolbarConfiguration toolbarConfiguration, int style) {
        super(parent, style | 0x1000000);
        this.toolbarConfiguration = toolbarConfiguration;
        super.create(parent);
    }

    public void create(Composite parent) {
    }

    protected Control createControl(Composite parent) {
        this.editor = new RichTextEditor(parent, this.toolbarConfiguration, this.getStyle()){

            @Override
            protected int getMinimumHeight() {
                return RichTextCellEditor.this.getMinimumDimension().y;
            }

            @Override
            protected int getMinimumWidth() {
                return RichTextCellEditor.this.getMinimumDimension().x;
            }
        };
        this.editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    RichTextCellEditor.this.fireCancelEditor();
                }
                if (e.keyCode == 13 && e.stateMask == SWT.MOD1) {
                    RichTextCellEditor.this.fireApplyEditorValue();
                }
                if (RichTextCellEditor.this.getControl() == null || RichTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
            }
        });
        this.editor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                RichTextCellEditor.this.focusLost();
            }
        });
        this.editor.addModifyListener(this.getModifyListener());
        return this.editor;
    }

    protected Point getMinimumDimension() {
        return new Point(370, 200);
    }

    protected Object doGetValue() {
        return this.editor.getText();
    }

    protected void doSetFocus() {
        if (this.editor != null && !this.editor.isDisposed()) {
            this.editor.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.editor != null ? 1 : 0) != 0);
        this.editor.removeModifyListener(this.getModifyListener());
        this.editor.setText(value != null ? (String)value : "");
        this.editor.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.editor.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RichTextCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    public RichTextEditor getRichTextEditor() {
        return (RichTextEditor)this.getControl();
    }
}

