/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.example.util.MyLog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MyLib {
    static Random random = new Random();
    private static final Date today = new Date();
    public static final int MILLISECS_PER_DAY = 86400000;

    public static long daysTillToday(Date date) {
        return (date.getTime() - today.getTime()) / 86400000L;
    }

    public static String generateGuidStr() {
        long rand = random.nextLong() & Long.MAX_VALUE | 0x4000000000000000L;
        return String.valueOf(Long.toString(rand, 32)) + Long.toString(System.currentTimeMillis() & 0xFFFFFFFFFFFFFL, 32);
    }

    public static void writeStringToFile(String str, File outFile) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
        char[] chars = str.toCharArray();
        out.write(chars, 0, chars.length);
        out.close();
    }

    public static void popup(final String title, final String message) {
        if (!PlatformUI.isWorkbenchRunning()) {
            MyLog.log(Activator.class, Level.SEVERE, message);
        } else {
            MyLib.ensureInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
                }
            });
        }
    }

    public static GridLayout getZeroMarginLayout(int numColumns, boolean equalColumnWidth) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = equalColumnWidth;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static GridLayout getZeroMarginLayout() {
        return MyLib.getZeroMarginLayout(1, false);
    }

    public static List<String> readListFromDir(File directory, FilenameFilter filter, boolean keepExtension) {
        ArrayList<String> list = new ArrayList<String>(400);
        if (directory == null) {
            MyLog.log(Activator.class, Level.SEVERE, "Invalid directory path");
            return list;
        }
        Object[] files = directory.listFiles(filter);
        if (files == null) {
            MyLog.log(Activator.class, Level.SEVERE, "Invalid path: " + directory);
            return list;
        }
        if (files.length > 0) {
            Arrays.sort(files);
        }
        if (keepExtension) {
            int i = 0;
            while (i < files.length) {
                list.add(((File)files[i]).getName());
                ++i;
            }
        } else {
            int i = 0;
            while (i < files.length) {
                list.add(MyLib.removeExtension(((File)files[i]).getName()));
                ++i;
            }
        }
        return list;
    }

    public static List<String> readListFromDir(String directory, FilenameFilter filter) {
        return MyLib.readListFromDir(new File(directory), filter, false);
    }

    public static String removeExtension(String filepath) {
        String ext = MyLib.getExtension(filepath);
        if (ext != null && ext.length() > 0) {
            filepath = filepath.substring(0, filepath.length() - (ext.length() + 1));
        }
        return filepath;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("indows") != -1;
    }

    public static String getExtension(String filepath) {
        int index;
        filepath = filepath.trim();
        String separatorRegEx = File.separator;
        if (MyLib.isWindows()) {
            separatorRegEx = "\\\\";
        }
        String[] pathsArray = filepath.split(separatorRegEx);
        String fileName = pathsArray[0];
        if (pathsArray.length > 0) {
            fileName = pathsArray[pathsArray.length - 1];
        }
        if ((index = fileName.lastIndexOf(46)) >= 0 && index + 1 < fileName.length()) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public static void ensureInDisplayThread(Runnable runnable) {
        MyLib.ensureInDisplayThread(runnable, false);
    }

    public static void ensureInDisplayThread(Runnable runnable, boolean forcePend) {
        if (MyLib.isDisplayThread()) {
            runnable.run();
        } else if (forcePend) {
            Display.getDefault().syncExec(runnable);
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public static boolean isDisplayThread() {
        if (Display.getCurrent() == null) {
            return false;
        }
        return Display.getCurrent().getThread() == Thread.currentThread();
    }

    public static String doubleToI18nString(double d) {
        return MyLib.doubleToI18nString(d, false);
    }

    public static String doubleToI18nString(double d, boolean blankIfZero) {
        if (blankIfZero && d == 0.0) {
            return "";
        }
        return String.format("%4.2f", d);
    }
}

