/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.util.internal.CollectionsUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XmlUtil;
import org.eclipse.swt.widgets.TreeColumn;

public class XViewerColumn {
    private XViewer xViewer;
    protected String id;
    protected String name = "";
    private String description;
    private boolean multiColumnEditable = false;
    private int width;
    private int align;
    private boolean sortForward = true;
    private boolean show = true;
    private SortDataType sortDataType = SortDataType.String;
    private String toolTip = "";
    protected Map<Long, String> preComputedValueMap = null;
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String WIDTH = "wdth";
    public static final String ALIGN = "algn";
    public static final String SORT_FORWARD = "srtFwd";
    public static final String SHOW = "show";
    public static final String XTREECOLUMN_TAG = "xCol";

    protected XViewerColumn() {
    }

    public XViewerColumn(String id, String name, int width, int align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        this.setId(id);
        this.setName(name);
        this.width = width;
        this.align = align;
        this.show = show;
        this.sortDataType = sortDataType;
        this.multiColumnEditable = multiColumnEditable;
        this.setDescription(description);
        this.setToolTip(this.name);
    }

    public XViewerColumn copy() {
        XViewerColumn newXCol = new XViewerColumn();
        this.copy(this, newXCol);
        return newXCol;
    }

    protected void copy(XViewerColumn fromXCol, XViewerColumn toXCol) {
        toXCol.setAlign(fromXCol.align);
        toXCol.setDescription(fromXCol.description);
        toXCol.setMultiColumnEditable(fromXCol.multiColumnEditable);
        toXCol.setName(fromXCol.name);
        toXCol.setSortDataType(fromXCol.sortDataType);
        toXCol.setToolTip(fromXCol.toolTip);
        toXCol.setWidth(fromXCol.width);
        toXCol.setShow(fromXCol.show);
        toXCol.setId(fromXCol.id);
    }

    public XViewerColumn(XViewer xViewer, String xml) {
        this.xViewer = xViewer;
        this.setFromXml(xml);
    }

    public boolean equals(Object obj) {
        if (obj instanceof XViewerColumn) {
            return ((XViewerColumn)obj).getId().equals(this.id);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer("<xCol>");
        sb.append(XmlUtil.addTagData(ID, this.id));
        sb.append(XmlUtil.addTagData(NAME, this.name));
        sb.append(XmlUtil.addTagData(WIDTH, String.valueOf(this.width)));
        sb.append(XmlUtil.addTagData(ALIGN, this.getAlignStoreName(this.align)));
        sb.append(XmlUtil.addTagData(SORT_FORWARD, String.valueOf(this.sortForward)));
        sb.append(XmlUtil.addTagData(SHOW, String.valueOf(this.show)));
        sb.append("</xCol>");
        return sb.toString();
    }

    public void setFromXml(String xml) {
        this.setId(XmlUtil.getTagData(xml, ID));
        this.setName(XmlUtil.getTagData(xml, NAME));
        this.width = XmlUtil.getTagIntData(xml, WIDTH);
        this.align = this.getAlignStoreValue(XmlUtil.getTagData(xml, ALIGN));
        this.sortForward = XmlUtil.getTagBooleanData(xml, SORT_FORWARD);
        this.show = XmlUtil.getTagBooleanData(xml, SHOW);
    }

    public static String getColumnId(String xml) {
        return XmlUtil.getTagData(xml, ID);
    }

    public String getAlignStoreName(int align) {
        if (align == 0x1000000) {
            return "center";
        }
        if (align == 131072) {
            return "right";
        }
        return "left";
    }

    public int getAlignStoreValue(String str) {
        if (str.equals("center")) {
            return 0x1000000;
        }
        if (str.equals("right")) {
            return 131072;
        }
        return 16384;
    }

    public String getDisplayName() {
        if (this.id != null && !this.id.equals(this.name)) {
            return String.valueOf(this.name) + " - " + this.id + " - width:" + this.width + " - show:" + this.show;
        }
        return String.valueOf(this.name) + " - width:" + this.width + " - show:" + this.show;
    }

    public String toString() {
        return "column:[" + this.name + "][" + this.id + "][" + this.width + "][" + this.show + "][" + this.align + "]";
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public String getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public XViewer getTreeViewer() {
        return this.xViewer;
    }

    public XViewer getXViewer() {
        return this.xViewer;
    }

    public boolean isSortForward() {
        return this.sortForward;
    }

    public void setSortForward(boolean sortForward) {
        this.sortForward = sortForward;
    }

    public void reverseSort() {
        this.setSortForward(!this.sortForward);
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public String getName() {
        return this.name;
    }

    public SortDataType getSortDataType() {
        return this.sortDataType;
    }

    public void setSortDataType(SortDataType sortDataType) {
        this.sortDataType = sortDataType;
    }

    public void setXViewer(XViewer treeViewer) {
        this.xViewer = treeViewer;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        if (toolTip != null) {
            this.toolTip = XViewerLib.intern(toolTip);
        }
    }

    public void setName(String name) {
        this.name = XViewerLib.intern(name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = XViewerLib.intern(description);
    }

    public boolean isMultiColumnEditable() {
        return this.multiColumnEditable;
    }

    public void setMultiColumnEditable(boolean multiColumnEditable) {
        this.multiColumnEditable = multiColumnEditable;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public boolean isSummable() {
        return this.sortDataType == SortDataType.Float || this.sortDataType == SortDataType.Integer || this.sortDataType == SortDataType.Long;
    }

    public String sumValues(Collection<String> values) {
        if (this.sortDataType == SortDataType.Float) {
            double sum = 0.0;
            HashSet<String> exceptions = new HashSet<String>();
            for (String value : values) {
                if (value == null || value.equals("")) continue;
                try {
                    sum += new Double(value).doubleValue();
                }
                catch (Exception ex) {
                    exceptions.add(ex.getLocalizedMessage());
                }
            }
            return "Sum: " + XViewerLib.doubleToI18nString(sum) + "\n\nNum Items: " + values.size() + (exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        if (this.sortDataType == SortDataType.Integer) {
            int sum = 0;
            HashSet<String> exceptions = new HashSet<String>();
            for (String value : values) {
                if (value == null || value.equals("")) continue;
                try {
                    sum += Integer.valueOf(value).intValue();
                }
                catch (Exception ex) {
                    exceptions.add(ex.getLocalizedMessage());
                }
            }
            return "Sum: " + sum + "\n\nNum Items: " + values.size() + (exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        if (this.sortDataType == SortDataType.Long) {
            int sum = 0;
            HashSet<String> exceptions = new HashSet<String>();
            for (String value : values) {
                if (value == null || value.equals("")) continue;
                try {
                    sum = (int)((long)sum + Long.valueOf(value));
                }
                catch (Exception ex) {
                    exceptions.add(ex.getLocalizedMessage());
                }
            }
            return "Sum: " + sum + "\n\nNum Items: " + values.size() + (exceptions.size() > 0 ? "\n\nErrors: " + CollectionsUtil.toString(";", exceptions) : "");
        }
        return "Unhandled column type";
    }

    public boolean is(TreeColumn treeColumn) {
        return treeColumn.getText().equals(this.getName());
    }

    public void setId(String id) {
        this.id = XViewerLib.intern(id);
    }

    public String getPreComputedValue(Long key) {
        String result = null;
        if (this.preComputedValueMap == null) {
            return result;
        }
        return this.preComputedValueMap.get(key);
    }

    public static enum SortDataType {
        Date,
        Float,
        Percent,
        String,
        String_MultiLine,
        Boolean,
        Integer,
        Long,
        Paragraph_Number,
        Check;

    }
}

