/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.Collection;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;

public abstract class XViewerComputedColumn
extends XViewerValueColumn {
    protected XViewerColumn sourceXViewerColumn;
    protected XViewer xViewer;
    private final Pattern idPattern = Pattern.compile("^.*\\((.*?)\\)$");

    public XViewerComputedColumn(String id, String name, int width, int align, boolean show, XViewerColumn.SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
    }

    public XViewerComputedColumn(XViewer viewer, String xml) {
        super(viewer, xml);
    }

    public XViewerColumn getSourceXViewerColumn() {
        return this.sourceXViewerColumn;
    }

    public void setSourceXViewerColumn(XViewerColumn sourceXViewerColumn) {
        this.sourceXViewerColumn = sourceXViewerColumn;
        this.id = this.getId();
        this.name = this.getName();
    }

    public String getSourceColumnId() {
        if (this.sourceXViewerColumn != null) {
            return this.sourceXViewerColumn.getId();
        }
        Matcher matcher = this.idPattern.matcher(this.id);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public void setSourceXViewerColumnFromColumns(Collection<XViewerColumn> xViewerColumns) {
        String sourceColumnId = this.getSourceColumnId();
        if (sourceColumnId == null) {
            XViewerLog.log(Activator.class, Level.SEVERE, "Invalid null sourceColumnId");
            return;
        }
        for (XViewerColumn xCol : xViewerColumns) {
            if (!xCol.getId().equals(sourceColumnId)) continue;
            this.setSourceXViewerColumn(xCol);
            return;
        }
        XViewerLog.log(Activator.class, Level.SEVERE, String.format("Can't resolve sourceColumn for XViewerComputedColumn [%s]", this));
    }

    public abstract boolean isApplicableFor(XViewerColumn var1);

    public abstract boolean isApplicableFor(String var1);

    public abstract XViewerComputedColumn createFromStored(XViewerColumn var1);

    @Override
    public XViewer getXViewer() {
        return this.xViewer;
    }

    @Override
    public void setXViewer(XViewer xViewer) {
        this.xViewer = xViewer;
    }

    @Override
    public abstract XViewerComputedColumn copy();
}

