/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerGradient {
    private final XViewer xViewer;
    private boolean on = false;
    private final Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            try {
                XViewerColumn xViewerColumn = ((IXViewerLabelProvider)XViewerGradient.this.xViewer.getLabelProvider()).getTreeColumnOffIndex(event.index);
                TreeItem item = (TreeItem)event.item;
                if (item.getData() == null) {
                    return;
                }
                int percent = ((IXViewerLabelProvider)XViewerGradient.this.xViewer.getLabelProvider()).getColumnGradient(item.getData(), xViewerColumn, event.index);
                if (percent == 0 || percent > 100 || percent < 0) {
                    return;
                }
                GC gc = event.gc;
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                gc.setForeground(XViewerGradient.this.xViewer.getTree().getDisplay().getSystemColor(5));
                gc.setBackground(XViewerGradient.this.xViewer.getTree().getDisplay().getSystemColor(7));
                int width = (xViewerColumn.getWidth() - 1) * percent / 100;
                gc.fillGradientRectangle(event.x, event.y, width, event.height, true);
                Rectangle rect2 = new Rectangle(event.x, event.y, width - 1, event.height - 1);
                gc.setForeground(XViewerGradient.this.xViewer.getTree().getDisplay().getSystemColor(2));
                gc.drawRectangle(rect2);
                gc.setForeground(XViewerGradient.this.xViewer.getTree().getDisplay().getSystemColor(24));
                String text = ((IXViewerLabelProvider)XViewerGradient.this.xViewer.getLabelProvider()).getColumnText(item.getData(), xViewerColumn, event.index);
                Point size = event.gc.textExtent(text);
                int offset = Math.max(0, (event.height - size.y) / 2 + 1);
                gc.drawText(text, event.x + 5, event.y + offset, true);
                gc.setForeground(background);
                gc.setBackground(foreground);
            }
            catch (Exception ex) {
                XViewerLog.log(XViewerGradient.class, Level.SEVERE, ex);
                return;
            }
        }
    };

    public XViewerGradient(XViewer xViewer) {
        this.xViewer = xViewer;
        this.setOn(true);
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        if (this.on == on) {
            return;
        }
        this.on = on;
        if (this.on) {
            this.xViewer.getTree().addListener(42, this.paintListener);
        } else {
            this.xViewer.getTree().removeListener(42, this.paintListener);
        }
    }
}

