/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerCells;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public abstract class XViewerLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
IXViewerLabelProvider {
    private final XViewer viewer;
    private final Map<Integer, XViewerColumn> indexToXViewerColumnMap = new HashMap<Integer, XViewerColumn>();

    @Override
    public XViewerColumn getTreeColumnOffIndex(int columnIndex) {
        XViewerColumn xViewerColumn;
        if (!this.indexToXViewerColumnMap.containsKey(columnIndex) && (xViewerColumn = this.viewer.getXTreeColumn(columnIndex)) != null) {
            this.indexToXViewerColumnMap.put(columnIndex, xViewerColumn);
        }
        return this.indexToXViewerColumnMap.get(columnIndex);
    }

    @Override
    public void clearXViewerColumnIndexCache() {
        this.indexToXViewerColumnMap.clear();
    }

    public XViewerLabelProvider(XViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image;
        XViewerColumn xViewerColumn;
        block4: {
            try {
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block4;
                return null;
            }
            catch (Exception ex) {
                XViewerLog.log(Activator.class, Level.SEVERE, ex);
                return null;
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (image = ((IXViewerValueColumn)((Object)xViewerColumn)).getColumnImage(element, xViewerColumn, columnIndex)) != null) {
            return image;
        }
        return this.getColumnImage(element, xViewerColumn, columnIndex);
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        XViewerColumn xViewerColumn;
        block7: {
            block6: {
                try {
                    xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                    if (xViewerColumn.isShow()) break block6;
                    return "";
                }
                catch (Exception ex) {
                    return XViewerCells.getCellExceptionString(ex);
                }
            }
            if (xViewerColumn instanceof IXViewerPreComputedColumn) {
                IXViewerPreComputedColumn preComputedColumn = (IXViewerPreComputedColumn)((Object)xViewerColumn);
                Long key = preComputedColumn.getKey(element);
                String cachedValue = xViewerColumn.getPreComputedValue(key);
                String result = ((IXViewerPreComputedColumn)((Object)xViewerColumn)).getText(element, key, cachedValue);
                return result;
            }
            if (!(xViewerColumn instanceof IXViewerValueColumn)) break block7;
            String str = ((IXViewerValueColumn)((Object)xViewerColumn)).getColumnText(element, xViewerColumn, columnIndex);
            if (str != null) {
                return str;
            }
            return "";
        }
        return this.getColumnText(element, xViewerColumn, columnIndex);
    }

    public Color getBackground(Object element, int columnIndex) {
        Color color;
        XViewerColumn xViewerColumn;
        block5: {
            try {
                String text;
                if (this.viewer.isSearch() && this.viewer.searchMatch(text = this.getColumnText(element, columnIndex))) {
                    return this.viewer.getSearchMatchColor();
                }
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (color = ((IXViewerValueColumn)((Object)xViewerColumn)).getBackground(element, xViewerColumn, columnIndex)) != null) {
            return color;
        }
        return this.getBackground(element, xViewerColumn, columnIndex);
    }

    public Color getForeground(Object element, int columnIndex) {
        Color color;
        XViewerColumn xViewerColumn;
        block4: {
            try {
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (color = ((IXViewerValueColumn)((Object)xViewerColumn)).getForeground(element, xViewerColumn, columnIndex)) != null) {
            return color;
        }
        return this.getForeground(element, xViewerColumn, columnIndex);
    }

    public Color getBackground(Object element, XViewerColumn xCol, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        return null;
    }

    public abstract Image getColumnImage(Object var1, XViewerColumn var2, int var3) throws Exception;

    @Override
    public abstract String getColumnText(Object var1, XViewerColumn var2, int var3) throws Exception;

    @Override
    public Object getBackingData(Object element, XViewerColumn xViewerColumn, int columnIndex) throws Exception {
        Object obj;
        block4: {
            try {
                if (xViewerColumn.isShow()) break block4;
                return "";
            }
            catch (Exception ex) {
                return XViewerCells.getCellExceptionString(ex);
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (obj = ((IXViewerValueColumn)((Object)xViewerColumn)).getBackingData(element, xViewerColumn, columnIndex)) != null) {
            return obj;
        }
        return null;
    }

    @Override
    public int getColumnGradient(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        return 0;
    }
}

