/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerCells;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public abstract class XViewerStyledTextLabelProvider
extends StyledCellLabelProvider
implements IXViewerLabelProvider {
    private final XViewer viewer;
    private final Map<Integer, XViewerColumn> indexToXViewerColumnMap = new HashMap<Integer, XViewerColumn>();

    @Override
    public XViewerColumn getTreeColumnOffIndex(int columnIndex) {
        XViewerColumn xViewerColumn;
        if (!this.indexToXViewerColumnMap.containsKey(columnIndex) && (xViewerColumn = this.viewer.getXTreeColumn(columnIndex)) != null) {
            this.indexToXViewerColumnMap.put(columnIndex, xViewerColumn);
        }
        return this.indexToXViewerColumnMap.get(columnIndex);
    }

    @Override
    public void clearXViewerColumnIndexCache() {
        this.indexToXViewerColumnMap.clear();
    }

    @Override
    public Object getBackingData(Object element, XViewerColumn xViewerColumn, int columnIndex) throws Exception {
        Object obj;
        block4: {
            try {
                if (xViewerColumn.isShow()) break block4;
                return "";
            }
            catch (Exception ex) {
                return XViewerCells.getCellExceptionString(ex);
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (obj = ((IXViewerValueColumn)((Object)xViewerColumn)).getBackingData(element, xViewerColumn, columnIndex)) != null) {
            return obj;
        }
        return null;
    }

    public XViewerStyledTextLabelProvider(XViewer viewer) {
        this.viewer = viewer;
    }

    public void update(ViewerCell cell) {
        Object[] newStyleRanges;
        Object element = cell.getElement();
        StyledString styledString = this.getStyledText(element, cell.getColumnIndex());
        String newText = styledString.toString();
        Object[] oldStyleRanges = cell.getStyleRanges();
        Object[] objectArray = newStyleRanges = this.isOwnerDrawEnabled() ? styledString.getStyleRanges() : null;
        if (!Arrays.equals(oldStyleRanges, newStyleRanges)) {
            cell.setStyleRanges((StyleRange[])newStyleRanges);
        }
        cell.setText(newText);
        cell.setImage(this.getColumnImage(element, cell.getColumnIndex()));
        cell.setFont(this.getFont(element, cell.getColumnIndex()));
        cell.setForeground(this.getForeground(element, cell.getColumnIndex()));
        cell.setBackground(this.getBackground(element, cell.getColumnIndex()));
    }

    @Override
    public int getColumnGradient(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        return 0;
    }

    private Font getFont(Object element, int columnIndex) {
        XViewerColumn xViewerColumn;
        block4: {
            try {
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (xViewerColumn instanceof XViewerValueColumn) {
            return ((XViewerValueColumn)xViewerColumn).getFont(element, xViewerColumn, columnIndex);
        }
        return this.getFont(element, xViewerColumn, columnIndex);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image;
        XViewerColumn xViewerColumn;
        block4: {
            try {
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block4;
                return null;
            }
            catch (Exception ex) {
                XViewerLog.log(Activator.class, Level.SEVERE, ex);
                return null;
            }
        }
        if (xViewerColumn instanceof XViewerValueColumn && (image = ((XViewerValueColumn)xViewerColumn).getColumnImage(element, xViewerColumn, columnIndex)) != null) {
            return image;
        }
        return this.getColumnImage(element, xViewerColumn, columnIndex);
    }

    StyledString getStyledText(Object element, int columnIndex) {
        try {
            XViewerColumn xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
            if (!xViewerColumn.isShow()) {
                return new StyledString("");
            }
            if (xViewerColumn instanceof XViewerValueColumn) {
                return ((XViewerValueColumn)xViewerColumn).getStyledText(element, xViewerColumn, columnIndex);
            }
            return this.getStyledText(element, xViewerColumn, columnIndex);
        }
        catch (Exception ex) {
            return new StyledString(XViewerCells.getCellExceptionString(ex));
        }
    }

    private Color getBackground(Object element, int columnIndex) {
        XViewerColumn xViewerColumn;
        block5: {
            try {
                StyledString text;
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (this.viewer.isSearch() && this.viewer.searchMatch((text = this.getStyledText(element, columnIndex)).getString())) {
                    return this.viewer.getSearchMatchColor();
                }
                if (xViewerColumn.isShow()) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (xViewerColumn instanceof XViewerValueColumn) {
            return ((XViewerValueColumn)xViewerColumn).getBackground(element, xViewerColumn, columnIndex);
        }
        return this.getBackground(element, xViewerColumn, columnIndex);
    }

    private Color getForeground(Object element, int columnIndex) {
        XViewerColumn xViewerColumn;
        block4: {
            try {
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (xViewerColumn instanceof XViewerValueColumn) {
            return ((XViewerValueColumn)xViewerColumn).getForeground(element, xViewerColumn, columnIndex);
        }
        return this.getForeground(element, xViewerColumn, columnIndex);
    }

    @Override
    public String getColumnText(Object element, XViewerColumn xCol, int column) throws Exception {
        return this.getStyledText(element, xCol, column).getString();
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        XViewerColumn xViewerColumn;
        block6: {
            block5: {
                try {
                    xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                    if (xViewerColumn.isShow()) break block5;
                    return "";
                }
                catch (Exception ex) {
                    return XViewerCells.getCellExceptionString(ex);
                }
            }
            if (!(xViewerColumn instanceof IXViewerValueColumn)) break block6;
            String str = ((IXViewerValueColumn)((Object)xViewerColumn)).getColumnText(element, xViewerColumn, columnIndex);
            if (str != null) {
                return str;
            }
            return "";
        }
        return this.getColumnText(element, xViewerColumn, columnIndex);
    }

    public abstract Image getColumnImage(Object var1, XViewerColumn var2, int var3) throws Exception;

    public abstract StyledString getStyledText(Object var1, XViewerColumn var2, int var3) throws Exception;

    public abstract Color getBackground(Object var1, XViewerColumn var2, int var3) throws Exception;

    public abstract Color getForeground(Object var1, XViewerColumn var2, int var3) throws Exception;

    public abstract Font getFont(Object var1, XViewerColumn var2, int var3) throws Exception;
}

