/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.Strings;

public class XViewerTextFilter
extends ViewerFilter {
    protected final XViewer xViewer;
    protected Pattern textPattern;
    protected Matcher matcher;
    protected final Map<String, Pattern> colIdToPattern = new HashMap<String, Pattern>();
    protected static final Pattern EMPTY_STR_PATTERN = Pattern.compile("");
    protected static final Pattern NOT_EMPTY_STR_PATTERN = Pattern.compile("^.+$");
    private final Set<Object> parentMatches = new HashSet<Object>();

    public XViewerTextFilter(XViewer xViewer) {
        this.xViewer = xViewer;
    }

    public void update() {
        this.parentMatches.clear();
        if (!Strings.isValid(this.xViewer.getCustomizeMgr().getFilterText())) {
            this.textPattern = null;
        } else {
            int flags = 2;
            if (!this.xViewer.getCustomizeMgr().isFilterTextRegularExpression()) {
                flags = 0x10 | flags;
            }
            this.textPattern = Pattern.compile(this.xViewer.getCustomizeMgr().getFilterText(), flags);
        }
        this.colIdToPattern.clear();
        for (String colId : this.xViewer.getCustomizeMgr().getColumnFilterData().getColIds()) {
            String colFilterText = this.xViewer.getCustomizeMgr().getColumnFilterText(colId);
            if (colFilterText == null) continue;
            boolean isNot = colFilterText.startsWith("!");
            if (isNot) {
                colFilterText = colFilterText.replaceFirst("^!", "");
            }
            if (isNot) {
                if (colFilterText.equals("")) {
                    this.colIdToPattern.put(colId, NOT_EMPTY_STR_PATTERN);
                    continue;
                }
                this.colIdToPattern.put(colId, Pattern.compile("^(.(?<!" + colFilterText + "))*$", 2));
                continue;
            }
            if (colFilterText.equals("")) {
                this.colIdToPattern.put(colId, EMPTY_STR_PATTERN);
                continue;
            }
            this.colIdToPattern.put(colId, Pattern.compile(this.xViewer.getCustomizeMgr().getColumnFilterData().getFilterText(colId), 2));
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.textPattern == null && this.colIdToPattern.isEmpty()) {
            return true;
        }
        if (this.parentMatches.contains(element)) {
            if (parentElement != null) {
                this.parentMatches.add(parentElement);
            }
            return true;
        }
        boolean match = true;
        for (String filteredColId : this.xViewer.getCustomizeMgr().getColumnFilterData().getColIds()) {
            String cellStr;
            XViewerColumn xCol = this.xViewer.getCustomizeMgr().getCurrentTableColumn(filteredColId);
            if (!xCol.isShow() || !this.colIdToPattern.keySet().contains(xCol.getId()) || (cellStr = this.xViewer.getColumnText(element, this.xViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(xCol))) == null) continue;
            this.matcher = this.colIdToPattern.get(xCol.getId()).matcher(cellStr);
            if (this.matcher.find()) continue;
            return false;
        }
        if (!match) {
            return false;
        }
        if (this.textPattern == null) {
            if (match && parentElement != null) {
                this.parentMatches.add(parentElement);
            }
            return match;
        }
        if (this.textPattern != null) {
            for (XViewerColumn xCol : this.xViewer.getCustomizeMgr().getCurrentTableColumns()) {
                String cellStr;
                if (!xCol.isShow() || (cellStr = this.xViewer.getColumnText(element, this.xViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(xCol))) == null) continue;
                this.matcher = this.textPattern.matcher(cellStr);
                if (!this.matcher.find()) continue;
                if (parentElement != null) {
                    this.parentMatches.add(parentElement);
                }
                return true;
            }
        }
        return false;
    }
}

