/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import org.eclipse.nebula.widgets.xviewer.util.internal.XmlUtil;

public class FilterData {
    private String filterText = "";
    private static final String FILTER_TAG = "xFilter";
    private static final String FILTER_REGEX_TAG = "xFilterRE";
    private boolean regularExpression;

    public String getFilterText() {
        return this.filterText;
    }

    public boolean isFiltering() {
        return this.filterText != null && !this.filterText.equals("");
    }

    public void setFilterText(String filterText, boolean regularExpression) {
        this.filterText = filterText;
        this.regularExpression = regularExpression;
    }

    public String getXml() {
        return String.valueOf(XmlUtil.addTagData(FILTER_TAG, this.filterText)) + XmlUtil.addTagDataBoolean(FILTER_REGEX_TAG, this.regularExpression);
    }

    public void setFromXml(String xml) {
        this.filterText = XmlUtil.getTagData(xml, FILTER_TAG);
        this.regularExpression = XmlUtil.getTagBooleanData(xml, FILTER_REGEX_TAG);
    }

    public String toString() {
        return "filterData:[" + this.filterText + "]" + (this.regularExpression ? "-RE" : "");
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(boolean regularExpression) {
        this.regularExpression = regularExpression;
    }
}

