/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.piece.EmptyPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;

class EmptyIterator
implements PrintIterator {
    private final Point size;
    private boolean hasNext = true;

    EmptyIterator(Device device, EmptyPrint target) {
        Point dpi = device.getDPI();
        this.size = new Point(Math.round((float)(target.width * dpi.x) / 72.0f), Math.round((float)(target.height * dpi.y) / 72.0f));
    }

    EmptyIterator(EmptyIterator that) {
        this.size = that.size;
        this.hasNext = that.hasNext;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public PrintPiece next(int width, int height) {
        if (this.size.x > width || this.size.y > height) {
            return null;
        }
        this.hasNext = false;
        return new EmptyPiece(this.size);
    }

    public Point minimumSize() {
        return new Point(this.size.x, this.size.y);
    }

    public Point preferredSize() {
        return new Point(this.size.x, this.size.y);
    }

    public PrintIterator copy() {
        return new EmptyIterator(this);
    }
}

