/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.EmptyIterator;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class EmptyPrint
implements Print {
    final int width;
    final int height;

    public EmptyPrint() {
        this(0, 0);
    }

    public EmptyPrint(int width, int height) {
        this.width = this.checkDimension(width);
        this.height = this.checkDimension(height);
    }

    public EmptyPrint(Point size) {
        this(size.x, size.y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmptyPrint other = (EmptyPrint)obj;
        if (this.height != other.height) {
            return false;
        }
        return this.width == other.width;
    }

    public Point getSize() {
        return new Point(this.width, this.height);
    }

    private int checkDimension(int dim) {
        if (dim < 0) {
            PaperClips.error(5, "EmptyPrint dimensions must be >= 0");
        }
        return dim;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new EmptyIterator(device, this);
    }
}

