/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.border;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.BorderPainter;
import org.eclipse.nebula.paperclips.core.border.GapBorderPainter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class GapBorder
implements Border {
    public int top = 0;
    public int bottom = 0;
    public int left = 0;
    public int right = 0;
    public int openTop = 0;
    public int openBottom = 0;

    public GapBorder() {
        this(0);
    }

    public GapBorder(int gap) {
        this.setGap(gap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bottom;
        result = 31 * result + this.left;
        result = 31 * result + this.openBottom;
        result = 31 * result + this.openTop;
        result = 31 * result + this.right;
        result = 31 * result + this.top;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GapBorder other = (GapBorder)obj;
        if (this.bottom != other.bottom) {
            return false;
        }
        if (this.left != other.left) {
            return false;
        }
        if (this.openBottom != other.openBottom) {
            return false;
        }
        if (this.openTop != other.openTop) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        return this.top == other.top;
    }

    public void setGap(int gap) {
        this.bottom = this.right = this.checkGap(gap);
        this.left = this.right;
        this.top = this.right;
    }

    int checkGap(int gap) {
        if (gap < 0) {
            PaperClips.error(5, "Gap must be >= 0");
        }
        return gap;
    }

    public BorderPainter createPainter(Device device, GC gc) {
        return new GapBorderPainter(this, device);
    }
}

