/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.paperclips.core.CompositeEntry;
import org.eclipse.nebula.paperclips.core.CompositePiece;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.PrintSizeStrategy;
import org.eclipse.nebula.paperclips.core.text.internal.TextPrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class StyledTextIterator
implements PrintIterator {
    private final PrintIterator[] elements;
    private final Point minimumSize;
    private final Point preferredSize;
    private int cursor = 0;

    StyledTextIterator(Print[] elements, Device device, GC gc) {
        this.elements = new PrintIterator[elements.length];
        int i = 0;
        while (i < elements.length) {
            this.elements[i] = elements[i].iterator(device, gc);
            ++i;
        }
        this.minimumSize = this.computeSize(PrintSizeStrategy.MINIMUM);
        this.preferredSize = this.computeSize(PrintSizeStrategy.PREFERRED);
    }

    private StyledTextIterator(StyledTextIterator that) {
        this.elements = new PrintIterator[that.elements.length - that.cursor];
        this.minimumSize = that.minimumSize;
        this.preferredSize = that.preferredSize;
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i] = that.elements[that.cursor + i].copy();
            ++i;
        }
    }

    private Point computeSize(PrintSizeStrategy strategy) {
        Point result = new Point(0, 0);
        int i = 0;
        while (i < this.elements.length) {
            Point current = strategy.computeSize(this.elements[i]);
            result.x = Math.max(result.x, current.x);
            result.y = Math.max(result.y, current.y);
            ++i;
        }
        return result;
    }

    public Point minimumSize() {
        return new Point(this.minimumSize.x, this.minimumSize.y);
    }

    public Point preferredSize() {
        return new Point(this.preferredSize.x, this.preferredSize.y);
    }

    public boolean hasNext() {
        this.advanceCursor();
        return this.cursor < this.elements.length;
    }

    public PrintPiece next(int width, int height) {
        if (width < 0 || height < 0) {
            return null;
        }
        int y = 0;
        ArrayList<CompositeEntry> rows = new ArrayList<CompositeEntry>();
        while (y < height) {
            PrintPiece row = this.nextRow(width, height - y);
            if (row == null) break;
            rows.add(new CompositeEntry(row, new Point(0, y)));
            y += row.getSize().y;
        }
        if (rows.size() == 0) {
            return null;
        }
        return new CompositePiece(rows);
    }

    private PrintPiece nextRow(int width, int height) {
        int x = 0;
        int maxAscent = 0;
        int maxDescent = 0;
        int backupCursor = this.cursor;
        ArrayList<PrintIterator> backup = new ArrayList<PrintIterator>();
        ArrayList<PrintPiece> rowElements = new ArrayList<PrintPiece>();
        while (this.hasNext()) {
            PrintIterator element = this.elements[this.cursor];
            Point preferredSize = element.preferredSize();
            if (preferredSize.y > height) break;
            PrintIterator elementBackup = element.copy();
            PrintPiece piece = PaperClips.next(element, width - x, preferredSize.y);
            if (piece == null) break;
            rowElements.add(piece);
            backup.add(elementBackup);
            maxAscent = Math.max(maxAscent, this.getAscent(piece));
            maxDescent = Math.max(maxDescent, this.getDescent(piece));
            if (maxAscent + maxDescent > height) {
                this.restoreBackup(backupCursor, backup);
                return null;
            }
            if (element.hasNext()) break;
            x += piece.getSize().x;
        }
        return this.createRowResult(maxAscent, rowElements);
    }

    private PrintPiece createRowResult(int rowAscent, List rowElements) {
        if (rowElements.size() == 0) {
            return null;
        }
        ArrayList<CompositeEntry> entries = new ArrayList<CompositeEntry>();
        int x = 0;
        int i = 0;
        while (i < rowElements.size()) {
            PrintPiece piece = (PrintPiece)rowElements.get(i);
            int ascent = this.getAscent(piece);
            entries.add(new CompositeEntry(piece, new Point(x, rowAscent - ascent)));
            x += piece.getSize().x;
            ++i;
        }
        return new CompositePiece(entries);
    }

    private void restoreBackup(int backupCursor, List backup) {
        int i = 0;
        while (i < backup.size()) {
            this.elements[backupCursor + i] = (PrintIterator)backup.get(i);
            ++i;
        }
        this.cursor = backupCursor;
    }

    private int getAscent(PrintPiece piece) {
        if (piece instanceof TextPrintPiece) {
            return ((TextPrintPiece)piece).getAscent();
        }
        return piece.getSize().y;
    }

    private int getDescent(PrintPiece piece) {
        if (piece instanceof TextPrintPiece) {
            return piece.getSize().y - ((TextPrintPiece)piece).getAscent();
        }
        return 0;
    }

    private void advanceCursor() {
        while (this.cursor < this.elements.length && !this.elements[this.cursor].hasNext()) {
            ++this.cursor;
        }
    }

    public PrintIterator copy() {
        return new StyledTextIterator(this);
    }
}

