/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.widgets;

import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PrintPieceCanvas
extends Canvas {
    PrintPiece piece = null;

    public PrintPieceCanvas(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.setForeground(this.getDisplay().getSystemColor(24));
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (PrintPieceCanvas.this.piece == null) {
                    return;
                }
                Rectangle client = PrintPieceCanvas.this.getClientArea();
                PrintPieceCanvas.this.piece.paint(event.gc, client.x, client.y);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                PrintPieceCanvas.this.disposePrintPiece();
            }
        });
    }

    public void setPrintPiece(PrintPiece piece) {
        this.disposePrintPiece();
        this.piece = piece;
        this.redraw();
    }

    public PrintPiece getPrintPiece() {
        return this.piece;
    }

    private void disposePrintPiece() {
        if (this.piece != null) {
            this.piece.dispose();
        }
    }
}

