/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.nebula.widgets.geomap.GeoMapListener;
import org.eclipse.nebula.widgets.geomap.GeoMapUtil;
import org.eclipse.nebula.widgets.geomap.TileServer;
import org.eclipse.nebula.widgets.geomap.internal.DefaultMouseHandler;
import org.eclipse.nebula.widgets.geomap.internal.InternalGeoMap;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class GeoMap
extends InternalGeoMap {
    public static final String ABOUT_MSG = "GeoMap - Minimal Openstreetmap/Maptile Viewer\r\nRequirements: Java + SWT. Opensource and licensed under EPL.\r\n\r\nWeb/Source: <a href=\"http://eclipse.org/nebula\">http://eclipse.org/nebula</a>\r\nWritten by Stephan Rutz. Maintained by the Eclipse Nebula Project.\r\n\r\nTileserver and Nominationserver are accessed online and are part of Openstreetmap.org and not of this software.\r\n";
    private Point mouseCoords = new Point(0, 0);
    private DefaultMouseHandler defaultMouseHandler = new DefaultMouseHandler(this){

        @Override
        public Point getMapSize() {
            return GeoMap.this.getSize();
        }
    };
    private static final int DEFAULT_CACHE_SIZE = 256;
    private List<GeoMapListener> geoMapListeners;

    public GeoMap(Composite parent, int style) {
        this(parent, style, new Point(275091, 180145), 11);
    }

    public GeoMap(Composite parent, int style, Point mapPosition, int zoom) {
        this(parent, style, mapPosition, zoom, 256);
    }

    public GeoMap(Composite parent, int style, Point mapPosition, int zoom, int cacheSize) {
        super(parent, style, mapPosition, zoom, cacheSize);
        MouseCoordsHandler mouseCoordsHandler = new MouseCoordsHandler();
        this.addMouseListener(mouseCoordsHandler);
        this.addMouseMoveListener(mouseCoordsHandler);
        this.addMouseHandler((EventListener)((Object)this.defaultMouseHandler));
    }

    public DefaultMouseHandler getDefaultMouseHandler() {
        return this.defaultMouseHandler;
    }

    public void addMouseHandler(EventListener listener) {
        if (listener instanceof MouseListener) {
            this.addMouseListener((MouseListener)listener);
        }
        if (listener instanceof MouseMoveListener) {
            this.addMouseMoveListener((MouseMoveListener)listener);
        }
        if (listener instanceof MouseTrackListener) {
            this.addMouseTrackListener((MouseTrackListener)listener);
        }
        if (listener instanceof MouseWheelListener) {
            this.addMouseWheelListener((MouseWheelListener)listener);
        }
        if (listener instanceof PaintListener) {
            this.addPaintListener((PaintListener)listener);
        }
    }

    public void removeMouseHandler(EventListener listener) {
        if (listener instanceof MouseListener) {
            this.removeMouseListener((MouseListener)listener);
        }
        if (listener instanceof MouseMoveListener) {
            this.removeMouseMoveListener((MouseMoveListener)listener);
        }
        if (listener instanceof MouseTrackListener) {
            this.removeMouseTrackListener((MouseTrackListener)listener);
        }
        if (listener instanceof MouseWheelListener) {
            this.removeMouseWheelListener((MouseWheelListener)listener);
        }
        if (listener instanceof PaintListener) {
            this.removePaintListener((PaintListener)listener);
        }
    }

    public TileServer getTileServer() {
        return this.geoMapHelper.getTileServer();
    }

    public void setTileServer(TileServer tileServer) {
        this.geoMapHelper.setTileServer(tileServer);
    }

    public void addGeoMapListener(GeoMapListener listener) {
        if (this.geoMapListeners == null) {
            this.geoMapListeners = new ArrayList<GeoMapListener>();
        }
        this.geoMapListeners.add(listener);
    }

    public void removeGeoMapListener(GeoMapListener listener) {
        if (this.geoMapListeners != null) {
            this.geoMapListeners.remove(listener);
        }
    }

    private void fireCenterChanged() {
        if (this.geoMapListeners != null) {
            for (GeoMapListener listener : this.geoMapListeners) {
                listener.centerChanged(this);
            }
        }
    }

    private void fireZoomChanged() {
        if (this.geoMapListeners != null) {
            for (GeoMapListener listener : this.geoMapListeners) {
                listener.zoomChanged(this);
            }
        }
    }

    public void setMapPosition(Point mapPosition) {
        this.setMapPosition(mapPosition.x, mapPosition.y);
    }

    @Override
    public void setMapPosition(int x, int y) {
        super.setMapPosition(x, y);
        this.fireCenterChanged();
    }

    public void translateMapPosition(int tx, int ty) {
        GeoMapUtil.translateMapPosition(this, tx, ty);
    }

    @Override
    public void setZoom(int zoom) {
        super.setZoom(zoom);
        this.fireZoomChanged();
    }

    public void zoomIn(Point pivot) {
        GeoMapUtil.zoomIn(this, pivot);
        this.redraw();
    }

    public void zoomOut(Point pivot) {
        GeoMapUtil.zoomOut(this, pivot);
        this.redraw();
    }

    public void zoomTo(Rectangle rect) {
        GeoMapUtil.zoomTo(this, this.getSize(), rect, -1);
        this.redraw();
    }

    public Point getCenterPosition() {
        Point size = this.getSize();
        Point mapPosition = this.getMapPosition();
        return new Point(mapPosition.x + size.x / 2, mapPosition.y + size.y / 2);
    }

    public void setCenterPosition(Point mapPosition) {
        Point size = this.getSize();
        this.setMapPosition(mapPosition.x - size.x / 2, mapPosition.y - size.y / 2);
    }

    public Point getCursorPosition() {
        Point mapPosition = this.getMapPosition();
        return new Point(mapPosition.x + this.mouseCoords.x, mapPosition.y + this.mouseCoords.y);
    }

    private class MouseCoordsHandler
    implements MouseListener,
    MouseMoveListener {
        private MouseCoordsHandler() {
        }

        private void setMouseCoords(MouseEvent e) {
            GeoMap.this.mouseCoords = new Point(e.x, e.y);
        }

        public void mouseDown(MouseEvent e) {
            this.setMouseCoords(e);
        }

        public void mouseMove(MouseEvent e) {
            this.setMouseCoords(e);
        }

        public void mouseUp(MouseEvent e) {
            this.setMouseCoords(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.setMouseCoords(e);
        }
    }
}

