/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.dialog.snippets;

import java.math.BigDecimal;
import java.util.Arrays;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.ChoiceItem;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OpalDialogSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Dialog Sample");
        shell.setLayout((Layout)new GridLayout(3, true));
        Button button1 = new Button((Composite)shell, 8);
        button1.setText("Hello world !");
        button1.setLayoutData((Object)new GridData(4, 4, false, false));
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpalDialogSnippet.displayHelloWorld();
            }
        });
        Button button2 = new Button((Composite)shell, 8);
        button2.setText("Crash and burn");
        button2.setLayoutData((Object)new GridData(4, 4, false, false));
        button2.addListener(13, e -> OpalDialogSnippet.displayCrashAndBurn());
        Button button3 = new Button((Composite)shell, 8);
        button3.setText("You won !");
        button3.setLayoutData((Object)new GridData(4, 4, false, false));
        button3.addListener(13, e -> OpalDialogSnippet.displayYouWon());
        Button button4 = new Button((Composite)shell, 8);
        button4.setText("Confirm exit");
        button4.setLayoutData((Object)new GridData(4, 4, false, false));
        button4.addListener(13, e -> OpalDialogSnippet.displayConfirmExit());
        Button button5 = new Button((Composite)shell, 8);
        button5.setText("Radio choice");
        button5.setLayoutData((Object)new GridData(4, 4, false, false));
        button5.addListener(13, e -> OpalDialogSnippet.displayRadioChoice());
        Button button6 = new Button((Composite)shell, 8);
        button6.setText("Exception viewer");
        button6.setLayoutData((Object)new GridData(4, 4, false, false));
        button6.addListener(13, e -> OpalDialogSnippet.displayException());
        Button button7 = new Button((Composite)shell, 8);
        button7.setText("Input box");
        button7.setLayoutData((Object)new GridData(4, 4, false, false));
        button7.addListener(13, e -> OpalDialogSnippet.displayInput());
        Button button8 = new Button((Composite)shell, 8);
        button8.setText("Choice...");
        button8.setLayoutData((Object)new GridData(4, 4, false, false));
        button8.addListener(13, e -> OpalDialogSnippet.displayChoice());
        Button button9 = new Button((Composite)shell, 8);
        button9.setText("Delayed quit");
        button9.setLayoutData((Object)new GridData(4, 4, false, false));
        button9.addListener(13, e -> OpalDialogSnippet.displayDelayedQuit());
        Button button10 = new Button((Composite)shell, 8);
        button10.setText("Progress bar");
        button10.setLayoutData((Object)new GridData(4, 4, false, false));
        button10.addListener(13, e -> OpalDialogSnippet.displayProgressBar());
        Button button11 = new Button((Composite)shell, 8);
        button11.setText("Complex Example 1");
        button11.setLayoutData((Object)new GridData(4, 4, false, false));
        button11.addListener(13, e -> OpalDialogSnippet.displaySecurityWarning());
        Button button12 = new Button((Composite)shell, 8);
        button12.setText("Complex Example 2");
        button12.setLayoutData((Object)new GridData(4, 4, false, false));
        button12.addListener(13, e -> OpalDialogSnippet.displayComplex());
        Button button13 = new Button((Composite)shell, 8);
        button13.setText("Large Text Example");
        button13.setLayoutData((Object)new GridData(4, 4, false, false));
        button13.addListener(13, e -> OpalDialogSnippet.displayLargeText());
        Button button14 = new Button((Composite)shell, 8);
        button14.setText("Issue 29");
        button14.setLayoutData((Object)new GridData(4, 4, false, false));
        button14.addListener(13, e -> OpalDialogSnippet.testIssue29());
        Button button15 = new Button((Composite)shell, 8);
        button15.setText("Issue 45");
        button15.setLayoutData((Object)new GridData(4, 4, false, false));
        button15.addListener(13, e -> OpalDialogSnippet.testIssue45());
        shell.pack();
        SWTGraphicUtil.centerShell((Shell)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void displayHelloWorld() {
        Dialog dialog = new Dialog();
        dialog.getMessageArea().setText("Hello world");
        dialog.setButtonType(Dialog.OpalDialogType.OK);
        dialog.show();
    }

    private static void displayCrashAndBurn() {
        Dialog.error((String)"CRASH AND BURN !", (String)"The application has performed an illegal action. This action has been logged and reported.");
    }

    private static void displayYouWon() {
        Dialog.inform((String)"You've won!", (String)"The game is over with the 15:3 score");
    }

    private static void displayConfirmExit() {
        boolean confirm = Dialog.isConfirmed((String)"Are you sure you want to quit?", (String)"Please do not quit yet!");
        System.out.println("Choice is..." + confirm);
    }

    private static void displayRadioChoice() {
        int choice = Dialog.radioChoice((String)"You've got selection to make", (String)"Go ahead", (int)1, (String[])new String[]{"Yes", "No", "May be"});
        System.out.println("Choice is..." + choice);
    }

    private static void displayException() {
        try {
            new BigDecimal("seven");
        }
        catch (Throwable ex) {
            Dialog.showException((Throwable)ex);
        }
    }

    private static void displayChoice() {
        int choice = Dialog.choice((String)"What do you want to do with your game in\nprogress?", (String)"", (int)1, (ChoiceItem[])new ChoiceItem[]{new ChoiceItem("Exit and save my game", "Save your game in progress, then exit. This will\noverwrite any previously saved games."), new ChoiceItem("Exit and don't save", "Exit without saving your game. This is counted\nas a loss in your statistics."), new ChoiceItem("Don't exit", "Return to your game progress")});
        System.out.println("Choice is..." + choice);
    }

    private static void displayDelayedQuit() {
        boolean choice = Dialog.isConfirmed((String)"Are you sure you want to quit?", (String)"Please do not quit yet!", (int)10);
        System.out.println("Choice is..." + choice);
    }

    private static void displaySecurityWarning() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Security Warning");
        dialog.setMinimumWidth(400);
        dialog.getMessageArea().setTitle("The publisher cannot be verified.\nDo you want to run this software?").setIcon(Display.getCurrent().getSystemImage(8)).setText("Name: C:\\Program Files\\eclipse\\eclipse.exe<br/>Publisher: <b>Unknown Publisher</b><br/>Type: Application<br/>");
        dialog.getFooterArea().addCheckBox("Always ask before opening this file", false).setButtonLabels(new String[]{"Run", "Cancel"});
        dialog.show();
        System.out.println("The choice is " + dialog.getSelectedButton() + ", the checkbox value is " + dialog.getCheckboxValue());
    }

    private static void displayProgressBar() {
        final Dialog dialog = new Dialog();
        dialog.setTitle("Copying...");
        dialog.setMinimumWidth(400);
        dialog.getMessageArea().setTitle("Copying files").setIcon(Display.getCurrent().getSystemImage(2)).setText("Location : from 'Others' to 'Others'<br/>File Name : <b>photo.jpg</b>").addProgressBar(0, 100, 0);
        final int[] counter = new int[]{10};
        Display.getCurrent().timerExec(500, new Runnable(){

            @Override
            public void run() {
                dialog.getMessageArea().setProgressBarValue(counter[0]);
                dialog.getMessageArea().setText("Location : from 'Others' to 'Others'<br/>File Name : <b>photo" + counter[0] + ".jpg</b>");
                counter[0] = counter[0] + 10;
                if (counter[0] < 120) {
                    Display.getCurrent().timerExec(500, (Runnable)this);
                } else {
                    dialog.close();
                }
            }
        });
        dialog.show();
    }

    private static void displayInput() {
        String input = Dialog.ask((String)"Enter you name", (String)"or any other text if you prefer", (String)"Laurent CARON");
        System.out.println("Choice is..." + input);
    }

    private static void displayComplex() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Application Error");
        dialog.getMessageArea().setTitle("CRASH AND BURN !").setText("The application has performed an illegal action. This action has been logged and reported.").setIcon(Display.getCurrent().getSystemImage(1));
        dialog.setButtonType(Dialog.OpalDialogType.OK);
        dialog.getFooterArea().setExpanded(false).addCheckBox("Don't show me this error next time", true).setDetailText("More explanations to come...");
        dialog.getFooterArea().setFooterText("Your application crashed because a developer forgot to write a unit test").setIcon(new Image(null, OpalDialogSnippet.class.getResourceAsStream("warning.png")));
        dialog.show();
    }

    private static void displayLargeText() {
        StringBuilder stringBuilder = new StringBuilder();
        int t = 0;
        while (t < 20) {
            stringBuilder.append("A <b>very</b> <size=10>long text (10)</size> " + t);
            stringBuilder.append("A <b>very</b> <size=+12>long text (+12)</size> " + t);
            stringBuilder.append("A <b>very</b> <size=-4>long text (-4)</size> " + t);
            stringBuilder.append("A <b>very</b> <color=#088A29>long text</color> " + t);
            stringBuilder.append("A <b>very</b> <color=255,0,255>long text</color> " + t);
            stringBuilder.append("A <b>very</b> <color=navy>long text</color> " + t);
            stringBuilder.append("A <b>very</b> <backgroundcolor=255,0,0>long text</backgroundcolor> " + t);
            stringBuilder.append("A <b>very</b> <backgroundcolor=#FFFFCC>long text</backgroundcolor> " + t);
            stringBuilder.append("A <b>very</b> <backgroundcolor=lavender>long text</backgroundcolor> " + t);
            stringBuilder.append("A very long text " + t + "<br/>");
            stringBuilder.append("...<br/>");
            ++t;
        }
        Dialog dialog = new Dialog(true);
        dialog.getMessageArea().setVerticalScrollbar(true);
        dialog.getMessageArea().setHeight(200);
        dialog.getMessageArea().setText(stringBuilder.toString());
        dialog.setButtonType(Dialog.OpalDialogType.OK);
        dialog.show();
    }

    private static void testIssue29() {
        Dialog d = new Dialog();
        d.setCenterPolicy(Dialog.CenterOption.CENTER_ON_DIALOG);
        d.setTitle("foo title");
        d.getMessageArea().setTitle("aaaa").setText("bbbb");
        d.getFooterArea().setButtonLabels(Arrays.asList("Don't Save please", "Cancel"));
        d.show();
    }

    private static void testIssue45() {
        Dialog dialog = new Dialog(true);
        dialog.getMessageArea().setVerticalScrollbar(true);
        dialog.getMessageArea().setHeight(200);
        dialog.getMessageArea().setText("Illegal format <key>:<value>");
        dialog.setButtonType(Dialog.OpalDialogType.OK);
        dialog.show();
    }
}

