/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.launcher.LauncherItem;
import org.eclipse.nebula.widgets.opal.launcher.LauncherLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class Launcher
extends Composite {
    private final List<LauncherItem> items = new ArrayList<LauncherItem>();
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private boolean needRedraw = true;
    private int selection = -1;

    public Launcher(Composite parent, int style) {
        super(parent, style | 0x800);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addListener(11, event -> this.drawLauncher());
        this.addListener(2, event -> this.handleKeyPressedEvent(event));
    }

    private void drawLauncher() {
        if (!this.needRedraw) {
            return;
        }
        this.disposePreviousContent();
        this.createButtons();
        this.pack();
        this.needRedraw = false;
    }

    private void disposePreviousContent() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    private void createButtons() {
        GridLayout gridLayout = new GridLayout(this.items.size() / 2, true);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        for (LauncherItem item : this.items) {
            this.createItem(item);
        }
    }

    private void createItem(LauncherItem item) {
        LauncherLabel label = this.createLauncherLabel(item);
        this.addListenerToLabel(label);
    }

    private LauncherLabel createLauncherLabel(LauncherItem item) {
        LauncherLabel label = new LauncherLabel(this, 0x1000000);
        label.setText(item.title);
        label.setImage(item.image);
        label.setBackground(this.getDisplay().getSystemColor(1));
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 192;
        gd.heightHint = 220;
        label.setLayoutData(gd);
        item.label = label;
        return label;
    }

    private void addListenerToLabel(LauncherLabel label) {
        label.addListener(2, event -> this.handleKeyPressedEvent(event));
        label.addListener(4, event -> this.handleClickEvent(event));
        label.addListener(8, event -> this.handleDoubleClickEvent(event));
    }

    private void handleKeyPressedEvent(Event event) {
        switch (event.keyCode) {
            case 0x1000003: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection % 2 == 0) break;
                this.changeColor(this.selection, false);
                --this.selection;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000001: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection < 2) break;
                this.changeColor(this.selection, false);
                this.selection -= 2;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000004: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection % 2 != 0) break;
                this.changeColor(this.selection, false);
                ++this.selection;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000002: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection > this.items.size() - 2) break;
                this.changeColor(this.selection, false);
                this.selection += 2;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000007: {
                this.changeColor(this.selection, false);
                this.selection = 0;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000008: {
                this.changeColor(this.selection, false);
                this.selection = this.items.size() - 1;
                this.changeColor(this.selection, true);
            }
        }
    }

    private void handleClickEvent(Event event) {
        int i = 0;
        while (i < this.items.size()) {
            LauncherItem item = this.items.get(i);
            if (item.label != null && ((Object)((Object)item.label)).equals(event.widget)) {
                if (this.selection != i) {
                    this.changeColor(this.selection, false);
                    this.selection = i;
                    this.changeColor(this.selection, true);
                }
                return;
            }
            ++i;
        }
    }

    private void changeColor(int index, boolean isSelected) {
        if (index != -1 && this.items.get((int)index).label != null) {
            this.items.get((int)index).label.setBackground(isSelected ? this.getDisplay().getSystemColor(19) : this.getDisplay().getSystemColor(1));
        }
    }

    private void handleDoubleClickEvent(Event event) {
        int i = 0;
        while (i < this.items.size()) {
            LauncherItem item = this.items.get(i);
            if (item.label != null && ((Object)((Object)item.label)).equals(event.widget)) {
                if (this.selection != i) {
                    this.changeColor(this.selection, false);
                    this.selection = i;
                    this.changeColor(this.selection, true);
                }
                this.startAnimation(i, event);
                return;
            }
            ++i;
        }
    }

    private void startAnimation(int index, final Event event) {
        final LauncherLabel label = this.items.get((int)index).label;
        this.getDisplay().timerExec(0, new Runnable(){

            @Override
            public void run() {
                if (label.incrementAnimation()) {
                    Launcher.this.getDisplay().timerExec(20, (Runnable)this);
                } else {
                    Launcher.this.fireSelectionListeners(event);
                }
            }
        });
    }

    private boolean fireSelectionListeners(Event originalEvent) {
        Event event = new Event();
        event.button = originalEvent.button;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        event.data = null;
        event.time = originalEvent.time;
        event.x = originalEvent.x;
        event.y = originalEvent.y;
        for (SelectionListener listener : this.selectionListeners) {
            SelectionEvent selEvent = new SelectionEvent(event);
            listener.widgetSelected(selEvent);
            if (selEvent.doit) continue;
            return false;
        }
        return true;
    }

    public void addItem(String title, Image image) {
        this.checkWidget();
        this.items.add(new LauncherItem(title, image));
        this.needRedraw = true;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(listener);
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }
}

