/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWRowGroup;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWTab;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWTabContainer;
import org.eclipse.nebula.widgets.opal.preferencewindow.ValueAndAssociatedWidgets;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWWidget;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PreferenceWindow {
    private final Map<String, ValueAndAssociatedWidgets> values;
    private final List<PWTab> tabs;
    private final Shell parentShell;
    private boolean returnedValue;
    private Shell shell;
    private static PreferenceWindow instance;
    private PWTabContainer container;
    private int selectedTab;

    private PreferenceWindow(Shell parent, Map<String, Object> values) {
        this.parentShell = parent;
        this.values = new HashMap<String, ValueAndAssociatedWidgets>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.values.put(entry.getKey(), new ValueAndAssociatedWidgets(entry.getValue()));
        }
        this.tabs = new ArrayList<PWTab>();
    }

    public static PreferenceWindow create(Shell parent, Map<String, Object> values) {
        instance = new PreferenceWindow(parent, values);
        return instance;
    }

    public static PreferenceWindow create(Map<String, Object> values) {
        instance = new PreferenceWindow(null, values);
        return instance;
    }

    public static PreferenceWindow getInstance() {
        if (instance == null) {
            throw new NullPointerException("The instance of PreferenceWindow has not yet been created or has been destroyed.");
        }
        return instance;
    }

    public PWTab addTab(Image image, String text) {
        PWTab tab = new PWTab(image, text);
        this.tabs.add(tab);
        return tab;
    }

    public void addWidgetLinkedTo(String propertyKey, PWWidget widget) {
        if (!this.values.containsKey(propertyKey)) {
            this.values.put(propertyKey, new ValueAndAssociatedWidgets(null));
        }
        this.values.get(propertyKey).addWidget(widget);
    }

    public void addRowGroupLinkedTo(String propertyKey, PWRowGroup rowGroup) {
        if (!this.values.containsKey(propertyKey)) {
            this.values.put(propertyKey, new ValueAndAssociatedWidgets(null));
        }
        this.values.get(propertyKey).addRowGroup(rowGroup);
    }

    public boolean open() {
        this.shell = this.parentShell == null ? new Shell(1264) : new Shell(PreferenceWindow.instance.parentShell, 1264);
        this.shell.addListener(12, event -> {
            instance = null;
        });
        this.buildShell();
        this.openShell();
        return this.returnedValue;
    }

    private void buildShell() {
        this.shell.setText(ResourceManager.getLabel((String)"preferences"));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.shell.setLayout((Layout)gridLayout);
        this.container = new PWTabContainer((Composite)this.shell, 0, this.tabs);
        this.container.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.container.build();
        Label sep = new Label((Composite)this.shell, 258);
        sep.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.buildButtons();
    }

    private void buildButtons() {
        Button buttonOK = new Button((Composite)this.shell, 8);
        buttonOK.setText(ResourceManager.getLabel((String)"Ok"));
        GridData gridDataOk = new GridData(3, 3, true, false);
        gridDataOk.widthHint = 100;
        buttonOK.setLayoutData((Object)gridDataOk);
        buttonOK.addListener(13, e -> {
            this.returnedValue = true;
            this.shell.dispose();
        });
        this.shell.setDefaultButton(buttonOK);
        Button buttonCancel = new Button((Composite)this.shell, 8);
        buttonCancel.setText(ResourceManager.getLabel((String)"Cancel"));
        GridData gridDataCancel = new GridData(1, 3, false, false);
        gridDataCancel.widthHint = 100;
        buttonCancel.setLayoutData((Object)gridDataCancel);
        buttonCancel.addListener(13, e -> {
            this.returnedValue = false;
            this.shell.dispose();
        });
    }

    private void openShell() {
        this.shell.pack();
        this.shell.open();
        SWTGraphicUtil.centerShell((Shell)this.shell);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public void fireEnablers() {
        for (String key : this.values.keySet()) {
            this.values.get(key).fireValueChanged();
        }
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public Object getValueFor(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key).getValue();
        }
        return null;
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> returnedValues = new HashMap<String, Object>();
        for (String key : this.values.keySet()) {
            returnedValues.put(key, this.values.get(key).getValue());
        }
        return returnedValues;
    }

    public void setValue(String key, Object value) {
        if (this.values.containsKey(key)) {
            this.values.get(key).setValue(value);
        } else {
            this.values.put(key, new ValueAndAssociatedWidgets(value));
        }
    }

    public void setSelectedTab(int selectedTab) {
        this.selectedTab = selectedTab;
        if (this.container != null) {
            this.container.redraw();
            this.container.update();
        }
    }

    public Shell getShell() {
        return this.shell;
    }
}

