/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTChooserEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class PTWindowEditor
extends PTChooserEditor {
    @Override
    protected void openWindow(PTWidget widget, Item item, PTProperty property) {
        Shell shell = new Shell(widget.getWidget().getShell(), 2144);
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setText(ResourceManager.getLabel((String)"editProperty"));
        Label title = new Label((Composite)shell, 0);
        GridData titleLayoutData = new GridData(1, 1, true, false, 2, 1);
        titleLayoutData.widthHint = 400;
        title.setLayoutData((Object)titleLayoutData);
        Font font = SWTGraphicUtil.buildFontFrom((Control)title, (int)1, (int)16);
        title.setFont(font);
        title.setText(ResourceManager.getLabel((String)"editProperty"));
        SWTGraphicUtil.addDisposer((Widget)title, (Resource)font);
        this.createContent(shell, property);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Button ok = new Button(composite, 8);
        GridData okLayoutData = new GridData(3, 1, true, false);
        okLayoutData.widthHint = 150;
        ok.setLayoutData((Object)okLayoutData);
        ok.setText(ResourceManager.getLabel((String)"Ok"));
        ok.addListener(13, event -> {
            this.fillProperty(item, property);
            shell.dispose();
        });
        Button cancel = new Button(composite, 8);
        GridData cancelLayoutData = new GridData(3, 1, false, false);
        cancelLayoutData.widthHint = 150;
        cancel.setLayoutData((Object)cancelLayoutData);
        cancel.setText(ResourceManager.getLabel((String)"Cancel"));
        cancel.addListener(13, event -> shell.dispose());
        shell.setDefaultButton(ok);
        shell.pack();
        SWTGraphicUtil.centerShell((Shell)shell);
        shell.open();
    }

    protected abstract void fillProperty(Item var1, PTProperty var2);

    protected abstract void createContent(Shell var1, PTProperty var2);

    @Override
    protected Color getBackgroundColor(PTProperty property) {
        return null;
    }

    protected int getIntValue(Text text) {
        if (text.getText().trim().equals("")) {
            return 0;
        }
        return Integer.parseInt(text.getText().trim());
    }

    protected void addVerifyListeners(Text text) {
        text.addListener(25, e -> {
            String string = e.text;
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if (('0' > chars[i] || chars[i] > '9') && e.keyCode != 8 && e.keyCode != 127) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
        });
    }
}

