/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.roundedtoolbar.snippets;

import org.eclipse.nebula.widgets.opal.roundedtoolbar.RoundedToolItem;
import org.eclipse.nebula.widgets.opal.roundedtoolbar.RoundedToolbar;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RoundedToolbarSnippet {
    private static Color grey1;
    private static Color grey2;
    private static Image iconBubble1b;
    private static Image iconBubble1w;
    private static Image iconBubble2b;
    private static Image iconBubble2w;
    private static Image iconBubble3b;
    private static Image iconBubble3w;
    private static Image emailb;
    private static Image emailw;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("RoundedToolbar Snippet");
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 20;
        shell.setLayout((Layout)gridLayout);
        grey1 = new Color((Device)display, 211, 211, 211);
        grey2 = new Color((Device)display, 255, 250, 250);
        iconBubble1b = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/bubble1_b.png"));
        iconBubble1w = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/bubble1_w.png"));
        iconBubble2b = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/bubble2_b.png"));
        iconBubble2w = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/bubble2_w.png"));
        iconBubble3b = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/bubble3_b.png"));
        iconBubble3w = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/bubble3_w.png"));
        emailb = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/email_b.png"));
        emailw = new Image((Device)display, RoundedToolbarSnippet.class.getResourceAsStream("icons/email_w.png"));
        Label firstLabel = new Label((Composite)shell, 0);
        firstLabel.setText("Toggle buttons");
        RoundedToolbarSnippet.createToggleButtons(shell);
        Label secondLabel = new Label((Composite)shell, 0);
        secondLabel.setText("Push buttons");
        RoundedToolbarSnippet.createPushButtons(shell, false);
        RoundedToolbar toolbar = RoundedToolbarSnippet.createPushButtons(shell, true);
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = -1;
        gd.heightHint = 100;
        toolbar.setLayoutData((Object)gd);
        Label cbLabel = new Label((Composite)shell, 0);
        cbLabel.setText("Checkbox buttons");
        RoundedToolbarSnippet.createCheckButtons(shell, false);
        RoundedToolbar toolbar2 = RoundedToolbarSnippet.createCheckButtons(shell, true);
        GridData gd2 = new GridData(4, 4, false, false);
        gd2.widthHint = -1;
        gd2.heightHint = 100;
        toolbar2.setLayoutData((Object)gd);
        Label radioLabel = new Label((Composite)shell, 0);
        radioLabel.setText("Radio buttons");
        RoundedToolbarSnippet.createRadioButtons(shell, false);
        RoundedToolbar toolbar3 = RoundedToolbarSnippet.createRadioButtons(shell, true);
        GridData gd3 = new GridData(4, 4, false, false);
        gd3.widthHint = -1;
        gd3.heightHint = 100;
        toolbar3.setLayoutData((Object)gd);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        grey1.dispose();
        grey2.dispose();
        iconBubble1b.dispose();
        iconBubble1w.dispose();
        iconBubble2b.dispose();
        iconBubble2w.dispose();
        iconBubble3b.dispose();
        iconBubble3w.dispose();
        emailb.dispose();
        emailw.dispose();
        display.dispose();
    }

    private static void createToggleButtons(Shell shell) {
        RoundedToolbar roundedToolBar = new RoundedToolbar((Composite)shell, 0);
        roundedToolBar.setBackground(grey1);
        roundedToolBar.setCornerRadius(6);
        roundedToolBar.addListener(11, e -> System.out.println(roundedToolBar.getSize()));
        RoundedToolItem item1 = new RoundedToolItem(roundedToolBar, 2);
        item1.setSelection(true);
        item1.setTooltipText("Multiple ballons");
        item1.setWidth(40);
        item1.setSelectionImage(iconBubble3w);
        item1.setImage(iconBubble3b);
        RoundedToolItem item2 = new RoundedToolItem(roundedToolBar, 2);
        item2.setTooltipText("Simple item");
        item2.setSelectionImage(iconBubble1w);
        item2.setImage(iconBubble1b);
        item2.setWidth(40);
        RoundedToolItem item3 = new RoundedToolItem(roundedToolBar, 2);
        item3.setTooltipText("Lot of lines\r\n\r\nThis item has a line-break");
        item3.setSelectionImage(iconBubble2w);
        item3.setImage(iconBubble2b);
        item3.setWidth(40);
    }

    private static RoundedToolbar createPushButtons(Shell shell, boolean verticalAlignment) {
        RoundedToolbar toolbar = new RoundedToolbar((Composite)shell, 0);
        toolbar.setCornerRadius(8);
        toolbar.setBackground(grey1);
        RoundedToolItem mailItem = new RoundedToolItem(toolbar);
        mailItem.setSelectionImage(emailw);
        mailItem.setImage(emailb);
        mailItem.setWidth(32);
        mailItem.addListener(13, e -> System.out.println("push/Button 1"));
        if (verticalAlignment) {
            mailItem.setVerticalAlignment(128);
        }
        RoundedToolItem mailItemWithText = new RoundedToolItem(toolbar);
        mailItemWithText.setTextColorSelected(grey2);
        mailItemWithText.setText("Mails");
        mailItemWithText.setSelectionImage(emailw);
        mailItemWithText.setImage(emailb);
        mailItemWithText.setWidth(65);
        mailItemWithText.addListener(13, e -> System.out.println("push/Button 2"));
        if (verticalAlignment) {
            mailItemWithText.setVerticalAlignment(0x1000000);
        }
        RoundedToolItem itemJustText = new RoundedToolItem(toolbar);
        itemJustText.setTextColorSelected(grey2);
        itemJustText.setText("Just text");
        itemJustText.setWidth(100);
        itemJustText.setAlignment(131072);
        itemJustText.addListener(13, e -> System.out.println("push/Button 3"));
        if (verticalAlignment) {
            itemJustText.setVerticalAlignment(1024);
        }
        return toolbar;
    }

    private static RoundedToolbar createCheckButtons(Shell shell, boolean verticalAlignment) {
        RoundedToolbar toolBar = new RoundedToolbar((Composite)shell, 0);
        toolBar.setCornerRadius(8);
        toolBar.setBackground(grey1);
        RoundedToolItem mailItem = new RoundedToolItem(toolBar, 32);
        mailItem.setSelectionImage(emailw);
        mailItem.setImage(emailb);
        mailItem.setWidth(50);
        mailItem.addListener(13, e -> System.out.println("check/Button 1"));
        if (verticalAlignment) {
            mailItem.setVerticalAlignment(128);
        }
        RoundedToolItem mailItemWithText = new RoundedToolItem(toolBar, 32);
        mailItemWithText.setTextColorSelected(grey2);
        mailItemWithText.setText("Mails");
        mailItemWithText.setSelectionImage(emailw);
        mailItemWithText.setImage(emailb);
        mailItemWithText.setWidth(80);
        mailItemWithText.addListener(13, e -> System.out.println("check/Button 2"));
        if (verticalAlignment) {
            mailItemWithText.setVerticalAlignment(0x1000000);
        }
        RoundedToolItem itemJustText = new RoundedToolItem(toolBar, 32);
        itemJustText.setTextColorSelected(grey2);
        itemJustText.setText("Just text");
        itemJustText.setWidth(100);
        itemJustText.setAlignment(131072);
        itemJustText.addListener(13, e -> System.out.println("check/Button 3"));
        if (verticalAlignment) {
            itemJustText.setVerticalAlignment(1024);
        }
        return toolBar;
    }

    private static RoundedToolbar createRadioButtons(Shell shell, boolean verticalAlignment) {
        RoundedToolbar toolBar = new RoundedToolbar((Composite)shell, 0);
        toolBar.setCornerRadius(8);
        toolBar.setBackground(grey1);
        RoundedToolItem mailItem = new RoundedToolItem(toolBar, 16);
        mailItem.setSelectionImage(emailw);
        mailItem.setImage(emailb);
        mailItem.setWidth(50);
        mailItem.addListener(13, e -> System.out.println("radio/Button 1"));
        if (verticalAlignment) {
            mailItem.setVerticalAlignment(128);
        }
        RoundedToolItem mailItemWithText = new RoundedToolItem(toolBar, 16);
        mailItemWithText.setTextColorSelected(grey2);
        mailItemWithText.setText("Mails");
        mailItemWithText.setSelectionImage(emailw);
        mailItemWithText.setImage(emailb);
        mailItemWithText.setWidth(80);
        mailItemWithText.addListener(13, e -> System.out.println("radio/Button 2"));
        if (verticalAlignment) {
            mailItemWithText.setVerticalAlignment(0x1000000);
        }
        RoundedToolItem itemJustText = new RoundedToolItem(toolBar, 16);
        itemJustText.setTextColorSelected(grey2);
        itemJustText.setText("Just text");
        itemJustText.setWidth(100);
        itemJustText.setAlignment(131072);
        itemJustText.addListener(13, e -> System.out.println("radio/Button 3"));
        if (verticalAlignment) {
            itemJustText.setVerticalAlignment(1024);
        }
        return toolBar;
    }
}

