/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.roundedtoolbar;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.nebula.widgets.opal.commons.AdvancedPath;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.roundedtoolbar.RoundedToolbar;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class RoundedToolItem
extends Item {
    private static final int MARGIN = 4;
    private static Color START_GRADIENT_COLOR = SWTGraphicUtil.getColorSafely((int)70, (int)70, (int)70);
    private static Color END_GRADIENT_COLOR = SWTGraphicUtil.getColorSafely((int)116, (int)116, (int)116);
    private final RoundedToolbar parentToolbar;
    private final List<SelectionListener> selectionListeners;
    private Rectangle bounds;
    private boolean enabled;
    private boolean selection;
    private int width;
    private int height;
    private Image disabledImage;
    private Image selectionImage;
    private int alignment;
    private int verticalAlignment;
    private Color textColorSelected;
    private Color textColor;
    private String tooltipText;
    private GC gc;
    private int toolbarHeight;
    private boolean isLast;

    public RoundedToolItem(RoundedToolbar parent) {
        this(parent, 8);
    }

    public RoundedToolItem(RoundedToolbar parent, int style) {
        super((Widget)parent, RoundedToolItem.checkStyle(style));
        parent.addItem(this);
        this.parentToolbar = parent;
        this.textColor = parent.getDisplay().getSystemColor(2);
        this.textColorSelected = parent.getDisplay().getSystemColor(1);
        this.enabled = true;
        this.alignment = 0x1000000;
        this.verticalAlignment = 0x1000000;
        this.selectionListeners = new CopyOnWriteArrayList<SelectionListener>();
        this.width = -1;
        this.height = -1;
    }

    private static int checkStyle(int style) {
        if ((style & 0x20) != 0) {
            return 32;
        }
        if ((style & 0x10) != 0) {
            return 16;
        }
        if ((style & 2) != 0) {
            return 2;
        }
        if ((style & 4) != 0) {
            return 4;
        }
        return 8;
    }

    public void addListener(int eventType, final Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (eventType == 13) {
            this.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Event event = new Event();
                    event.widget = RoundedToolItem.this;
                    event.display = RoundedToolItem.this.getDisplay();
                    event.item = RoundedToolItem.this;
                    event.type = 13;
                    listener.handleEvent(event);
                }
            });
            return;
        }
        super.addListener(eventType, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(listener);
    }

    Point computeDefaultSize() {
        Point sizeOfTextAndImages = this.computeSizeOfTextAndImages();
        int additionnalWidth = this.getAdditionnalWidth();
        return new Point(8 + sizeOfTextAndImages.x + additionnalWidth, 8 + sizeOfTextAndImages.y);
    }

    private Point computeSizeOfTextAndImages() {
        boolean textNotEmpty;
        int width = 0;
        int height = 0;
        boolean bl = textNotEmpty = this.getText() != null && !this.getText().equals("");
        if (textNotEmpty) {
            GC gc = new GC((Drawable)this.parentToolbar);
            Point extent = gc.stringExtent(this.getText());
            gc.dispose();
            width += extent.x;
            height = extent.y;
        }
        Point imageSize = new Point(-1, -1);
        this.computeImageSize(this.getImage(), imageSize);
        this.computeImageSize(this.selectionImage, imageSize);
        this.computeImageSize(this.disabledImage, imageSize);
        if (imageSize.x != -1) {
            width += imageSize.x;
            height = Math.max(imageSize.y, height);
            if (textNotEmpty) {
                width += 4;
            }
        }
        return new Point(width, height);
    }

    private void computeImageSize(Image image, Point imageSize) {
        if (image == null) {
            return;
        }
        Rectangle imageBounds = image.getBounds();
        imageSize.x = Math.max(imageBounds.width, imageSize.x);
        imageSize.y = Math.max(imageBounds.height, imageSize.y);
    }

    private int getAdditionnalWidth() {
        if (this.isCheckbox() || this.isRadio()) {
            return 16;
        }
        return 0;
    }

    public void dispose() {
        this.selectionListeners.clear();
        this.getParent().removeItem(this);
        this.bounds = null;
        this.disabledImage = null;
        this.selectionImage = null;
        this.textColor = null;
        this.textColorSelected = null;
        super.dispose();
    }

    void drawButton(GC gc, int x, int toolbarHeight, boolean isLast) {
        this.gc = gc;
        this.toolbarHeight = toolbarHeight;
        this.isLast = isLast;
        if (this.selection && (this.isToogleButon() || this.isPushButon() || this.isDropDown())) {
            this.drawBackground(x);
        }
        if (!isLast) {
            this.drawRightLine(x);
        }
        int xPosition = this.computeHorizontalPosition(x);
        if (this.isCheckbox()) {
            this.drawCheckBox(x + xPosition);
            xPosition += 16;
        }
        if (this.isRadio()) {
            this.drawRadio(x + xPosition);
            xPosition += 16;
        }
        xPosition += this.drawImage(x + xPosition);
        this.drawText(x + xPosition);
        this.bounds = new Rectangle(x, 0, this.getWidth(), toolbarHeight);
    }

    private void drawBackground(int x) {
        boolean isFirst;
        AdvancedPath path = new AdvancedPath((Device)this.getDisplay());
        boolean bl = isFirst = this.getParent().indexOf(this) == 0;
        if (isFirst) {
            path.addRoundRectangleStraightRight((float)x, 0.0f, (float)this.getWidth(), (float)this.toolbarHeight, (float)this.parentToolbar.getCornerRadius(), (float)this.parentToolbar.getCornerRadius());
        } else if (this.isLast) {
            path.addRoundRectangleStraightLeft((float)x, 0.0f, (float)this.getWidth(), (float)this.toolbarHeight, (float)this.parentToolbar.getCornerRadius(), (float)this.parentToolbar.getCornerRadius());
        } else {
            path.addRectangle((float)x, 0.0f, (float)this.getWidth(), (float)this.toolbarHeight);
        }
        this.gc.setClipping((Path)path);
        this.gc.setForeground(START_GRADIENT_COLOR);
        this.gc.setBackground(END_GRADIENT_COLOR);
        this.gc.fillGradientRectangle(x, 0, this.getWidth() + this.parentToolbar.getCornerRadius(), this.toolbarHeight, true);
        this.gc.setClipping(null);
    }

    private void drawRightLine(int x) {
        this.gc.setForeground(RoundedToolbar.BORDER_COLOR);
        this.gc.drawLine(x + this.getWidth(), 0, x + this.getWidth(), this.toolbarHeight);
    }

    private int computeHorizontalPosition(int x) {
        int widthOfTextAndImage = this.computeSizeOfTextAndImages().x + this.getAdditionnalWidth();
        switch (this.alignment) {
            case 0x1000000: {
                return (this.getWidth() - widthOfTextAndImage) / 2;
            }
            case 131072: {
                return this.getWidth() - widthOfTextAndImage - 4;
            }
        }
        return 4;
    }

    private int computeVerticalPosition(int height) {
        switch (this.verticalAlignment) {
            case 0x1000000: {
                return (this.toolbarHeight - height) / 2;
            }
            case 128: {
                return 4;
            }
        }
        return this.toolbarHeight - height - 4;
    }

    void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this.parentToolbar;
        event.display = this.getDisplay();
        event.item = this;
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private void drawCheckBox(int xPosition) {
        this.gc.setForeground(this.getDisplay().getSystemColor(2));
        Point textSize = this.gc.stringExtent(this.getText());
        int yPosition = this.computeVerticalPosition(textSize.y);
        this.gc.drawRectangle(xPosition, yPosition, 13, 13);
        if (!this.selection) {
            return;
        }
        this.gc.drawPolyline(new int[]{xPosition + 2, yPosition + 6, xPosition + 5, yPosition + 9, xPosition + 10, yPosition + 3});
    }

    private void drawRadio(int xPosition) {
        this.gc.setForeground(this.getDisplay().getSystemColor(2));
        Point textSize = this.gc.stringExtent(this.getText());
        int yPosition = this.computeVerticalPosition(textSize.y);
        this.gc.drawOval(xPosition, yPosition, 13, 13);
        if (!this.selection) {
            return;
        }
        this.gc.setBackground(this.getDisplay().getSystemColor(2));
        this.gc.fillOval(xPosition + 3, yPosition + 3, 8, 8);
    }

    private int drawImage(int xPosition) {
        Image image = !this.isEnabled() ? this.disabledImage : (this.selection && (this.isToogleButon() || this.isPushButon() || this.isDropDown()) ? this.selectionImage : this.getImage());
        if (image == null) {
            return 0;
        }
        int yPosition = this.computeVerticalPosition(image.getBounds().height);
        this.gc.drawImage(image, xPosition, yPosition);
        return image.getBounds().width + 4;
    }

    private void drawText(int xPosition) {
        this.gc.setFont(this.parentToolbar.getFont());
        if (this.selection && (this.isToogleButon() || this.isPushButon() || this.isDropDown())) {
            this.gc.setForeground(this.textColorSelected);
        } else {
            this.gc.setForeground(this.textColor);
        }
        Point textSize = this.gc.stringExtent(this.getText());
        int yPosition = this.computeVerticalPosition(textSize.y);
        this.gc.drawText(this.getText(), xPosition, yPosition, true);
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.bounds;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public int getHeight() {
        this.checkWidget();
        if (this.height == -1) {
            return this.computeDefaultSize().y;
        }
        return this.height;
    }

    public RoundedToolbar getParent() {
        this.checkWidget();
        return this.parentToolbar;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public Image getSelectionImage() {
        this.checkWidget();
        return this.selectionImage;
    }

    public Color getTextColor() {
        this.checkWidget();
        return this.textColor;
    }

    public Color getTextColorSelected() {
        this.checkWidget();
        return this.textColorSelected;
    }

    public String getTooltipText() {
        this.checkWidget();
        return this.tooltipText;
    }

    public int getVerticalAlignment() {
        this.checkWidget();
        return this.verticalAlignment;
    }

    public int getWidth() {
        this.checkWidget();
        if (this.width == -1) {
            return this.computeDefaultSize().x;
        }
        return this.width;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this.alignment = alignment;
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (this.bounds == null) {
            SWT.error((int)4);
        }
        this.bounds = new Rectangle(Math.max(0, rectangle.x), Math.max(0, rectangle.y), Math.max(0, rectangle.width), Math.max(0, rectangle.height));
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        this.disabledImage = image;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.enabled = enabled;
    }

    public void setHeight(int height) {
        this.checkWidget();
        this.height = Math.max(height, 0);
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if (this.isToogleButon() || this.isCheckbox() || this.isRadio() || !selected) {
            this.selection = selected;
        }
    }

    public void setSelectionImage(Image image) {
        this.checkWidget();
        this.selectionImage = image;
    }

    public void setTextColor(Color textColor) {
        this.checkWidget();
        this.textColor = textColor;
    }

    public void setTextColorSelected(Color textColor) {
        this.checkWidget();
        this.textColorSelected = textColor;
    }

    public void setTooltipText(String string) {
        this.checkWidget();
        this.tooltipText = string == null ? "" : string;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.checkWidget();
        this.verticalAlignment = verticalAlignment;
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.width = Math.max(0, width);
    }

    boolean isToogleButon() {
        return (this.getStyle() & 2) != 0;
    }

    boolean isPushButon() {
        return (this.getStyle() & 8) != 0;
    }

    boolean isCheckbox() {
        return (this.getStyle() & 0x20) != 0;
    }

    boolean isRadio() {
        return (this.getStyle() & 0x10) != 0;
    }

    boolean isDropDown() {
        return (this.getStyle() & 4) != 0;
    }

    void forceSelection() {
        this.selection = true;
    }
}

