/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.roundedtoolbar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.opal.commons.AdvancedPath;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.roundedtoolbar.RoundedToolItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class RoundedToolbar
extends Canvas {
    private final List<RoundedToolItem> items;
    private int cornerRadius = 2;
    private static Color START_GRADIENT_COLOR_DEFAULT = SWTGraphicUtil.getColorSafely((int)245, (int)245, (int)245);
    private static Color END_GRADIENT_COLOR_DEFAULT = SWTGraphicUtil.getColorSafely((int)185, (int)185, (int)185);
    static Color BORDER_COLOR = SWTGraphicUtil.getColorSafely((int)66, (int)66, (int)66);
    private Color START_GRADIENT_COLOR = START_GRADIENT_COLOR_DEFAULT;
    private Color END_GRADIENT_COLOR = END_GRADIENT_COLOR_DEFAULT;

    public RoundedToolbar(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.items = new ArrayList<RoundedToolItem>();
        this.addListeners();
    }

    public RoundedToolbar(Composite parent, int style, Color startGradientColor, Color endGradientColor) {
        super(parent, style | 0x20000000);
        this.items = new ArrayList<RoundedToolItem>();
        this.addListeners();
        this.START_GRADIENT_COLOR = startGradientColor;
        this.END_GRADIENT_COLOR = endGradientColor;
    }

    private void addListeners() {
        this.addListener(3, event -> {
            if (event.button != 1) {
                return;
            }
            RoundedToolItem item = this.items.stream().filter(element -> element.getBounds().contains(event.x, event.y) && element.isEnabled()).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            if (item.isPushButon()) {
                item.forceSelection();
            } else {
                item.setSelection(!item.getSelection());
            }
            this.redraw();
            this.update();
        });
        this.addListener(4, event -> {
            if (event.button != 1) {
                return;
            }
            RoundedToolItem item = this.items.stream().filter(element -> element.getBounds().contains(event.x, event.y) && element.isEnabled()).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            if (item.isPushButon()) {
                item.setSelection(false);
            }
            item.fireSelectionEvent();
            if (item.isRadio()) {
                for (RoundedToolItem current : this.items) {
                    if (((Object)((Object)current)).equals((Object)item)) continue;
                    current.setSelection(false);
                    current.fireSelectionEvent();
                }
            }
            this.redraw();
            this.update();
        });
        this.addListener(32, event -> {
            RoundedToolItem item = this.items.stream().filter(element -> element.getBounds().contains(event.x, event.y)).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            this.setToolTipText(item.getTooltipText() == null ? "" : item.getTooltipText());
        });
        this.addPaintListener(e -> this.paintControl(e));
    }

    void addItem(RoundedToolItem roundedToolItem) {
        this.items.add(roundedToolItem);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        for (RoundedToolItem item : this.items) {
            width += item.getWidth();
            height = Math.max(height, item.getHeight());
        }
        return new Point(Math.max(width, wHint), Math.max(height, hHint));
    }

    public int getCornerRadius() {
        this.checkWidget();
        return this.cornerRadius;
    }

    public RoundedToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index > this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(index);
    }

    public RoundedToolItem getItem(Point point) {
        this.checkWidget();
        RoundedToolItem item = this.items.stream().filter(element -> element.getBounds().contains(point)).findFirst().orElse(null);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public RoundedToolItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new RoundedToolItem[this.items.size()]);
    }

    public int indexOf(RoundedToolItem item) {
        this.checkWidget();
        return this.items.indexOf((Object)item);
    }

    protected void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setAdvanced(true);
        gc.setAntialias(1);
        int width = this.getSize().x;
        int height = this.getSize().y;
        this.drawBorders(gc, width, height);
        Iterator<RoundedToolItem> it = this.items.iterator();
        int x = 0;
        while (it.hasNext()) {
            RoundedToolItem item = it.next();
            item.drawButton(gc, x, height, !it.hasNext());
            x += item.getWidth();
        }
    }

    private void drawBorders(GC gc, int width, int height) {
        AdvancedPath path = new AdvancedPath((Device)this.getDisplay());
        path.addRoundRectangle(0.0f, 0.0f, (float)width, (float)height, (float)this.cornerRadius, (float)this.cornerRadius);
        gc.setClipping((Path)path);
        gc.setForeground(this.START_GRADIENT_COLOR);
        gc.setBackground(this.END_GRADIENT_COLOR);
        gc.fillGradientRectangle(0, 0, width, height, true);
        gc.setForeground(BORDER_COLOR);
        gc.drawRoundRectangle(0, 0, width - 1, height - 1, this.cornerRadius, this.cornerRadius);
        gc.setClipping(null);
    }

    void removeItem(RoundedToolItem roundedToolItem) {
        this.checkWidget();
        this.items.remove((Object)roundedToolItem);
    }

    public void setCornerRadius(int cornerRadius) {
        this.checkWidget();
        this.cornerRadius = cornerRadius;
    }
}

