/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.progresscircle.snippets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class BasePanel {
    protected Text circleSize;
    protected Text thickness;
    protected Button checkbox;

    BasePanel() {
    }

    protected void createCommonPart(Group group) {
        Color white = group.getDisplay().getSystemColor(1);
        this.createLeftLabel((Composite)group, "Circle size");
        this.circleSize = this.createTextWidget((Composite)group, 100);
        this.createConstraintsLabel((Composite)group, "(<1000)");
        this.createLeftLabel((Composite)group, "Thickness");
        this.thickness = this.createTextWidget((Composite)group, 10);
        this.createConstraintsLabel((Composite)group, "(1-50)");
        this.createLeftLabel((Composite)group, "Show text");
        this.checkbox = new Button((Composite)group, 32);
        GridData gd = new GridData(4, 2, false, false);
        this.checkbox.setLayoutData((Object)gd);
        this.checkbox.setBackground(white);
        this.checkbox.setSelection(true);
        new Label((Composite)group, 0);
    }

    protected void showError(Shell shell, String message) {
        MessageBox mb = new MessageBox(shell, 33);
        mb.setText("Error");
        mb.setMessage(message);
        mb.open();
    }

    protected void createLeftLabel(Composite composite, String text) {
        Label lbl = new Label(composite, 0);
        lbl.setText(text);
        lbl.setBackground(composite.getDisplay().getSystemColor(1));
        lbl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    protected Text createTextWidget(Composite composite, int value) {
        Text txt = new Text(composite, 2048);
        txt.setText(String.valueOf(value));
        txt.setTextLimit(4);
        GridData gd = new GridData(4, 2, false, false);
        gd.minimumWidth = 40;
        txt.setLayoutData((Object)gd);
        return txt;
    }

    protected void createConstraintsLabel(Composite composite, String text) {
        Label lbl = new Label(composite, 0);
        lbl.setText(text);
        lbl.setBackground(composite.getDisplay().getSystemColor(1));
        lbl.setLayoutData((Object)new GridData(1, 2, true, false));
    }
}

