/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.example.util.MyLog;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;

public class FileUtil {
    public static String justFilename(String filename) {
        File file = new File(filename);
        return file.getName();
    }

    public static String justPath(String filename) {
        File file = new File(filename);
        filename = filename.replaceAll(file.getName(), "");
        return filename;
    }

    public static String readFile(String filename) throws XViewerException {
        return FileUtil.readFile(new File(filename));
    }

    public static String readFile(File file) throws XViewerException {
        return FileUtil.fileToString(file);
    }

    public static String fileToString(File file) throws XViewerException {
        try {
            int ch;
            StringBuffer buffer = new StringBuffer();
            InputStreamReader inStream = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            BufferedReader in = new BufferedReader(inStream);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException ex) {
            throw new XViewerException((Throwable)ex);
        }
    }

    public static void writeStringToFile(String str, File file) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        char[] chars = str.toCharArray();
        out.write(chars, 0, chars.length);
        out.close();
    }

    public static List<String> readListFromDir(File directory, FilenameFilter filter) {
        ArrayList<String> list = new ArrayList<String>(400);
        if (directory == null) {
            MyLog.log(Activator.class, Level.SEVERE, "Invalid directory path");
            return list;
        }
        Object[] files = directory.listFiles(filter);
        if (files == null) {
            MyLog.log(Activator.class, Level.SEVERE, "Invalid path: " + directory);
            return list;
        }
        if (files.length > 0) {
            Arrays.sort(files);
        }
        int i = 0;
        while (i < files.length) {
            list.add(((File)files[i]).getName());
            ++i;
        }
        return list;
    }
}

