/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SearchDataUI {
    private Text searchText;
    private final XViewer xViewer;
    private Matcher match;
    private boolean search = false;
    private Button regularExpression;
    private boolean regex;
    private final boolean searchRealTime;

    public SearchDataUI(XViewer xViewer, boolean searchRealTime) {
        this.xViewer = xViewer;
        this.searchRealTime = searchRealTime;
    }

    public void createWidgets(Composite bar) {
        Label label = new Label(bar, 0);
        label.setText(XViewerText.get("SearchDataUI.prompt"));
        label.setToolTipText(XViewerText.get("SearchDataUI.prompt.tooltip"));
        GridData gd = new GridData(131072, 0, false, false);
        label.setLayoutData((Object)gd);
        this.searchText = new Text(bar, 2052);
        gd = new GridData(131072, 0, false, false);
        gd.widthHint = 100;
        this.searchText.setLayoutData((Object)gd);
        this.searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050 || SearchDataUI.this.searchRealTime) {
                    String newText = SearchDataUI.this.searchText.getText();
                    if (newText.trim().length() == 0) {
                        SearchDataUI.this.search = false;
                        SearchDataUI.this.match = Pattern.compile(SearchDataUI.this.searchText.getText()).matcher("");
                    } else {
                        SearchDataUI.this.regex = true;
                        if (!SearchDataUI.this.regularExpression.getSelection()) {
                            SearchDataUI.this.regex = false;
                            newText = newText.replace("*", ".*");
                            newText = ".*" + newText + ".*";
                        }
                        SearchDataUI.this.match = Pattern.compile(newText, 42).matcher("");
                        SearchDataUI.this.search = true;
                    }
                    SearchDataUI.this.xViewer.refresh();
                }
            }
        });
        Label searchLabel = new Label(bar, 0);
        searchLabel.setLayoutData((Object)new GridData(131072, 0, false, false));
        searchLabel.setImage(XViewerLib.getImage("clear.gif"));
        this.regularExpression = new Button(bar, 32);
        this.regularExpression.setText(XViewerText.get("regex.prompt"));
        this.regularExpression.setToolTipText(XViewerText.get("regex.prompt.tooltip"));
        this.regularExpression.setLayoutData((Object)new GridData(131072, 0, false, false));
        searchLabel.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                SearchDataUI.this.searchText.setText("");
                SearchDataUI.this.search = false;
                SearchDataUI.this.match = Pattern.compile(SearchDataUI.this.searchText.getText()).matcher("");
                SearchDataUI.this.xViewer.refresh();
            }
        });
    }

    public void clear() {
        this.searchText.setText("");
        this.xViewer.getCustomizeMgr().setFilterText("", false);
    }

    public void appendToStatusLabel(StringBuffer sb) {
        if (this.searchText != null && !this.searchText.getText().equals("")) {
            sb.append(XViewerText.get("SearchDataUI.status"));
        }
    }

    public boolean match(String textString) {
        if (this.search) {
            if (this.regex) {
                this.match.reset(textString);
                return this.match.matches();
            }
            this.match.reset(textString);
            return this.match.matches();
        }
        return false;
    }

    public boolean isSearch() {
        return this.search;
    }
}

