/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize.dialog;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.customize.CustomizeDataLabelProvider;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public class CustomizationDataSelectionDialog
extends ListDialog {
    private Text custText;
    private String enteredName;
    private boolean saveShared = false;
    private Button saveSharedCheck;
    private CustomizeData selectedCustData = null;
    private final XViewer xViewer;

    public CustomizationDataSelectionDialog(XViewer xViewer, List<CustomizeData> custDatas) {
        this(Display.getCurrent().getActiveShell(), xViewer, custDatas);
    }

    public CustomizationDataSelectionDialog(Shell parent, XViewer xViewer, List<CustomizeData> custDatas) {
        super(parent);
        this.xViewer = xViewer;
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setLabelProvider(new CustomizeDataLabelProvider(xViewer));
        this.setInput(custDatas);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(XViewerText.get("CustomizationDataSelectionDialog.title"));
        this.setMessage(XViewerText.get("CustomizationDataSelectionDialog.message"));
    }

    protected void okPressed() {
        if (this.custText.getText().equals("") && this.getSelectedCustData() == null) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_cust_selection"));
            return;
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite container) {
        Control c = super.createDialogArea(container);
        Composite comp = new Composite(container, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        comp.setLayout((Layout)new GridLayout(2, true));
        Label custTextLabel = new Label(comp, 0);
        custTextLabel.setText(XViewerText.get("CustomizationDataSelectionDialog.prompt"));
        this.custText = new Text(comp, 2048);
        this.custText.setFocus();
        this.custText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.custText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomizationDataSelectionDialog.this.enteredName = CustomizationDataSelectionDialog.this.custText.getText();
            }
        });
        if (this.xViewer.getXViewerFactory().isAdmin()) {
            comp = new Composite(container, 0);
            comp.setLayoutData((Object)new GridData(1, 1, false, false));
            comp.setLayout((Layout)new GridLayout(2, false));
            Label saveSharedCheckLabel = new Label(comp, 0);
            saveSharedCheckLabel.setText(XViewerText.get("checkbox.shared"));
            this.saveSharedCheck = new Button(comp, 32);
            this.saveSharedCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomizationDataSelectionDialog.this.saveShared = CustomizationDataSelectionDialog.this.saveSharedCheck.getSelection();
                }
            });
        }
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizationDataSelectionDialog.this.selectedCustData = CustomizationDataSelectionDialog.this.getSelectedCustomizeData();
                if (CustomizationDataSelectionDialog.this.saveSharedCheck != null) {
                    CustomizationDataSelectionDialog.this.saveSharedCheck.setSelection(!CustomizationDataSelectionDialog.this.selectedCustData.isPersonal());
                    CustomizationDataSelectionDialog.this.saveShared = !CustomizationDataSelectionDialog.this.selectedCustData.isPersonal();
                }
            }
        });
        return c;
    }

    private CustomizeData getSelectedCustomizeData() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Iterator i = selection.iterator();
        return (CustomizeData)i.next();
    }

    public CustomizeData getSelectedCustData() {
        return this.selectedCustData;
    }

    public String getEnteredName() {
        return this.enteredName;
    }

    public boolean isSaveShared() {
        return this.saveShared;
    }

    public void setSaveShared(boolean saveShared) {
        this.saveShared = saveShared;
    }
}

