/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.timeeditor;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.compositetable.day.CalendarableItemEvent;
import org.eclipse.nebula.widgets.compositetable.day.CalendarableItemEventHandler;
import org.eclipse.nebula.widgets.compositetable.day.NewEvent;
import org.eclipse.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractEventEditor
extends Composite {
    private int defaultEventDuration;
    private List insertHandlers = new ArrayList();

    public AbstractEventEditor(Composite parent, int style) {
        super(parent, style);
    }

    public abstract void refresh();

    public NewEvent fireInsert(Date date, boolean allDayEvent) {
        this.checkWidget();
        CalendarableItem item = new CalendarableItem(date);
        item.setAllDayEvent(allDayEvent);
        item.setStartTime(date);
        item.setEndTime(this.incrementHour(date, this.getDefaultEventDuration()));
        CalendarableItemEvent e = new CalendarableItemEvent();
        e.calendarableItem = item;
        if (this.fireEvents(e, this.insertHandlers)) {
            this.refresh();
            return (NewEvent)e.result;
        }
        return null;
    }

    public void addItemInsertHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        if (handler == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.insertHandlers.add(handler);
    }

    public void removeItemInsertHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        if (handler == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.insertHandlers.remove(handler);
    }

    public int getDefaultEventDuration() {
        this.checkWidget();
        return this.defaultEventDuration;
    }

    public void setDefaultEventDuration(int defaultEventDuration) {
        this.checkWidget();
        this.defaultEventDuration = defaultEventDuration;
    }

    protected boolean fireEvents(CalendarableItemEvent e, List handlers) {
        CalendarableItemEventHandler h;
        Iterator i = handlers.iterator();
        while (i.hasNext()) {
            h = (CalendarableItemEventHandler)i.next();
            h.handleRequest(e);
            if (!e.doit) break;
        }
        i = handlers.iterator();
        while (i.hasNext()) {
            h = (CalendarableItemEventHandler)i.next();
            h.requestHandled(e);
            if (!e.doit) break;
        }
        return e.doit;
    }

    private Date incrementHour(Date date, int increment) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, increment);
        return c.getTime();
    }
}

