/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.paperclips.example;

import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.widgets.PrintPreview;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PaperclipsExampleTab
extends AbstractExampleTab {
    private static final String BUNDLE = "org.eclipse.nebula.widgets.paperclips.example";
    static /* synthetic */ Class class$0;

    public Control createControl(Composite parent) {
        Composite shell = new Composite(parent, 0);
        final PrintJob job = new PrintJob("GridPrintVerticalAlignmentExample.java", PaperclipsExampleTab.createPrint());
        shell.setLayout((Layout)new GridLayout());
        Composite buttonPanel = new Composite(shell, 0);
        buttonPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonPanel.setLayout((Layout)new RowLayout(256));
        final PrintPreview preview = new PrintPreview(shell, 2048);
        Button prev = new Button(buttonPanel, 8);
        prev.setText("<< Prev");
        prev.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                preview.setPageIndex(Math.max(preview.getPageIndex() - 1, 0));
            }
        });
        Button next = new Button(buttonPanel, 8);
        next.setText("Next >>");
        next.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                preview.setPageIndex(Math.min(preview.getPageIndex() + 1, preview.getPageCount() - 1));
            }
        });
        Button print = new Button(buttonPanel, 8);
        print.setText("Print");
        print.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PaperClips.print((PrintJob)job, (PrinterData)new PrinterData());
            }
        });
        preview.setLayoutData((Object)new GridData(4, 4, true, true));
        preview.setFitHorizontal(true);
        preview.setFitVertical(true);
        preview.setPrintJob(job);
        return shell;
    }

    public static Print createPrint() {
        DefaultGridLook look = new DefaultGridLook(5, 5);
        look.setHeaderGap(5);
        GridPrint grid = new GridPrint("d:g, d, d:g, d, d:g, d, d:g", (GridLook)look);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.nebula.widgets.paperclips.example.PaperclipsExampleTab");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageData imageData = new ImageData(clazz.getResourceAsStream("logo.png"));
        ImagePrint image = new ImagePrint(imageData);
        image.setDPI(300, 300);
        LinePrint verticalRule = new LinePrint(512);
        grid.addHeader(0x1000000, -1, (Print)new TextPrint("Column 1"));
        grid.addHeader(-1, 4, (Print)verticalRule);
        grid.addHeader(0x1000000, -1, (Print)new TextPrint("Column 2"));
        grid.addHeader(-1, 4, (Print)verticalRule);
        grid.addHeader(0x1000000, -1, (Print)new TextPrint("Column 3"));
        grid.addHeader(-1, 4, (Print)verticalRule);
        grid.addHeader(0x1000000, -1, (Print)new TextPrint("Column 4"));
        grid.addHeader((Print)new LinePrint(256), -1);
        grid.add(16384, 0x1000000, (Print)image);
        grid.add(-1, 4, (Print)verticalRule);
        grid.add(-1, -1, (Print)new TextPrint("triple\nline\nleft\n"));
        grid.add(-1, 4, (Print)verticalRule);
        grid.add(0x1000000, 0x1000000, (Print)new TextPrint("double line\ncenter", 0x1000000));
        grid.add(-1, 4, (Print)verticalRule);
        grid.add(131072, 1024, (Print)new TextPrint("single line right"));
        grid.add((Print)new LinePrint(256), -1);
        grid.add(0x1000000, 0x1000000, (Print)new TextPrint("several\nlines\nof\ntext\nhere", 0x1000000));
        grid.add(-1, 4, (Print)verticalRule);
        grid.add(16384, 4, (Print)verticalRule);
        grid.add(-1, 4, (Print)verticalRule);
        grid.add(0x1000000, 4, (Print)verticalRule);
        grid.add(-1, 4, (Print)verticalRule);
        grid.add(131072, 4, (Print)verticalRule);
        return grid;
    }

    public void createParameters(Composite parent) {
    }

    public String[] createLinks() {
        String[] links = new String[]{"<a href=\"https://github.com/eclipse/nebula/tree/master/widgets/paperclips/org.eclipse.nebula.paperclips.snippets/src/org/eclipse/nebula/paperclips/snippets\" >Paperclips Snippets</a>"};
        return links;
    }
}

