/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.LinePiece;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class LineIterator
implements PrintIterator {
    private final Device device;
    private final GC gc;
    final int orientation;
    final Point thickness;
    final RGB rgb;
    private boolean hasNext = true;

    LineIterator(LinePrint print, Device device, GC gc) {
        this.device = device;
        this.gc = gc;
        this.orientation = print.orientation;
        this.rgb = print.rgb;
        Point dpi = device.getDPI();
        this.thickness = new Point(Math.max(1, (int)Math.round(print.thickness * (double)dpi.x / 72.0)), Math.max(1, (int)Math.round(print.thickness * (double)dpi.y / 72.0)));
    }

    LineIterator(LineIterator that) {
        this.device = that.device;
        this.gc = that.gc;
        this.orientation = that.orientation;
        this.rgb = that.rgb;
        this.hasNext = that.hasNext;
        this.thickness = that.thickness;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    Point getSize(int width, int height) {
        return this.orientation == 512 ? new Point(this.thickness.x, height) : new Point(width, this.thickness.y);
    }

    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        Point size = this.getSize(width, height);
        if (size.x > width || size.y > height) {
            return null;
        }
        LinePiece result = new LinePiece(this.device, size, this.rgb);
        this.hasNext = false;
        return result;
    }

    public Point minimumSize() {
        return new Point(this.thickness.x, this.thickness.y);
    }

    public Point preferredSize() {
        return new Point(this.thickness.x, this.thickness.y);
    }

    public PrintIterator copy() {
        return new LineIterator(this);
    }
}

