/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.grid.internal;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.grid.GridCell;
import org.eclipse.nebula.paperclips.core.grid.internal.GridCellIterator;
import org.eclipse.nebula.paperclips.core.internal.util.PaperClipsUtil;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class GridCellImpl
implements GridCell {
    private final int hAlignment;
    private final int vAlignment;
    private final Print target;
    private final int colspan;

    public GridCellImpl(int hAlignment, int vAlignment, Print target, int colspan) {
        Util.notNull(target);
        this.hAlignment = GridCellImpl.checkHorizontalAlignment(hAlignment);
        this.vAlignment = GridCellImpl.checkVerticalAlignment(vAlignment);
        this.target = target;
        this.colspan = this.checkColspan(colspan);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.colspan;
        result = 31 * result + this.hAlignment;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + this.vAlignment;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridCell other = (GridCell)obj;
        if (this.colspan != other.getColSpan()) {
            return false;
        }
        if (this.hAlignment != other.getHorizontalAlignment()) {
            return false;
        }
        if (this.target == null ? other.getContent() != null : !this.target.equals(other.getContent())) {
            return false;
        }
        return this.vAlignment == other.getVerticalAlignment();
    }

    public Point getAlignment() {
        return new Point(this.hAlignment, this.vAlignment);
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public Print getContent() {
        return this.target;
    }

    public int getColSpan() {
        return this.colspan;
    }

    private static int checkHorizontalAlignment(int hAlignment) {
        if ((hAlignment = PaperClipsUtil.firstMatch(hAlignment, new int[]{-1, 16384, 0x1000000, 131072}, 0)) == 0) {
            PaperClips.error(5, "Alignment argument must be one of SWT.LEFT, SWT.CENTER, SWT.RIGHT, or SWT.DEFAULT");
        }
        return hAlignment;
    }

    private static int checkVerticalAlignment(int vAlignment) {
        if ((vAlignment = PaperClipsUtil.firstMatch(vAlignment, new int[]{-1, 128, 0x1000000, 1024, 4}, 0)) == 0) {
            PaperClips.error(5, "Alignment argument must be one of SWT.TOP, SWT.CENTER, SWT.BOTTOM, SWT.DEFAULT, or SWT.FILL");
        }
        return vAlignment;
    }

    private int checkColspan(int colspan) {
        if (colspan <= 0 && colspan != -1) {
            PaperClips.error(5, "colspan must be a positive number or GridPrint.REMAINDER");
        }
        return colspan;
    }

    public GridCellIterator iterator(Device device, GC gc) {
        return new GridCellIterator(this, device, gc);
    }
}

