/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.internal.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.paperclips.core.PaperClips;

public class Util {
    public static boolean sameClass(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.getClass() == right.getClass();
    }

    public static boolean equal(Object left, Object right) {
        if (!Util.sameClass(left, right)) {
            return false;
        }
        if (left == right) {
            return true;
        }
        Class<?> clazz = left.getClass();
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isPrimitive()) {
                if (componentType == Byte.TYPE) {
                    return Arrays.equals((byte[])left, (byte[])right);
                }
                if (componentType == Short.TYPE) {
                    return Arrays.equals((short[])left, (short[])right);
                }
                if (componentType == Integer.TYPE) {
                    return Arrays.equals((int[])left, (int[])right);
                }
                if (componentType == Long.TYPE) {
                    return Arrays.equals((long[])left, (long[])right);
                }
                if (componentType == Character.TYPE) {
                    return Arrays.equals((char[])left, (char[])right);
                }
                if (componentType == Float.TYPE) {
                    return Arrays.equals((float[])left, (float[])right);
                }
                if (componentType == Double.TYPE) {
                    return Arrays.equals((double[])left, (double[])right);
                }
                if (componentType == Boolean.TYPE) {
                    return Arrays.equals((boolean[])left, (boolean[])right);
                }
            }
            return Util.equal((Object[])left, (Object[])right);
        }
        return left.equals(right);
    }

    private static boolean equal(Object[] left, Object[] right) {
        int length = left.length;
        if (length != right.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!Util.equal(left[i], right[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equal(double left, double right) {
        return Double.doubleToLongBits(left) == Double.doubleToLongBits(right);
    }

    public static void noNulls(List list) {
        Util.notNull(list);
        if (list.contains(null)) {
            PaperClips.error(4);
        }
    }

    public static void noNulls(Object[] objs) {
        Util.notNull(objs);
        int i = 0;
        while (i < objs.length) {
            Util.notNull(objs[i]);
            ++i;
        }
    }

    public static void notNull(Object obj) {
        if (obj == null) {
            PaperClips.error(4);
        }
    }

    public static void notNull(Object o1, Object o2) {
        Util.notNull(o1);
        Util.notNull(o2);
    }

    public static void notNull(Object o1, Object o2, Object o3) {
        Util.notNull(o1);
        Util.notNull(o2);
        Util.notNull(o3);
    }
}

