/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.text;

import java.util.ArrayList;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.ResourcePool;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.nebula.paperclips.core.text.internal.TextPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class TextIterator
implements PrintIterator {
    private final Device device;
    private final GC gc;
    final String text;
    final String[] lines;
    final TextStyle style;
    final boolean wordSplitting;
    final Point minimumSize;
    final Point preferredSize;
    int row;
    int col;

    TextIterator(TextPrint print, Device device, GC gc) {
        this.device = device;
        this.gc = gc;
        this.text = print.text;
        this.lines = print.text.split("(\r)?\n");
        this.style = print.style;
        this.wordSplitting = print.wordSplitting;
        this.minimumSize = this.maxExtent(this.text.split("\\s"));
        this.preferredSize = this.maxExtent(this.lines);
        this.row = 0;
        this.col = 0;
    }

    TextIterator(TextIterator that) {
        this.device = that.device;
        this.gc = that.gc;
        this.text = that.text;
        this.lines = that.lines;
        this.style = that.style;
        this.wordSplitting = that.wordSplitting;
        this.minimumSize = that.minimumSize;
        this.preferredSize = that.preferredSize;
        this.row = that.row;
        this.col = that.col;
    }

    public boolean hasNext() {
        return this.row < this.lines.length;
    }

    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error("No more content.");
        }
        Font oldFont = this.initGC();
        PrintPiece result = this.internalNext(width, height);
        this.restoreGC(oldFont);
        return result;
    }

    private PrintPiece internalNext(int width, int height) {
        FontMetrics fm = this.gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        if (height < lineHeight) {
            return null;
        }
        int maxLines = height / lineHeight;
        String[] nextLines = this.nextLines(width, maxLines);
        if (nextLines.length == 0) {
            return null;
        }
        int maxWidth = this.maxExtent((String[])nextLines).x;
        Point size = new Point(maxWidth, nextLines.length * lineHeight);
        int ascent = fm.getAscent() + fm.getLeading();
        return new TextPiece(this.device, this.style, nextLines, size, ascent);
    }

    private Font initGC() {
        Font oldFont = this.gc.getFont();
        FontData fontData = this.style.getFontData();
        if (fontData != null) {
            this.gc.setFont(ResourcePool.forDevice(this.device).getFont(fontData));
        }
        return oldFont;
    }

    private void restoreGC(Font oldFont) {
        this.gc.setFont(oldFont);
    }

    private String[] nextLines(int width, int maxLines) {
        ArrayList<String> nextLines = new ArrayList<String>(Math.min(this.lines.length, maxLines));
        while (nextLines.size() < maxLines && this.row < this.lines.length) {
            String line = this.lines[this.row].substring(this.col);
            int charCount = this.findLineBreak(this.gc, line, width);
            if (line.length() > 0 && charCount == 0) break;
            String thisLine = line.substring(0, charCount);
            nextLines.add(thisLine);
            this.col += charCount;
            this.skipWhitespace();
            this.advanceToNextRowIfCurrentRowCompleted();
        }
        return nextLines.toArray(new String[nextLines.size()]);
    }

    private void skipWhitespace() {
        while (this.col < this.lines[this.row].length() && Character.isWhitespace(this.lines[this.row].charAt(this.col))) {
            ++this.col;
        }
    }

    private void advanceToNextRowIfCurrentRowCompleted() {
        if (this.col >= this.lines[this.row].length()) {
            ++this.row;
            this.col = 0;
        }
    }

    public Point minimumSize() {
        return new Point(this.minimumSize.x, this.minimumSize.y);
    }

    public Point preferredSize() {
        return new Point(this.preferredSize.x, this.preferredSize.y);
    }

    private Point maxExtent(String[] text) {
        Font oldFont = this.gc.getFont();
        try {
            this.initGC();
            FontMetrics fm = this.gc.getFontMetrics();
            int maxWidth = 0;
            int i = 0;
            while (i < text.length) {
                String textPiece = text[i];
                maxWidth = Math.max(maxWidth, this.gc.stringExtent((String)textPiece).x);
                ++i;
            }
            Point point = new Point(maxWidth, fm.getHeight());
            return point;
        }
        finally {
            this.restoreGC(oldFont);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int findLineBreak(GC gc, String text, int width) {
        loIndex = 0;
        hiIndex = text.length();
        pixelWidth = gc.stringExtent((String)text).x;
        if (pixelWidth > width) ** GOTO lbl15
        return hiIndex;
lbl-1000:
        // 1 sources

        {
            midIndex = (loIndex + hiIndex + 1) / 2;
            midWidth = gc.stringExtent((String)text.substring((int)0, (int)midIndex)).x;
            if (midWidth < width) {
                loIndex = midIndex;
                continue;
            }
            if (midWidth > width) {
                hiIndex = midIndex - 1;
                continue;
            }
            loIndex = hiIndex = midIndex;
lbl15:
            // 4 sources

            ** while (loIndex < hiIndex)
        }
lbl16:
        // 1 sources

        return this.findWordBreak(text, loIndex);
    }

    int findWordBreak(String text, int maxLength) {
        if (maxLength == text.length()) {
            return maxLength;
        }
        int i = maxLength;
        while (i >= 0) {
            if (Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            --i;
        }
        if (this.wordSplitting) {
            return maxLength;
        }
        return 0;
    }

    public PrintIterator copy() {
        return new TextIterator(this);
    }
}

