/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerTreeReport;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.customize.IXViewerCustomizations;
import org.eclipse.nebula.widgets.xviewer.customize.XViewerCustomMenu;
import org.eclipse.nebula.widgets.xviewer.customize.XViewerCustomizations;
import org.eclipse.nebula.widgets.xviewer.customize.dialog.XViewerCustomizeDialog;

public abstract class XViewerFactory
implements IXViewerFactory {
    private String namespace;
    private final List<XViewerColumn> columns = new ArrayList<XViewerColumn>();
    private final Map<String, XViewerColumn> idToColumn = new HashMap<String, XViewerColumn>();

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public XViewerFactory(String namespace) {
        this.namespace = namespace;
    }

    public void registerColumns(Collection<? extends XViewerColumn> columns) {
        for (XViewerColumn xViewerColumn : columns) {
            this.registerColumns(xViewerColumn);
        }
    }

    public void registerColumns(XViewerColumn ... columns) {
        if (columns.length == 0) {
            throw new IllegalArgumentException("columns can't be null");
        }
        XViewerColumn[] xViewerColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            XViewerColumn xCol = xViewerColumnArray[n2];
            if (!this.columnRegistered(xCol)) {
                this.columns.add(xCol);
                this.idToColumn.put(xCol.getId(), xCol);
            }
            ++n2;
        }
    }

    public boolean columnRegistered(XViewerColumn column) {
        return this.columns.contains(column);
    }

    public void clearColumnRegistration() {
        this.columns.clear();
        this.idToColumn.clear();
    }

    @Override
    public XViewerSorter createNewXSorter(XViewer xViewer) {
        return new XViewerSorter(xViewer);
    }

    @Override
    public CustomizeData getDefaultTableCustomizeData() {
        CustomizeData custData = new CustomizeData();
        custData.setNameSpace(this.namespace);
        custData.getColumnData().setColumns(this.getColumns());
        return custData;
    }

    @Override
    public XViewerColumn getDefaultXViewerColumn(String id) {
        XViewerColumn col = this.idToColumn.get(id);
        if (col == null) {
            return null;
        }
        return col.copy();
    }

    public void overrideShowDefault(String id, boolean show) {
        XViewerColumn col = this.idToColumn.get(id);
        col.setShow(show);
    }

    @Override
    public IXViewerCustomizations getXViewerCustomizations() {
        return new XViewerCustomizations();
    }

    @Override
    public XViewerCustomMenu getXViewerCustomMenu() {
        return new XViewerCustomMenu();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public List<XViewerColumn> getColumns() {
        ArrayList<XViewerColumn> columnCopy = new ArrayList<XViewerColumn>();
        for (XViewerColumn xCol : this.columns) {
            columnCopy.add(xCol.copy());
        }
        return columnCopy;
    }

    @Override
    public XViewerTreeReport getXViewerTreeReport(XViewer viewer) {
        return null;
    }

    @Override
    public boolean isFilterUiAvailable() {
        return true;
    }

    @Override
    public boolean isHeaderBarAvailable() {
        return true;
    }

    @Override
    public boolean isLoadedStatusLabelAvailable() {
        return true;
    }

    @Override
    public boolean isSearchUiAvailable() {
        return true;
    }

    @Override
    public boolean isCellGradientOn() {
        return false;
    }

    @Override
    public boolean isSearhTop() {
        return false;
    }

    @Override
    public Dialog getCustomizeDialog(XViewer xViewer) {
        return new XViewerCustomizeDialog(xViewer);
    }
}

