/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.ArrayTreeContentProvider;
import org.eclipse.nebula.widgets.xviewer.util.internal.StringLabelProvider;
import org.eclipse.nebula.widgets.xviewer.util.internal.StringNameComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class EnumStringMultiSelectionDialog
extends CheckedTreeSelectionDialog {
    private Button addSelectedRadioButton;
    private Button replaceAllRadioButton;
    private Button deleteSelectedRadioButton;
    private Selection selected = Selection.AddSelection;
    private boolean enableReplace = false;
    private boolean enableDelete = false;

    public EnumStringMultiSelectionDialog(String displayName, Collection<String> enums, Collection<String> selEnums) {
        super(Display.getCurrent().getActiveShell(), (ILabelProvider)new StringLabelProvider(), (ITreeContentProvider)new ArrayTreeContentProvider());
        this.setTitle(String.valueOf(XViewerText.get("EnumStringMultiSelectionDialog.title")) + " " + displayName);
        this.setMessage(String.format(XViewerText.get("EnumStringMultiSelectionDialog.message"), displayName));
        this.setInput(enums);
        this.setComparator(new StringNameComparator());
        this.setInitialSelections(selEnums.toArray());
    }

    public EnumStringMultiSelectionDialog(String displayName, Collection<String> enums, Collection<String> selEnums, boolean enableReplace, boolean enableDelete) {
        this(displayName, enums, selEnums);
        this.enableDelete = enableDelete;
        this.enableReplace = enableReplace;
    }

    protected Control createDialogArea(Composite container) {
        Control c = super.createDialogArea(container);
        Composite comp = new Composite(container, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0).setText(XViewerText.get("EnumStringMultiSelectionDialog.label.add"));
        this.addSelectedRadioButton = new Button(comp, 32);
        this.addSelectedRadioButton.setSelection(true);
        this.addSelectedRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (EnumStringMultiSelectionDialog.this.addSelectedRadioButton.getSelection()) {
                    EnumStringMultiSelectionDialog.this.selected = Selection.AddSelection;
                }
            }
        });
        if (this.enableReplace) {
            new Label(comp, 0).setText(XViewerText.get("EnumStringMultiSelectionDialog.label.replace"));
            this.replaceAllRadioButton = new Button(comp, 32);
            this.replaceAllRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    if (EnumStringMultiSelectionDialog.this.replaceAllRadioButton.getSelection()) {
                        EnumStringMultiSelectionDialog.this.selected = Selection.ReplaceAll;
                    }
                }
            });
        }
        if (this.enableDelete) {
            new Label(comp, 0).setText(XViewerText.get("EnumStringMultiSelectionDialog.label.remove"));
            this.deleteSelectedRadioButton = new Button(comp, 32);
            this.deleteSelectedRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    if (EnumStringMultiSelectionDialog.this.deleteSelectedRadioButton.getSelection()) {
                        EnumStringMultiSelectionDialog.this.selected = Selection.DeleteSelected;
                    }
                }
            });
        }
        return c;
    }

    public Selection getSelected() {
        return this.selected;
    }

    public static enum Selection {
        AddSelection,
        ReplaceAll,
        DeleteSelected;

    }
}

