/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.starrating;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.starrating.Star;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StarRating
extends Canvas {
    private static final int SIZE_SMALL = 16;
    private static final int SIZE_BIG = 32;
    private SIZE sizeOfStars = SIZE.SMALL;
    private int maxNumberOfStars;
    private int currentNumberOfStars = 0;
    private static final int DEFAULT_MAX_NUMBERS_OF_STARS = 5;
    private final List<Star> stars;
    private int orientation;
    private final List<SelectionListener> selectionListeners;

    public StarRating(Composite parent, int style) {
        super(parent, StarRating.checkStyle(style) | 0x20000000);
        this.orientation = (style & 0x200) != 0 ? 512 : 256;
        this.stars = new ArrayList<Star>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.setMaxNumberOfStars(5);
        this.initListeners();
    }

    private static int checkStyle(int style) {
        if ((style & 0x200) != 0) {
            style &= 0xFFFFFDFF;
        }
        if ((style & 0x100) != 0) {
            style &= 0xFFFFFEFF;
        }
        return style;
    }

    private void initListeners() {
        int[] events;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: 
                    case 6: {
                        StarRating.this.onMouseEnterOrMove(event);
                        break;
                    }
                    case 7: {
                        StarRating.this.onMouseExit(event);
                        break;
                    }
                    case 4: {
                        StarRating.this.onMouseUp(event);
                        break;
                    }
                    case 9: {
                        StarRating.this.onMousePaint(event);
                        break;
                    }
                    case 12: {
                        StarRating.this.onDispose(event);
                    }
                }
            }
        };
        int[] nArray = events = new int[]{6, 5, 7, 4, 9, 12};
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            int event = nArray[n2];
            this.addListener(event, listener);
            ++n2;
        }
    }

    private void onMouseEnterOrMove(Event event) {
        for (Star star : this.stars) {
            star.hover = false;
        }
        for (Star star : this.stars) {
            boolean mouseHover = star.bounds.contains(event.x, event.y);
            star.hover = true;
            if (mouseHover) break;
        }
        this.redraw();
        this.update();
    }

    private void onMouseExit(Event event) {
        for (Star star : this.stars) {
            star.hover = false;
        }
        this.redraw();
        this.update();
    }

    private void onMouseUp(Event event) {
        int i = 0;
        while (i < this.maxNumberOfStars) {
            Star star = this.stars.get(i);
            boolean selected = star.bounds.contains(event.x, event.y);
            if (selected) {
                this.setCurrentNumberOfStars(i + 1);
                this.fireSelectionEvent();
                this.redraw();
                this.update();
                break;
            }
            ++i;
        }
    }

    private void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this;
        event.display = this.getDisplay();
        event.item = this;
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private void onMousePaint(Event event) {
        GC gc = event.gc;
        int x = 0;
        int y = 0;
        for (Star star : this.stars) {
            star.draw(gc, x, y);
            if (this.orientation == 512) {
                y += this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
                continue;
            }
            x += this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
        }
    }

    private void onDispose(Event event) {
        for (Star star : this.stars) {
            star.dispose();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.orientation == 512) {
            return this.computeSizeVertical();
        }
        return this.computeSizeHorizontal();
    }

    private Point computeSizeVertical() {
        int width = this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
        int height = this.maxNumberOfStars * width;
        return new Point(width + this.getBorderWidth() * 2, height + this.getBorderWidth() * 2);
    }

    private Point computeSizeHorizontal() {
        int height = this.sizeOfStars.equals((Object)SIZE.BIG) ? 32 : 16;
        int width = this.maxNumberOfStars * height;
        return new Point(width + this.getBorderWidth() * 2, height + this.getBorderWidth() * 2);
    }

    public int getCurrentNumberOfStars() {
        this.checkWidget();
        return this.currentNumberOfStars;
    }

    public int getMaxNumberOfStars() {
        this.checkWidget();
        return this.maxNumberOfStars;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.orientation;
    }

    public SIZE getSizeOfStars() {
        this.checkWidget();
        return this.sizeOfStars;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(listener);
    }

    public void setCurrentNumberOfStars(int currentNumberOfStars) {
        this.checkWidget();
        if (currentNumberOfStars < 0 || currentNumberOfStars > this.maxNumberOfStars) {
            SWT.error((int)5);
        }
        this.currentNumberOfStars = currentNumberOfStars;
        for (Star star : this.stars) {
            star.marked = false;
        }
        int i = 0;
        while (i < currentNumberOfStars) {
            this.stars.get((int)i).marked = true;
            ++i;
        }
    }

    public void setMaxNumberOfStars(int maxNumberOfStars) {
        this.maxNumberOfStars = maxNumberOfStars;
        this.reinitStars();
    }

    private void reinitStars() {
        for (Star star : this.stars) {
            star.dispose();
        }
        this.stars.clear();
        int i = 0;
        while (i < this.maxNumberOfStars) {
            if (this.sizeOfStars.equals((Object)SIZE.BIG)) {
                this.stars.add(Star.initBig(this));
            } else {
                this.stars.add(Star.initSmall(this));
            }
            ++i;
        }
    }

    public void setSizeOfStars(SIZE sizeOfStars) {
        this.checkWidget();
        this.sizeOfStars = sizeOfStars;
        this.reinitStars();
    }

    public static enum SIZE {
        SMALL,
        BIG;

    }
}

