/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.ChoiceItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ChoiceWidget
extends Composite {
    private Image oldImage;
    private ChoiceItem choiceItem;
    private Label image;
    private Label instruction;
    private Label text;
    private final List<SelectionListener> selectionListeners;
    private boolean selection;
    private boolean insideComposite;
    private boolean insideImage;
    private boolean insideText;
    private boolean insideInstruction;

    public ChoiceWidget(Composite parent, int style) {
        super(parent, style);
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayout(2, false));
        this.buildGreenArrow();
        this.buildInstruction();
        this.buildText();
        this.addMouseListeners();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.addListener(11, event -> this.drawComposite());
    }

    private void buildGreenArrow() {
        Image greenArrow = SWTGraphicUtil.createImageFromFile((String)"images/arrowGreenRight.png");
        this.image = new Label((Composite)this, 0);
        this.image.setImage(greenArrow);
        this.image.setLayoutData((Object)new GridData(2, 1, false, false, 1, 2));
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)greenArrow);
    }

    private void buildInstruction() {
        Color color = new Color((Device)Display.getCurrent(), 35, 107, 178);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)color);
        this.instruction = new Label((Composite)this, 0);
        this.instruction.setForeground(color);
        this.instruction.setLayoutData((Object)new GridData(1, 1, false, false));
    }

    private void buildText() {
        this.text = new Label((Composite)this, 0);
        this.text.setForeground(this.getDisplay().getSystemColor(2));
        this.text.setLayoutData((Object)new GridData(1, 1, false, true));
    }

    private void addMouseListeners() {
        Listener mouseEnterListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget.equals((Object)ChoiceWidget.this)) {
                    ChoiceWidget.this.insideComposite = true;
                }
                if (event.widget.equals(ChoiceWidget.this.image)) {
                    ChoiceWidget.this.insideImage = true;
                }
                if (event.widget.equals(ChoiceWidget.this.text)) {
                    ChoiceWidget.this.insideText = true;
                }
                if (event.widget.equals(ChoiceWidget.this.instruction)) {
                    ChoiceWidget.this.insideInstruction = true;
                }
                ChoiceWidget.this.drawComposite();
            }
        };
        Listener mouseExitListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget.equals((Object)ChoiceWidget.this)) {
                    ChoiceWidget.this.insideComposite = false;
                }
                if (event.widget.equals(ChoiceWidget.this.image)) {
                    ChoiceWidget.this.insideImage = false;
                }
                if (event.widget.equals(ChoiceWidget.this.text)) {
                    ChoiceWidget.this.insideText = false;
                }
                if (event.widget.equals(ChoiceWidget.this.instruction)) {
                    ChoiceWidget.this.insideInstruction = false;
                }
                ChoiceWidget.this.drawComposite();
            }
        };
        Listener mouseClickListener = new Listener(){

            public void handleEvent(Event event) {
                for (SelectionListener selectionListener : ChoiceWidget.this.selectionListeners) {
                    selectionListener.widgetSelected(null);
                }
            }
        };
        this.addListener(6, mouseEnterListener);
        this.image.addListener(6, mouseEnterListener);
        this.text.addListener(6, mouseEnterListener);
        this.instruction.addListener(6, mouseEnterListener);
        this.addListener(7, mouseExitListener);
        this.image.addListener(7, mouseExitListener);
        this.text.addListener(7, mouseExitListener);
        this.instruction.addListener(7, mouseExitListener);
        this.addListener(4, mouseClickListener);
        this.image.addListener(4, mouseClickListener);
        this.text.addListener(4, mouseClickListener);
        this.instruction.addListener(4, mouseClickListener);
    }

    private void drawComposite() {
        boolean inside;
        Rectangle rect = this.getClientArea();
        Image newImage = new Image((Device)this.getDisplay(), Math.max(1, rect.width), Math.max(1, rect.height));
        GC gc = new GC((Drawable)newImage);
        boolean bl = inside = this.insideComposite || this.insideImage || this.insideInstruction || this.insideText;
        if (!inside && !this.selection) {
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.setForeground(this.getDisplay().getSystemColor(1));
            gc.drawRectangle(rect.x, rect.y, rect.width, rect.height);
        } else {
            Color gradientColor = inside ? new Color((Device)this.getDisplay(), 220, 231, 243) : new Color((Device)this.getDisplay(), 241, 241, 241);
            Color borderColor = inside ? new Color((Device)this.getDisplay(), 35, 107, 178) : new Color((Device)this.getDisplay(), 192, 192, 192);
            gc.setForeground(this.getDisplay().getSystemColor(1));
            gc.setBackground(gradientColor);
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
            gc.setForeground(borderColor);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1, 2, 2);
            gradientColor.dispose();
            borderColor.dispose();
        }
        gc.dispose();
        this.setBackgroundImage(newImage);
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.oldImage = newImage;
    }

    public ChoiceItem getChoiceItem() {
        return this.choiceItem;
    }

    public void setChoiceItem(ChoiceItem choiceItem) {
        this.choiceItem = choiceItem;
        this.instruction.setText(choiceItem.getInstruction());
        this.text.setText(choiceItem.getText());
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(boolean selection) {
        this.selection = selection;
    }
}

