/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.month.internal;

import java.util.Date;
import java.util.LinkedList;
import org.eclipse.nebula.widgets.compositetable.day.ICalendarableItemControl;
import org.eclipse.nebula.widgets.compositetable.month.internal.MonthCalendarableItemControl;
import org.eclipse.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class Day
extends Canvas
implements PaintListener,
DisposeListener {
    private final Color FOCUS_RUBBERBAND;
    private Color CURRENT_MONTH;
    private Color OTHER_MONTH;
    private Color CELL_BACKGROUND_LIGHT;
    private static final int FOCUS_LINE_WIDTH = 2;
    private boolean focusControl = false;
    private static final int _SIZE_MULTIPLIER = 7;
    private Label dayNumber = null;
    private Label spacer = null;
    private Point textBounds;
    private Point monthPosition = null;
    private LinkedList mouseListeners = new LinkedList();
    private MouseListener mouseListener = new MouseListener(){

        public void mouseDown(MouseEvent e) {
            Day.this.setFocus();
            for (MouseListener listener : Day.this.mouseListeners) {
                listener.mouseDown(e);
            }
        }

        public void mouseUp(MouseEvent e) {
            for (MouseListener listener : Day.this.mouseListeners) {
                listener.mouseUp(e);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            for (MouseListener listener : Day.this.mouseListeners) {
                listener.mouseDoubleClick(e);
            }
        }
    };
    private KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000003: {
                    if (((Day)Day.this).monthPosition.x > 0) {
                        Day.this.traverse(8);
                    }
                    return;
                }
                case 0x1000004: {
                    if (((Day)Day.this).monthPosition.x < 6) {
                        Day.this.traverse(16);
                    }
                    return;
                }
                case 9: {
                    if ((e.stateMask & 0x20000) != 0) {
                        Day.this.traverse(8);
                        return;
                    }
                    Day.this.traverse(16);
                    return;
                }
            }
        }
    };
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            Day.this.focusControl = true;
            Color background = Day.this.getBackgroundTakingIntoAccountIfWeAreInTheCurrentMonth(true);
            Day.this.resetAllBackgrounds((Composite)Day.this, background);
            Day.this.redraw();
        }

        public void focusLost(FocusEvent e) {
            Day.this.focusControl = false;
            Color background = Day.this.getBackgroundTakingIntoAccountIfWeAreInTheCurrentMonth(false);
            Day.this.resetAllBackgrounds((Composite)Day.this, background);
            Day.this.redraw();
        }
    };
    private boolean inCurrentMonth = false;
    private CalendarableItem[] controls = null;
    private Date date;

    public Day(Composite parent, int style) {
        super(parent, style);
        Display display = Display.getCurrent();
        this.FOCUS_RUBBERBAND = new Color((Device)display, this.lighten(this.saturate(display.getSystemColor(31).getRGB(), 0.85f), -0.333f));
        this.CURRENT_MONTH = display.getSystemColor(1);
        this.OTHER_MONTH = new Color((Device)display, new RGB(230, 230, 230));
        this.CELL_BACKGROUND_LIGHT = new Color((Device)display, new RGB(248, 248, 248));
        this.initialize();
        this.addTraverseListener(this.traverseListener);
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
        this.spacer.addMouseListener(this.mouseListener);
        this.dayNumber.addMouseListener(this.mouseListener);
        this.addFocusListener(this.focusListener);
        this.addPaintListener(this);
        this.addDisposeListener(this);
    }

    private RGB saturate(RGB color, float saturation) {
        float[] hsb = color.getHSB();
        return new RGB(hsb[0], saturation, hsb[2]);
    }

    private RGB lighten(RGB color, float amount) {
        float[] hsb = color.getHSB();
        float b = hsb[2] + hsb[2] * amount;
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        return new RGB(hsb[0], hsb[1], b);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.FOCUS_RUBBERBAND.dispose();
        this.OTHER_MONTH.dispose();
        this.CELL_BACKGROUND_LIGHT.dispose();
        this.removeTraverseListener(this.traverseListener);
        this.removeKeyListener(this.keyListener);
        this.removeMouseListener(this.mouseListener);
        this.spacer.removeMouseListener(this.mouseListener);
        this.dayNumber.removeMouseListener(this.mouseListener);
        this.removeFocusListener(this.focusListener);
        this.removePaintListener(this);
        this.removeDisposeListener(this);
    }

    private void initialize() {
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.spacer = new Label((Composite)this, 0);
        this.spacer.setLayoutData((Object)gridData);
        this.spacer.setBackground(Display.getCurrent().getSystemColor(25));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        this.dayNumber = new Label((Composite)this, 0);
        this.dayNumber.setBackground(Display.getCurrent().getSystemColor(25));
        this.dayNumber.setForeground(Display.getCurrent().getSystemColor(26));
        this.dayNumber.setText("31");
        this.textBounds = this.dayNumber.computeSize(-1, -1, true);
        this.setBackground(Display.getCurrent().getSystemColor(25));
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(106, 101));
        this.setBackground(this.CELL_BACKGROUND_LIGHT);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = new Point(0, 0);
        size.x = this.textBounds.x * 7;
        size.y = this.textBounds.y * 7 / 2;
        return size;
    }

    public Point getMonthPosition() {
        return this.monthPosition;
    }

    public void setMonthPosition(Point monthPosition) {
        this.monthPosition = monthPosition;
    }

    public int getDayNumber() {
        return Integer.parseInt(this.dayNumber.getText());
    }

    public void setDayNumber(int dayNum) {
        this.dayNumber.setText(Integer.toString(dayNum));
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        int oldLineStyle = gc.getLineStyle();
        int oldLineWidth = gc.getLineWidth();
        try {
            if (this.focusControl) {
                gc.setLineStyle(2);
                gc.setLineWidth(2);
                gc.setForeground(this.FOCUS_RUBBERBAND);
                Point parentSize = this.getSize();
                gc.drawRectangle(2, 2, parentSize.x - 4, parentSize.y - 3);
            }
        }
        finally {
            gc.setLineStyle(oldLineStyle);
            gc.setLineWidth(oldLineWidth);
        }
    }

    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        if (listener != this.mouseListener) {
            this.mouseListeners.add(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        if (listener != this.mouseListener) {
            this.mouseListeners.remove(listener);
        }
    }

    private void resetAllBackgrounds(Composite composite, Color color) {
        composite.setBackground(color);
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                this.resetAllBackgrounds((Composite)children[i], color);
            } else {
                children[i].setBackground(color);
            }
            ++i;
        }
    }

    private Color getBackgroundTakingIntoAccountIfWeAreInTheCurrentMonth(boolean focused) {
        if (this.inCurrentMonth && focused) {
            return this.CURRENT_MONTH;
        }
        if (this.inCurrentMonth) {
            return this.CELL_BACKGROUND_LIGHT;
        }
        return this.OTHER_MONTH;
    }

    public void setInCurrentMonth(boolean inCurrentMonth) {
        this.inCurrentMonth = inCurrentMonth;
        Color background = this.getBackgroundTakingIntoAccountIfWeAreInTheCurrentMonth(false);
        this.resetAllBackgrounds((Composite)this, background);
    }

    public void setItems(CalendarableItem[] controls) {
        ICalendarableItemControl control;
        int i;
        if (this.controls != null) {
            i = 0;
            while (i < this.controls.length) {
                control = this.controls[i].getControl();
                control.removeMouseListener(this.mouseListener);
                control.dispose();
                ++i;
            }
        }
        this.controls = controls;
        i = 0;
        while (i < this.controls.length) {
            control = new MonthCalendarableItemControl((Composite)this, 0);
            this.getBackgroundTakingIntoAccountIfWeAreInTheCurrentMonth(false);
            ((MonthCalendarableItemControl)control).setText(this.controls[i].getText());
            Image image = this.controls[i].getImage();
            if (image != null) {
                ((MonthCalendarableItemControl)control).setImage(image);
            }
            ((MonthCalendarableItemControl)control).setToolTipText(this.controls[i].getToolTipText());
            control.addMouseListener(this.mouseListener);
            GridData gd = new GridData(4, 128, true, false);
            gd.horizontalSpan = 2;
            control.setLayoutData(gd);
            this.controls[i].setControl(control);
            ++i;
        }
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }
}

