/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.nebulaslider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NebulaSlider
extends Canvas {
    private static final int H_MARGIN = 5;
    private static final int SELECTOR_WIDTH = 78;
    private static final int BAR_HEIGHT = 12;
    private static final int SELECTOR_HEIGHT = 32;
    private final Color barInsideColor = this.getAndDisposeColor(225, 225, 225);
    private final Color barBorderColor = this.getAndDisposeColor(211, 211, 211);
    private final Color barSelectionColor = this.getAndDisposeColor(41, 128, 185);
    private final Color selectorColor = this.getAndDisposeColor(52, 152, 219);
    private final Color selectorColorBorder = this.getAndDisposeColor(224, 237, 245);
    private final Color selectorTextColor = this.getAndDisposeColor(255, 255, 255);
    private final Color arrowColor = this.getAndDisposeColor(153, 203, 237);
    private int minimum;
    private int maximum;
    private int value = 0;
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private final Font textFont;
    private boolean moving = false;
    private int previousX;

    public NebulaSlider(Composite parent, int style) {
        super(parent, NebulaSlider.checkStyle(style) | 0x20000000);
        this.minimum = Integer.MIN_VALUE;
        this.maximum = Integer.MAX_VALUE;
        this.textFont = this.createTextFont();
        this.addPaintListener(e -> this.paintControl(e.gc));
        this.addMouseListeners();
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return style & 0xFFFFF7FF;
        }
        return 0;
    }

    private Color getAndDisposeColor(int r, int g, int b) {
        Color color = new Color((Device)this.getDisplay(), r, g, b);
        this.addDisposeListener(e -> {
            if (!color.isDisposed()) {
                color.dispose();
            }
        });
        return color;
    }

    private Font createTextFont() {
        FontData fontData = this.getFont().getFontData()[0];
        Font newFont = new Font((Device)this.getDisplay(), fontData.getName(), Math.max(fontData.getHeight(), 14), 1);
        this.addDisposeListener(e -> {
            if (!newFont.isDisposed()) {
                newFont.dispose();
            }
        });
        return newFont;
    }

    private void paintControl(GC gc) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        this.drawBar(gc);
        this.drawSelectionPart(gc);
        this.drawSelector(gc);
    }

    private void drawBar(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.barBorderColor);
        gc.setBackground(this.barInsideColor);
        int x = 44;
        int y = (rect.height - 12) / 2;
        int width = rect.width - 10 - 78;
        gc.fillRoundRectangle(44, y, width, 12, 12, 12);
        gc.drawRoundRectangle(44, y, width, 12, 12, 12);
    }

    private void drawSelectionPart(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.barBorderColor);
        gc.setBackground(this.barSelectionColor);
        int x = 44;
        int y = (rect.height - 12) / 2;
        int width = this.getPosition();
        gc.fillRoundRectangle(44, y, width, 12, 12, 12);
        gc.drawRoundRectangle(44, y, width, 12, 12, 12);
    }

    private int getPosition() {
        int originalWidth = this.getClientArea().width - 10 - 78;
        float coeff = (float)this.value * 1.0f / (float)(this.maximum - this.minimum);
        int position = (int)(coeff * (float)originalWidth);
        return position;
    }

    private void drawSelector(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.selectorColorBorder);
        gc.setBackground(this.selectorColor);
        int position = this.getPosition();
        int y = (rect.height - 32) / 2;
        gc.fillRoundRectangle(5 + position, y, 78, 32, 32, 32);
        gc.drawRoundRectangle(5 + position, y, 78, 32, 32, 32);
        gc.setForeground(this.arrowColor);
        gc.setLineWidth(3);
        int baseY = y + 16;
        gc.drawLine(5 + position + 10, baseY, 5 + position + 17, baseY - 7);
        gc.drawLine(5 + position + 10, baseY, 5 + position + 17, baseY + 7);
        gc.drawLine(5 + position + 78 - 10, baseY, 5 + position + 78 - 17, baseY - 7);
        gc.drawLine(5 + position + 78 - 10, baseY, 5 + position + 78 - 17, baseY + 7);
        gc.setForeground(this.selectorTextColor);
        gc.setFont(this.textFont);
        String valueAsString = String.valueOf(this.value);
        Point textSize = gc.textExtent(valueAsString);
        int xText = 5 + position + 39;
        gc.drawText(valueAsString, xText - textSize.x / 2, y + 2, true);
    }

    private void addMouseListeners() {
        this.addListener(3, e -> {
            int y;
            int position = this.getPosition();
            Rectangle rect = new Rectangle(position + 5, y = (this.getClientArea().height - 32) / 2, 78, 32);
            if (!rect.contains(e.x, e.y)) {
                return;
            }
            this.moving = true;
            this.previousX = this.getDisplay().getCursorLocation().x;
        });
        this.addListener(4, e -> {
            this.moving = false;
        });
        this.addListener(5, e -> {
            if (!this.moving) {
                return;
            }
            int deltaX = this.previousX - this.getDisplay().getCursorLocation().x;
            int originalWidth = this.getClientArea().width - 10 - 78;
            float step = (this.maximum - this.minimum) / originalWidth;
            this.value = (int)((float)this.value - (float)deltaX * step * 2.0f);
            if (this.value < this.minimum) {
                this.value = this.minimum;
            }
            if (this.value > this.maximum) {
                this.value = this.maximum;
            }
            this.previousX = this.getDisplay().getCursorLocation().x;
            this.fireSelectionEvent();
            this.redraw();
            this.update();
        });
    }

    private void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this;
        event.display = this.getDisplay();
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    public void addListener(int eventType, final Listener listener) {
        if (eventType == 13) {
            this.selectionListeners.add(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetSelection(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelection(e);
                }

                private void widgetSelection(SelectionEvent e) {
                    Event event = new Event();
                    event.widget = NebulaSlider.this;
                    event.display = NebulaSlider.this.getDisplay();
                    event.type = 13;
                    listener.handleEvent(event);
                }
            });
            return;
        }
        super.addListener(eventType, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(Math.max(300, wHint), Math.max(40, hHint));
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(listener);
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        if (minimum > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is greater than the maximum value (%d)", minimum, this.maximum)));
        }
        this.minimum = minimum;
        this.redraw();
        this.update();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        if (maximum < this.minimum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is lower than the minimum value (%d)", maximum, this.minimum)));
        }
        this.maximum = maximum;
        this.redraw();
        this.update();
    }

    public int getValue() {
        this.checkWidget();
        return this.value;
    }

    public void setValue(int value) {
        this.checkWidget();
        if (value < this.minimum || value > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is not int the range [%d - %d]", value, this.minimum, this.maximum)));
        }
        this.value = value;
        this.redraw();
        this.update();
    }
}

