/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.calculator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.calculator.CalculatorButtonsBehaviourEngine;
import org.eclipse.nebula.widgets.opal.calculator.CalculatorEngine;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

class CalculatorButtonsComposite
extends Composite {
    private static final String LABEL_C = "C";
    private static final String LABEL_CE = "CE";
    private static final String LABEL_BACK = "Back";
    private final Color darkRedColor;
    private final Color darkBlueColor;
    private final CalculatorEngine engine;
    private Label displayArea;
    private KeyListener keyListener;
    private final List<ModifyListener> modifyListeners;
    private final CalculatorButtonsBehaviourEngine behaviourEngine;
    private boolean readyToEnterNewNumber;

    CalculatorButtonsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(5, false));
        this.darkRedColor = new Color((Device)this.getDisplay(), 139, 0, 0);
        this.darkBlueColor = new Color((Device)this.getDisplay(), 0, 0, 139);
        this.createButtons();
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.darkBlueColor);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.darkRedColor);
        this.engine = new CalculatorEngine(this);
        this.behaviourEngine = new CalculatorButtonsBehaviourEngine(this);
        this.addKeyListeners();
        this.modifyListeners = new ArrayList<ModifyListener>();
    }

    private void createButtons() {
        Button buttonBackSpace = this.createButton(LABEL_BACK, this.darkRedColor);
        buttonBackSpace.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        buttonBackSpace.addListener(13, e -> this.behaviourEngine.processBackSpace());
        Button buttonCe = this.createButton(LABEL_CE, this.darkRedColor);
        buttonCe.addListener(13, e -> this.behaviourEngine.clearResult());
        Button buttonC = this.createButton(LABEL_C, this.darkRedColor);
        buttonC.addListener(13, e -> {
            this.behaviourEngine.clearResult();
            this.engine.cancel();
        });
        this.createDigitButton(7);
        this.createDigitButton(8);
        this.createDigitButton(9);
        Button buttonDivide = this.createButton("/", this.getDisplay().getSystemColor(3));
        buttonDivide.addListener(13, e -> this.engine.processOperation("/"));
        Button buttonSqrt = this.createButton("\u221a", this.darkRedColor);
        buttonSqrt.addListener(13, e -> this.engine.processSquareRootOperation());
        this.createDigitButton(4);
        this.createDigitButton(5);
        this.createDigitButton(6);
        Button buttonMultiply = this.createButton("*", this.getDisplay().getSystemColor(3));
        buttonMultiply.addListener(13, e -> this.engine.processOperation("*"));
        Button buttonInverse = this.createButton("1/x", this.darkBlueColor);
        buttonInverse.addListener(13, e -> this.engine.processInverseOperation());
        this.createDigitButton(1);
        this.createDigitButton(2);
        this.createDigitButton(3);
        Button buttonMinus = this.createButton("-", this.getDisplay().getSystemColor(3));
        buttonMinus.addListener(13, e -> this.engine.processOperation("-"));
        Button buttonPercent = this.createButton("%", this.darkBlueColor);
        buttonPercent.addListener(13, e -> this.engine.processPerCentageOperation());
        this.createDigitButton(0);
        Button buttonPlusMinus = this.createButton("+/-", this.getDisplay().getSystemColor(9));
        buttonPlusMinus.addListener(13, e -> this.engine.processSignChange());
        Button buttonDot = this.createButton(".", this.getDisplay().getSystemColor(9));
        buttonDot.addListener(13, e -> this.behaviourEngine.addDecimalPoint());
        Button buttonPlus = this.createButton("+", this.getDisplay().getSystemColor(3));
        buttonPlus.addListener(13, e -> this.engine.processOperation("+"));
        Button buttonEquals = this.createButton("=", this.getDisplay().getSystemColor(3));
        buttonEquals.addListener(13, e -> this.engine.processEquals());
    }

    private void createDigitButton(int digit) {
        Button button = this.createButton(" " + digit + " ", this.getDisplay().getSystemColor(9));
        button.addListener(13, e -> this.behaviourEngine.addDigitToDisplay(digit));
    }

    private Button createButton(String label, Color color) {
        Button button = new Button((Composite)this, 0x20000008);
        button.setText("");
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = 30;
        button.setLayoutData((Object)gd);
        button.addPaintListener(e -> {
            e.gc.setForeground(color);
            e.gc.setFont(this.getFont());
            Point textSize = e.gc.textExtent(" " + label + " ", 0x40000000);
            e.gc.drawText(" " + label + " ", (button.getBounds().width - textSize.x) / 2, (button.getBounds().height - textSize.y) / 2, true);
        });
        return button;
    }

    private void addKeyListeners() {
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        CalculatorButtonsComposite.this.behaviourEngine.addDigitToDisplay(Integer.parseInt(String.valueOf(e.character)));
                        return;
                    }
                    case '.': {
                        CalculatorButtonsComposite.this.behaviourEngine.addDecimalPoint();
                        return;
                    }
                    case '+': {
                        CalculatorButtonsComposite.this.engine.processOperation("+");
                        return;
                    }
                    case '-': {
                        CalculatorButtonsComposite.this.engine.processOperation("-");
                        return;
                    }
                    case '*': {
                        CalculatorButtonsComposite.this.engine.processOperation("*");
                        return;
                    }
                    case '/': {
                        CalculatorButtonsComposite.this.engine.processOperation("/");
                        return;
                    }
                    case '=': {
                        CalculatorButtonsComposite.this.engine.processEquals();
                        return;
                    }
                    case '%': {
                        CalculatorButtonsComposite.this.engine.processPerCentageOperation();
                        return;
                    }
                }
                switch (e.keyCode) {
                    case 0x1000030: 
                    case 0x1000031: 
                    case 16777266: 
                    case 0x1000033: 
                    case 16777268: 
                    case 16777269: 
                    case 16777270: 
                    case 16777271: 
                    case 16777272: 
                    case 16777273: {
                        int digit = e.keyCode - 0x1000000 - 47;
                        CalculatorButtonsComposite.this.behaviourEngine.addDigitToDisplay(digit);
                        return;
                    }
                    case 16777259: {
                        CalculatorButtonsComposite.this.engine.processOperation("+");
                        return;
                    }
                    case 16777261: {
                        CalculatorButtonsComposite.this.engine.processOperation("-");
                        return;
                    }
                    case 16777263: {
                        CalculatorButtonsComposite.this.engine.processOperation("/");
                        return;
                    }
                    case 16777258: {
                        CalculatorButtonsComposite.this.engine.processOperation("*");
                        return;
                    }
                    case 13: 
                    case 16777277: 
                    case 0x1000050: {
                        CalculatorButtonsComposite.this.engine.processEquals();
                        return;
                    }
                    case 8: {
                        CalculatorButtonsComposite.this.behaviourEngine.processBackSpace();
                        return;
                    }
                    case 27: {
                        CalculatorButtonsComposite.this.behaviourEngine.clearResult();
                        CalculatorButtonsComposite.this.engine.cancel();
                        return;
                    }
                }
            }
        };
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addKeyListener(this.keyListener);
            ++n2;
        }
        this.addKeyListener(this.keyListener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.modifyListeners.add(listener);
    }

    void fireModifyListeners() {
        for (ModifyListener listener : this.modifyListeners) {
            Event e = new Event();
            e.widget = this;
            ModifyEvent modifyEvent = new ModifyEvent(e);
            listener.modifyText(modifyEvent);
        }
    }

    KeyListener getKeyListener() {
        return this.keyListener;
    }

    Label getDisplayArea() {
        return this.displayArea;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.modifyListeners.remove(listener);
    }

    void setDisplayArea(Label text) {
        this.displayArea = text;
    }

    void setReadyToEnterNewNumber(boolean newValue) {
        this.readyToEnterNewNumber = newValue;
    }

    boolean isReadyToEnterNewNumber() {
        return this.readyToEnterNewNumber;
    }
}

